/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.controller;

import cn.gtmap.onemap.platform.entity.FileStore;
import cn.gtmap.onemap.platform.event.JSONMessageException;
import cn.gtmap.onemap.platform.service.FileStoreService;
import cn.gtmap.onemap.platform.support.spring.BaseController;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/file"})
public class FileStoreController
extends BaseController {
    @Autowired
    private FileStoreService fileStoreService;

    @RequestMapping(value={"/upload/{parentId}"}, method={RequestMethod.POST})
    @ResponseBody
    public String upload(@PathVariable String parentId, HttpServletRequest request) {
        try {
            FileStore fs = this.fileStoreService.save(request, parentId);
            if (fs != null) {
                return fs.getId();
            }
            throw new RuntimeException("\u672a\u83b7\u53d6\u4e0a\u4f20\u6570\u636e");
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("file.upload.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/upload2/{parentId}"}, method={RequestMethod.POST})
    @ResponseBody
    public String upload2(@PathVariable String parentId, MultipartHttpServletRequest request) {
        try {
            FileStore fs = this.fileStoreService.save2(request, parentId);
            if (fs != null) {
                return fs.getParentId();
            }
            throw new RuntimeException("\u672a\u83b7\u53d6\u4e0a\u4f20\u6570\u636e");
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("file.upload.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/ids/{parentId}"})
    @ResponseBody
    public String[] ids(@PathVariable String parentId) {
        try {
            Assert.notNull((Object)parentId, (String)this.getMessage("file.parentId.notnull", new Object[0]));
            return this.fileStoreService.getFileIds(parentId);
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("file.ids.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/download/{id}"})
    public void download(@PathVariable String id, HttpServletResponse response) {
        try {
            Assert.notNull((Object)id, (String)this.getMessage("id.notnull", new Object[0]));
            File file = this.fileStoreService.getFile(id);
            this.sendFile((InputStream)new FileInputStream(file), response, file.getName());
        }
        catch (IOException e) {
            throw new JSONMessageException(this.getMessage("file.download.error", new Object[]{id, e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/thumb/{id}"})
    public void thumb(@PathVariable String id, HttpServletResponse response) {
        try {
            Assert.notNull((Object)id, (String)this.getMessage("id.notnull", new Object[0]));
            this.sendFile(this.fileStoreService.getThumb(id), response);
        }
        catch (IOException e) {
            throw new JSONMessageException(this.getMessage("file.thumb.error", new Object[]{id, e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/delete/{id}"})
    @ResponseBody
    public void delete(@PathVariable String id) {
        try {
            Assert.notNull((Object)id, (String)this.getMessage("id.notnull", new Object[0]));
            this.fileStoreService.delete(id);
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("file.delete.error", new Object[]{id, e.getLocalizedMessage()}));
        }
    }
}

