package cn.gtmap.onemap.platform.utils;

import cn.gtmap.onemap.platform.Constant;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * .
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 13-6-3 下午1:49
 */
public final class Utils {

    public static final int REGION_CODE_MAX_LENGTH = 6;

    private static final Map<String, String> wellKnownSimplePrefixes = new HashMap<String, String>(4);

    private static final Map<String, String> wellKnownSimpleRegexs= new HashMap<String, String>(4);

    static String regExOfchinese = "[\\u4e00-\\u9fa5]";
    static Pattern pattern = Pattern.compile(regExOfchinese);

    static {
        wellKnownSimplePrefixes.put("}", "{");
        wellKnownSimplePrefixes.put("]", "[");
        wellKnownSimplePrefixes.put(")", "(");

        wellKnownSimpleRegexs.put("${","\\$\\{+|\\}");
        wellKnownSimpleRegexs.put("{","\\{+|\\}");
    }


    /**
     * formate region code
     *
     * @param value
     * @return
     */
    public static final String formatRegionCode(String value) {
        Assert.notNull(value, "region code can't be null");
        final int maxLength = REGION_CODE_MAX_LENGTH;
        StringBuilder sb = new StringBuilder();
        sb.append(value);
        if(StringUtils.startsWith(sb.toString(),"3"))
        {
            while (sb.length() < maxLength) {
                sb.append("0");
            }
        }
        return sb.toString();
    }


    /**
     * 替换占位符${}
     * @param data
     * @param params
     * @return
     * @throws Exception
     */
    public static String replaceHolder(String data, Map<String, Object> params) throws Exception {
        String result = data;
        String[] values = data.split("\\$\\{+|\\}");
        for (int i = 0; i < values.length; i++) {
            if (params.containsKey(values[i]))
                result = result.replaceAll("\\$\\{" + values[i] + "\\}", String.valueOf(params.get(values[i])));
        }
        return result;
    }

    /***
     * 替换占位符${0}..
     * @param data
     * @param params  不定参数 对应 字符串中的　0,1,2..
     * @return
     * @throws Exception
     */
    public static String replaceHolder(String data, Object... params) throws Exception {
        String result = data;
        String[] values = data.split("\\$\\{+|\\}");
        for (int i = 0; i < values.length; i++) {
            if (params[i] != null)
                result = result.replaceAll("\\$\\{" + values[i] + "\\}", String.valueOf(params[i]));
        }
        return result;
    }

    /**
     * replace placeholder with custom prefix /suffix
     * @param placeholderPrefix
     * @param placeholderSuffix
     * @param data
     * @param params
     * @return
     * @throws Exception
     */
    public static String replaceHolder(String placeholderPrefix, String placeholderSuffix,String data, Map<String, Object> params) throws Exception {
        String result = data;
        String simplePrefixForSuffix = wellKnownSimplePrefixes.get(placeholderSuffix);
        if (simplePrefixForSuffix != null && placeholderPrefix.endsWith(simplePrefixForSuffix)) {
            placeholderPrefix = simplePrefixForSuffix;
        }
        String[] values = data.split(wellKnownSimpleRegexs.get(placeholderPrefix) == null ? "\\$\\{+|\\}" : wellKnownSimpleRegexs.get(placeholderPrefix));
        for (int i = 0; i < values.length; i++) {
            if (params.containsKey(values[i]))
                result = result.replaceAll("\\{" + values[i] + "\\}", String.valueOf(params.get(values[i])));
        }
        return result;
    }



    /***
     * 替换url占位符${} 并对替换的参数值进行编码
     * @param data
     * @param params
     * @return
     * @throws Exception
     */
    public static String urlReplaceHolder(String data, Map<String, Object> params) throws Exception {
        String result = data;
        String[] values = data.split("\\$\\{+|\\}");
        for (int i = 0; i < values.length; i++) {
            if (params.containsKey(values[i]))
                result = result.replaceAll("\\$\\{" + values[i] + "\\}", URLEncoder.encode(MapUtils.getString(params, values[i]), Constant.UTF_8));
        }
        return result;
    }

    /***
     * update/create hash map
     * @param key
     * @param value
     * @param map
     * @return
     */
    public static Map updateMap(Object key,Object value,Map map){
        Map result = new HashMap();
        result.put(key, value);
        if (map != null && !map.isEmpty()) {
            result.putAll(map);
        }
        return result;
    }

    /***
     * contain chinese char
     * @param value
     * @return
     */
    public static boolean isContainChinese(String value) {
        Matcher matcher = pattern.matcher(value);
        boolean flg = false;
        if (matcher.find()) {
            flg = true;
        }
        return flg;
    }



}
