package cn.gtmap.onemap.platform.utils;

import com.alibaba.fastjson.JSON;

import java.util.Arrays;
import java.util.List;

/**
 * 枚举辅助类
 * @author: <a href="mailto:yxfacw@live.com">yingxiufeng</a>
 * @date: 2013-08-09 下午2:15
 * @version: 1.0
 */
public final class EnumUtils {

    public  enum TDYTQ {

        基本农田保护区("010"),
        一般农地区("020"),
        城镇建设用地区("030"),
        村镇建设用地区("040"),
        独立工矿用地区("050"),
        风景旅游用地区("060"),
        生态环境安全控制区("070"),
        自然与文化遗产保护区("080"),
        林业用地区("090"),
        牧业用地区("100"),
        其他用地区("990");

        private String lxdm;

        private TDYTQ(String value) {
            this.lxdm = value;
        }

        public String getLxdm() {
            return lxdm;
        }
    }

    public enum JSYDGZQ {

        允许建设用地区("010"),
        有条件建设用地区("020"),
        限制建设用地区("030"),
        禁止建设用地区("040");

        private String lxdm;

        private JSYDGZQ(String value) {
            this.lxdm = value;
        }

        public String getLxdm() {
            return lxdm;
        }
    }

    public enum GHJBNTTZ {

        保留基本农田("00"),
        调入基本农田("01"),
        调出基本农田("02");

        private String lxdm;

        private GHJBNTTZ(String value) {
            this.lxdm = value;
        }

        public String getLxdm() {
            return lxdm;
        }
    }

    public enum MZZDJSXM {

        能源("01"),
        交通("02"),
        水利("03"),
        电力("04"),
        环保("05"),
        其他("99");

        private String lxdm;

        private MZZDJSXM(String value) {
            this.lxdm = value;
        }

        public String getLxdm() {
            return lxdm;
        }
    }

    /***
     * 土地利用现状所有分类
     */
    public enum TDLYXZ {
        水田("011"),
        水浇地("012"),
        旱地("013"),
        果园("021"),
        茶园("022"),
        其他园地("023"),
        有林地("031"),
        灌木林地("032"),
        其他林地("033"),
        天然牧草地("041"),
        人工牧草地("042"),
        其他草地("043"),
        城市("201"),
        建制镇("202"),
        村庄("203"),
        采矿用地("204"),
        风景名胜及特殊用地("205"),
        铁路用地("101"),
        公路用地("102"),
        农村道路("104"),
        机场用地("105"),
        港口码头用地("106"),
        管道运输用地("107"),
        河流水面("111"),
        湖泊水面("112"),
        水库水面("113"),
        坑塘水面("114"),
        沿海滩涂("115"),
        内陆滩涂("116"),
        水渠("117"),
        水工建筑用地("118"),
        冰川及永久积雪("119"),
        设施农用地("122"),
        田坎("123"),
        盐碱地("124"),
        沼泽地("125"),
        沙地("126"),
        裸地("127");

        private String dlbm;

        private TDLYXZ(String value) {
            this.dlbm = value;
        }

        public String getDlbm() {
            return this.dlbm;
        }
    }

    /***
     * 综合分析的分析类型
     * tdlygh --- for mas
     */
    public enum MULTI_ANALYZE_TYPE {
        xz, gh, bp, gd, dj, kc,cl,sp,sgbwm,tdlygh
    }

    /***
     * 吴中区综合分析类型
     * @since v2.1.2
     */
    public enum WZ_ANALYZE_TYPE{
        zd,gd,zhd,xz
    }

    /***
     * 综合分析 级别 标准/吴中/马鞍山/.etc
     */
    public enum MULTI_ANALYZE_LEVEL{
        standard,wuzhong,mas
    }

    /***
     * 土地利用现状三大类
     */
    public enum TDLYXZ_THREE_TYPE {
        TILTH("011,012,013"),
        FARM("011,012,013,021,022,023,031,032,033,041,042,104,114,117,122,123"),
        BUILD("101,102,105,106,107,113,118,201,202,203,204,205"),
        UNUSED("111,112,115,116,119,043,124,125,126,127");

        private String[] dlbms;

        private TDLYXZ_THREE_TYPE(String value) {
            this.dlbms = value.split(",");
        }

        public String[] getDlbms() {
            return dlbms;
        }

        public boolean isContained(String value) {
            List<String> dlbms = Arrays.asList(getDlbms());
            if (dlbms.contains(value)) return true;
            return false;
        }
    }

    /**
     * 获取tdlyxz by dlbm
     * @param value
     * @return
     */
    public static final TDLYXZ findByDlbm(String value){

        if (value!=null)
        {
            for (int i=0;i<TDLYXZ.values().length;i++)
            {
                if(TDLYXZ.values()[i].getDlbm().equals(value))
                    return TDLYXZ.values()[i];
            }
        }
        return null;
    }
}
