package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.platform.service.SDEManager;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeInstance;
import org.springframework.stereotype.Service;

/**
 * .
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 13-1-6 上午11:09
 */
@Service
public class SDEManagerImpl implements SDEManager {
    /**
     * 获取对应实例
     *
     * @param server
     * @param port
     * @return
     */
    public SeInstance getInstance(String server, int port) throws SeException {
        return new SeInstance(server, port);
    }

    /**
     * 开启sde服务
     *
     * @param server
     * @param port
     * @param database
     * @param password
     */
    public void startInstance(String server, int port, String database, String password) throws SeException {
        SeInstance instance = getInstance(server, port);
        if (instance != null) {
            instance.start(database, password);
        }
    }

    /**
     * 关闭sde服务
     *
     * @param server
     * @param port
     * @param password
     */
    public void stopInstance(String server, int port, String password) throws SeException {
        SeInstance instance = getInstance(server, port);
        if (instance != null) {
            instance.shutdown(password);
        }
    }

    /**
     * 获取sde配置信息
     *
     * @param server
     * @param port
     * @param password
     * @return
     */
    public SeInstance.SeInstanceConfiguration getConfiguration(String server, int port, String password) throws SeException {
        SeInstance instance = getInstance(server, port);
        if (instance != null) {
            return instance.getConfiguration();
        }
        return null;
    }


}
