package cn.gtmap.onemap.platform.entity;

import cn.gtmap.onemap.core.entity.AbstractEntity;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.Date;
import java.util.Map;

/**
 * .界址点
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 13-8-13 下午5:25
 */
@Entity
@Table(name = "omp_bmark")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class BMark extends AbstractEntity {

    @Lob
    @Basic(fetch = FetchType.LAZY)
//    @Column(columnDefinition = "CLOB", nullable = true)
    private String coordinate;

    @Column(name = "pro_id", length = 32, nullable = false)
    private String proId;

    public BMark() {
        setCreateAt(new Date());
        setName(getClass().getSimpleName());
    }

    public String getProId() {
        return proId;
    }

    public void setProId(String proId) {
        this.proId = proId;
    }

    public String getCoordinate() {
        return coordinate;
    }

    public void setCoordinate(String coordinate) {
        this.coordinate = coordinate;
    }

    /*public Date getCreateAt() {
        return createAt;
    }

    public void setCreateAt(Date createAt) {
        this.createAt = createAt;
    }*/

    @Override
    public String toString() {
        return " PROID : " + getProId() + "\nCoordinate : " + getCoordinate();
    }
}
