package cn.gtmap.onemap.platform.controller.portal;

import java.util.ArrayList;
import java.util.List;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import cn.gtmap.onemap.model.Layer;
import cn.gtmap.onemap.platform.entity.Configuration;
import cn.gtmap.onemap.platform.entity.Function;
import cn.gtmap.onemap.platform.service.MapService;
import cn.gtmap.onemap.service.MetadataService;

@Controller
@RequestMapping("/portal")
public class FuncConfigController {
	@Autowired
	private MapService mapService;
	@Autowired
	private MetadataService metadataService;

	/**
	 * 保存Function
	 * 
	 */
	@RequestMapping(value = "/{tpl}/{serviceId}/savefunction", method = RequestMethod.POST)
	@ResponseBody
	public String saveFunc(@PathVariable(value = "tpl") String tpl,
			@PathVariable String serviceId, Function func,
			RedirectAttributes ra) {
		// 根据 tpl service type 来更新 function
		mapService.saveFunction(func, serviceId, tpl);
		return "success";
	}
	/**
	 * 查询Function
	 * 
	 */
	@RequestMapping(value = "/{tpl}/function/{view}/{serviceId}")
	public String queryFunc(@PathVariable(value = "tpl") String tpl,
			@PathVariable String view, @PathVariable String serviceId,
			Model model) {
		Configuration cg = mapService.getConfigByTpl(tpl);
		model.addAttribute("tplName", cg.getName());
		model.addAttribute("config", cg);
		model.addAttribute("service", mapService.getService(serviceId, tpl));
		model.addAttribute("tpl", tpl);
		model.addAttribute("view", view);

		List<Layer> layers = metadataService.getLayers(serviceId);
        List<String> layerIds=new ArrayList<String>();
		for (Layer temp : layers) {
            layerIds.add(temp.getId());
		}
        model.addAttribute("layers", layers);
        model.addAttribute("fieldsMap", metadataService.batchGetFields(layerIds));

		Function.Type type = Enum.valueOf(Function.Type.class, view.trim().toUpperCase());

		Function function = mapService.getFunctionByType(serviceId, type.getId(), tpl);
		model.addAttribute("type", type.getId());
		
		if (function == null)
			model.addAttribute("function", new Function());
		else
			model.addAttribute("function", function);
		
		return "portal/service/func-config/" + view + "_function";
	}
}