<html>
<head>
    <meta charset=utf-8/>
    <title>位置图</title>
    <meta name='viewport' content='initial-scale=1,maximum-scale=1,user-scalable=no'/>
    <link rel="stylesheet" href="<@com.rootPath/>/static/tp/leaflet/leaflet.css"/>
    <script src="<@com.rootPath/>/static/tp/leaflet/leaflet.js"></script>
    <script src="<@com.rootPath/>/static/tp/leaflet/esri-leaflet.js"></script>
    <script src="<@com.rootPath/>/static/js/JSONUtil.js"></script>
    <style>
        body {
            margin: 0;
            padding: 0;
        }

        #map {
            position: absolute;
            top: 0;
            bottom: 0;
            right: 0;
            left: 0;
            width: 100%;
            height: 100%;
        }
    </style>
</head>
<body>
<div id="map"></div>
<script>
    L.esri.Support.cors = false;
    var ompUrl = '${path_omp!}';
    var geo = window.localStorage.getItem('localData');
    var tmp = JSONUtil.decode(geo);
    var feature = tmp.sketch;
    if (feature != undefined) {
        // 进行坐标转换
        project();
    }

    /**
     * 投影变换
     */
    function project() {
        var crs = feature.crs || {type: 'name', properties: {name: 'EPSG:2364'}};
        if (crs == undefined) {
            console.error('Crs is needed!');
            return;
        } else {
            var inSr = crs.type === 'name' ? crs.properties.name : crs.properties.value;
            console.info("--input sr is ---" + inSr);
            L.esri.post(ompUrl + '/geometryService/rest/project', {
                geometry: JSONUtil.encode(feature),
                inSR: inSr,
                outSR: "4490"
            }, function (error, response) {
                if (error) {
                    console.log(error);
                } else {
                    feature = JSONUtil.decode(response.result);
                    console.log(feature);
                    initMap();
                }
            });
        }
    }

    /**
     * 初始化地图
     */
    function initMap() {
        var map = L.map('map');
        var geojsonLayer = L.geoJson(feature, {
            style: {
                color: '#009688',
                weight: 2
            },
            onEachFeature: onEachFeature
        }).addTo(map);
        map.fitBounds(geojsonLayer.getBounds().pad(0.2));
    }

    var popupTpl = "<h3>{title}</h3><h3>{area}</h3>";
    /**
     *
     * @param feature
     * @param layer
     */
    function onEachFeature(feature, layer) {
        if (feature.properties) {
            var p = feature.properties;
            var html = L.Util.template(popupTpl, {title: p.NAME || p.PRONAME || '导入地块', area: p.SHAPE_AREA});
            layer.bindPopup(html);
        }
    }
</script>
</body>
</html>