/**
 * Created by alex on 2017/7/23.
 * admin 系统设置页面
 */
layui.define(['jquery', 'element', 'form', 'layer', 'laytpl', 'table'], function (exports) {
    //引入此模块对应的样式文件
    layui.link('/oma/static/css/admin.css');
    var element = layui.element;
    var $ = layui.jquery, layer = layui.layer, form = layui.form, laytpl = layui.laytpl, table = layui.table;

    var tabFilter = 'admin';
    var existTabs = [];
    var currTabIndex = 0;

    var models, dicts = [];
    var rule = undefined;

    /**
     * 变量赋值
     * @param data
     */
    function initVars(data) {
        models = $.parseJSON(data.models);
        rule = $.parseJSON(data.rule);
        dicts = $.parseJSON(data.dicts);
    }

    /**
     * 同步分析模型属性
     * @param data
     */
    function syncModels(data) {
        layui.each(models, function (idx, item) {
            if (item.id === data.id) {
                item = data;
            }
        });
    }

    /**
     * 生成随机id
     * @param len 返回长度
     * @param radix 进制
     * @returns {string}
     */
    function uuid(len, radix) {
        var chars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'.split('');
        var uuid = [], i;
        radix = radix || chars.length;

        if (len) {
            for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random() * radix];
        } else {
            var r;

            uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
            uuid[14] = '4';

            for (i = 0; i < 36; i++) {
                if (!uuid[i]) {
                    r = 0 | Math.random() * 16;
                    uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
                }
            }
        }

        return uuid.join('');
    }

    /**
     * 判断一个对象是否是数组，参数不是对象或者不是数组，返回false
     *
     * @param {Object} arg 需要测试是否为数组的对象
     * @return {Boolean} 传入参数是数组返回true，否则返回false
     */
    function isArray(arg) {
        if (typeof arg === 'object') {
            return Object.prototype.toString.call(arg) === '[object Array]';
        }
        return false;
    }


    /**
     * 初始化
     */
    function initEvents() {
        element.init();
        //显隐左侧导航
        $(".hide-menu").on('click', function () {
            $(".admin-layout-main").toggleClass("hide-aside");
        });

        //左侧导航切换事件
        element.on('nav(admin)', function (elem) {
            var layid = $(elem).data('tid');
            var title = $(elem).find("a > cite").text();
            var exists = existsTab(layid);
            //若已经存在 则切换到该tab 否则增加这个tab
            if (exists) {
                element.tabChange(tabFilter, layid);
            } else {
                addTab(layid, $(elem).find('a > i').html(), title,
                    renderPage($("#" + layid + "Tpl").html(), {models: models, rule: rule, dicts: dicts}), true);
                form.render();//重新渲染form
                //设定tab-content的最大高度
                $(".layui-tab-content").css('max-height', window.innerHeight - 140);

                if (layid === 'rule') {
                    ruleEventListener();
                    return;
                }
                if (layid === 'other') {
                    otherEventListener();
                    return;
                }
                if (layid === 'analysis') {
                    new addListeners().analysisEventListener();
                    return;
                }
            }
        });

        //监听tab切换事件
        element.on('tab(admin)', function (data) {
            //保存当前选中的tab index
            currTabIndex = data;
        });

        //监听编辑保存事件
        table.on('tool(analysisTable)', function (obj) {
            if (obj.data.id === null || obj.data.id === undefined) {
                layer.msg('请输入ID');
                return;
            }
            //修改数据进行更新
            if (obj.event === 'save') {
                var id = obj.data.id;
                for (var i = 0; i < models.length; i++) {
                    if (models[i].id === obj.data.id) {
                        models[i] = obj.data;
                    }
                }
                //传入数据保存
                new addListeners().saveData(models, "保存成功");
            }

            //弹出数据
            if (obj.event === 'param') {
                var id = obj.data.id;
                for (var i = 0; i < models.length; i++) {
                    if (models[i].id === obj.data.id) {
                        new addListeners(models[i].params).data_info();
                    }
                }
            }
        });

    }

    var ALIAS_MAPPING = {
        funid: "ID",
        year: "年份",
        dltb: "地类图斑",
        xzdw: "现状地物"

    };

    /**
     * 分析设置监听页面
     * @param layid
     */
    function addListeners(params) {
        /**
         * 参数弹框及详情
         */
        this.data_info = function () {
            var idx = -1;
            var paramsIsArray = isArray(params); //判断是否为数组
            if (typeof(params) == "undefined" || !paramsIsArray) {
                form_val = "<div style='text-align: center;font-size: 25px;margin-top: 80px'>" + "无参数" + "</div>" + "<div><ul class=\"models-new-list\"></div>";
            } else {
                var form_val = "";//最后结果值
                //循环数组
                for (var i = 0; i < params.length; i++) {
                    var arr = [];
                    var p = params[i];
                    $.each(p, function (key, val) {
                        var tmp = {};
                        var nKey = ALIAS_MAPPING[key] || key;
                        $.extend(tmp, {
                            name: key,
                            alias: nKey,
                            val: val
                        });
                        arr.push(tmp);
                    });
                    if (arr.length > 0) {
                        form_val += renderPage($("#paramsTpl").html(), {data: arr});
                    }
                }

            }
            //参数弹出框
            var addItemTpl = '<form class="layui-form layui-form-pane param-form">' +
                '<div class="layui-form-item">' +
                '<input type="text" name="addName" value="{{ d.key }}" class="layui-input" style="width: 150px;float:left">' +
                '<div class="layui-input-inline">' +
                '<input type="text" name="addValue" value="{{ d.value }}" autocomplete="off" class="layui-input">' +
                '</div><a class="layui-btn layui-btn-mini layui-btn-danger models-item-del"><i class="layui-icon">&#x1006;</i></a>' +
                '</div><div>' +
                '<ul class="models-new-list"> </ul>' +
                '</div>' +
                '</form>';
            layer.open({
                type: 1
                , title: '参数详情'
                , area: ['450px', '300px']
                , shade: 0.5
                , maxmin: true
                , btn: ['添加', '保存']
                , btn1: function () {
                    idx = idx + 1;
                    $(".layui-layer-content").append(renderPage(addItemTpl, {key: '', value: '', index: idx}));
                    $('.models-item-del').on('click', function () {
                        $(this).parent().parent().remove();
                    });
                }
                , btn2: function () {
                    $.each($(".param-form"), function (idx, form) {
                        var arr = $(form).serializeArray();
                        var tmp = {};
                        for (var i = 0; i < arr.length; i++) {
                            if (arr[i].name === 'addName') {
                                tmp[arr[i].value] = arr[i + 1].value;
                                break;
                            } else {
                                tmp[arr[i].name] = arr[i].value;
                            }
                        }
                        if (params.length <= idx) {
                            params.push(tmp);
                        }
                        else {
                            $.extend(params[idx], tmp);
                        }
                    });
                    submit(function () {
                        layer.closeAll();
                    });
                }
                , content: form_val
                , zIndex: layer.zIndex
                , success: function (layero) {
                    var btn = layero.find('.layui-layer-btn');
                    btn.find('.layui-layer-btn1').attr({"lay-filter": "formNewModels", "lay-submit": "formNewModels"});
                    layer.setTop(layero);
                }
            });
        };

        /**
         * 保存数据
         * @param data
         */
        this.saveData = function (data, state) {
            models = data;
            if (state != "新增保存") {
                layer.msg('提交数据中...', {
                    icon: 16,
                    shade: 0.6,
                    time: false,
                    shift: 0
                });
            }
            $.ajax({
                type: 'POST',
                url: '/oma/admin/rest/save',
                data: {analyzeSet: JSON.stringify({dicts: dicts, rule: rule, models: models})},
                dataType: 'json',
                success: function (ret) {
                    layer.closeAll();
                    if (ret.msg) {
                        layer.alert('提交失败：' + ret.msg, {title: '提示', icon: 5, shift: 16});
                        return;
                    }
                    if (state === "删除成功") {
                        layer.open({
                            title: false
                            , closeBtn: false
                            , content: "<div font-size='16px'><b>&nbsp 是否删除</b></div>"
                            , btn: ['删除', '取消']
                            , yes: function () {
                                layer.msg(state, {icon: 1, time: 2000});
                                refreshActiveTab(renderPage($('#analysisTpl').html(), {models: models}));
                                form.render();
                                new addListeners().analysisEventListener();
                            }
                            , btn2: function () {
                                return;
                            }
                        });
                    } else {
                        if (state != "新增保存") {
                            layer.msg(state, {icon: 1, time: 2000});
                        }
                        refreshActiveTab(renderPage($('#analysisTpl').html(), {models: models}));
                        form.render();
                        new addListeners().analysisEventListener();
                    }

                }
            });


        };

        /**
         * 操作点击事件
         */
        this.click = function () {
            $(".layui-btn.layui-btn-normal.layui-btn-mini").on('click', function () {
                var models_ = [];
                // 根据exist判断是否为已有数据
                var exist = $(this).parent().parent().attr("name");
                //对已有数据进行更新
                if (exist != null && exist != "" && exist != undefined) {
                    data_id = $(this).parent().parent().children('td').eq(1).attr("value");
                    var name = $(this).parent().parent().children('td').eq(2).find("input").val();
                    models_ = models;
                    for (var j = 0; j < models_.length; j++) {
                        if (models_[j].id == data_id) {
                            models_[j].name = name;
                            break;
                        }
                    }
                }
                else {
                    //新增数据进行保存
                    var data_id = $("#id").val();
                    if (data_id == "") data_id = Math.random() + "id";
                    var newData = {
                        id: data_id,
                        layerName: $("#layerName").val(),
                        dataSource: $("#dataSource").val(),
                        name: $("#name").val(),
                        outFields: $("#outFields").val()
                    };
                    if (models != "") models_ = models; //判断无数据时
                    models_.push(newData);
                }
                //传入数据保存
                new addListeners().saveData(models_, "保存成功");
            });
        };

        /**
         * 删除数据
         * @param selData
         */
        this.delTr = function (selData) {
            //批量删除字典项
            if (selData.length === 0) {
                layer.msg('请选择要删除的数据!');
                return;
            }
            layui.each(selData, function (idx, item) {
                var selIndex = $.inArray(item, models);
                if (selIndex > -1) {
                    models.splice(selIndex, 1);
                }
            });

            new addListeners().saveData(models, "删除成功");

        };

        /**
         * 分析监听
         */
        this.analysisEventListener = function () {
            //全选
            var selData = [];
            form.on('checkbox(dictsChoseAll)', function (data) {
                if (!data.elem.checked) {
                    selData = [];
                } else {
                    selData = models;
                }
                var child = $(data.elem).parents('table').find('tbody input[type="checkbox"]');
                child.each(function (index, item) {
                    item.checked = data.elem.checked;
                    4
                });
                form.render('checkbox');//渲染checkebox
            });
            //单选
            form.on('checkbox(sel-choose-single)', function (data) {
                var index = data.value;
                if (data.elem.checked) {
                    selData.push(models[index]);
                } else {
                    var i = $.inArray(models[index], selData);
                    if (i >= 0) {
                        selData.splice(i, 1);
                    }
                }
                form.render('checkbox');
            });
            new addListeners().click();//操作点击方法

            //新增和删除
            $(".addTr").on('click', function () {
                var operate = $(this).data('operate');
                switch (operate) {
                    case 'add':
                        models.push(
                            {
                                id: uuid(8, 10),
                                name: "",
                                dataSource: "",
                                comments: "",
                                layerName: "",
                                outFields: ""
                            }
                        );
                        new addListeners().saveData(models, "新增保存");
                        break;
                    case 'del':
                        var models_ = models;
                        var checkStatus = table.checkStatus('analysisRender');//获取选中行
                        data = checkStatus.data;
                        if (data.length === 0) {
                            layer.msg('请选择要删除的数据!');
                            return;
                        }
                        for (var i = 0; i < data.length; i++) {
                            var selIndex;
                            for (var j = 0; j < models.length; j++) {
                                if (data[i].id === models[j].id) {
                                    selIndex = j;
                                    break;
                                }
                            }
                            if (selIndex != null) {
                                models_.splice(selIndex, 1);
                            }
                        }
                        new addListeners().saveData(models_, "保存成功");
                        break;
                    default:
                        break;
                }
            });
        }
    }


    /**
     * 处理 rule 页面的事件
     */
    function ruleEventListener() {
        form.on('submit(formRule)', function (data) {
            var field = data.field;
            $.each(['checkTopoFirst', 'terminateWhenErr'], function (i, n) {
                if (!field.hasOwnProperty(n)) {
                    field[n] = false;
                }
            });
            $.extend(rule, field);
            submit();
            return false;
        });
    }

    /**
     * 处理 其他设置 页面的事件
     */
    function otherEventListener() {
        //编辑字典并提交
        form.on('submit(formEditDict)', function (data) {
            var field = data.field;
            console.log(field);
            saveDict($.param(field));
            return false;
        });
        $(".dict-item-remove").on('click', function () {
            var $li = $(this).parent().parent().parent();
            var $ul = $li.parent();
            $li.remove();
            //更新当前的li中的input的name
            $.each($ul.find('li'), function (idx, item) {
                $(item).find('input').eq(0).attr('name', 'items[' + idx + "].key");
                $(item).find('input').eq(1).attr('name', 'items[' + idx + "].value");
            });

        });
        var selDicts = [];
        //全选
        form.on('checkbox(dicts-choose-all)', function (data) {
            if (!data.elem.checked) {
                selDicts = [];
            } else {
                selDicts = dicts;
            }
            var child = $(data.elem).parents('table').find('tbody input[type="checkbox"]');
            child.each(function (index, item) {
                item.checked = data.elem.checked;
            });
            form.render('checkbox');
        });
        //单选
        form.on('checkbox(dicts-choose-single)', function (data) {
            var index = data.value;
            if (data.elem.checked) {
                selDicts.push(dicts[index]);
            } else {
                var i = $.inArray(dicts[index], selDicts);
                if (i >= 0) {
                    selDicts.splice(i, 1);
                }
            }
            form.render('checkbox');
        });
        var itemTpl = '<li>' +
            '<div class="layui-inline">' +
            '<div class="layui-input-inline">' +
            '<input type="text" name="items[{{ d.index }}].key" value="{{ d.key }}" autocomplete="off" class="layui-input">' +
            '</div>' +
            '<div class="layui-input-inline">' +
            '<input type="text" name="items[{{ d.index }}].value" value="{{ d.value }}" autocomplete="off" class="layui-input">' +
            '</div>' +
            '<a class="layui-btn layui-btn-mini layui-btn-danger dict-item-del"><i class="layui-icon">&#x1006;</i></a>' +
            '</div>' +
            '</li>';
        //监听按钮事件
        $(".dict-btn").on('click', function () {
            var opera = $(this).data('opera');
            switch (opera) {
                case 'add':
                    //新增字典项
                    layer.open({
                        type: 1,
                        title: '新增字典',
                        skin: 'layui-layer-molv',
                        area: ['520px', '340px'],
                        content: renderPage($("#dictNewTpl").html(), {name: '', items: []}),
                        success: function () {
                            //提交字典项
                            form.on('submit(formNewDict)', function (data) {
                                var field = data.field;
                                saveDict($.param(field));
                                return false;
                            });
                            var idx = -1;
                            //添加子项
                            $("#dictNewItemBtn").on('click', function () {
                                idx = idx + 1;
                                $(".dict-new-list").append(renderPage(itemTpl, {key: '', value: '', index: idx}));
                                //移除子项
                                $('.dict-item-del').on('click', function () {
                                    $(this).parent().parent().remove();
                                });
                                return false;
                            });
                        }
                    });
                    break;
                case 'del':
                    //批量删除字典项
                    if (selDicts.length === 0) {
                        layer.msg('请选择要删除的数据!');
                        return;
                    }
                    layui.each(selDicts, function (idx, item) {
                        var dictIndex = $.inArray(item, dicts);
                        if (dictIndex > -1) {
                            dicts.splice(dictIndex, 1);
                        }
                    });
                    submit(function () {
                        refreshActiveTab(renderPage($('#otherTpl').html(), {dicts: dicts}));
                        form.render();
                        otherEventListener();
                    });
                    break;
                default:
                    break;
            }
        });
    }

    /**
     * 保存字典项
     * @param data
     */
    function saveDict(data) {
        layer.msg('提交数据中...', {
            icon: 16,
            shade: 0.6,
            time: false,
            shift: 0
        });
        $.ajax({
            type: 'POST',
            url: '/oma/admin/rest/saveDict',
            data: data,
            dataType: 'json',
            success: function (ret) {
                layer.closeAll();
                if (ret.msg) {
                    layer.alert('保存失败：' + ret.msg, {title: '提示', icon: 5, shift: 16});
                    return;
                }
                layer.msg('保存成功', {icon: 1, time: 2000});
                var target = undefined;
                for (var i = 0, l = dicts.length; i < l; i++) {
                    var item = dicts[i];
                    if (item.name === ret.name) {
                        target = item;
                        break;
                    }
                }
                if (target) {
                    dicts[$.inArray(target, dicts)] = ret;
                } else {
                    dicts.push(ret);
                }
                //重新加载当前tab页面
                refreshActiveTab(renderPage($('#otherTpl').html(), {dicts: dicts}));
                form.render();
                otherEventListener();
            }
        });
    }

    /**
     * 保存整个配置信息
     * @param data
     */
    function submit(callback) {
        layer.msg('提交数据中...', {
            icon: 16,
            shade: 0.6,
            time: false,
            shift: 0
        });
        $.ajax({
            type: 'POST',
            url: '/oma/admin/rest/save',
            data: {analyzeSet: JSON.stringify({dicts: dicts, rule: rule, models: models})},
            dataType: 'json',
            success: function (ret) {
                layer.closeAll();
                if (ret.msg) {
                    layer.alert('提交失败：' + ret.msg, {title: '提示', icon: 5, shift: 16});
                    return;
                }
                layer.msg('保存成功', {icon: 1, time: 2000});
                if (callback) callback();
            }
        });
    }

    /**
     * laytpl渲染模板,同步方式
     * @param template
     * @param data
     */
    function renderPage(template, data) {
        var tpl = laytpl(template);
        return tpl.render(data);
    }

    /**
     * 刷新当前tab页的内容
     * @param content
     */
    function refreshActiveTab(content) {
        var $tabItem = $(".layui-tab-item[class$=layui-show]");
        if ($tabItem.length === 0) return;
        $tabItem.empty().append(content);
    }

    /**
     * 添加标签页
     * @param id
     * @param icon
     * @param title
     * @param content
     * @param closable
     */
    function addTab(id, icon, title, content, closable) {
        title = laytpl('<i class="layui-icon">{{ d.icon }}</i><cite> {{ d.title }}</cite>').render({
            icon: icon,
            title: title
        });
        if (closable) {
            title += '<i class="layui-icon layui-unselect layui-tab-close" data-id="' + id + '">&#x1006;</i>';
        }
        element.tabAdd(tabFilter, {
            title: title
            , content: content //支持传入html
            , id: id
        });
        element.tabChange(tabFilter, id);
        //存储该id
        existTabs.push(id);
        //移除tab事件
        $('.layui-tab-close').on('click', function () {
            var layid = $(this).data('id');
            if (existsTab(layid)) {
                element.tabDelete(tabFilter, layid);
                existTabs.splice($.inArray(layid, existTabs), 1);
                if (existTabs.length === 0) {
                    //去除左侧选中的导航
                    $("#adminNav .layui-nav-item").removeClass('layui-this');
                }
            }
        });
    }

    /**
     * 检测tab页是否已经加载
     * @param tabId
     */
    function existsTab(tabId) {
        return $.inArray(tabId, existTabs) > -1;
    }

    exports('admin', {
        init: function (props) {
            console.log('后台管理模块初始化...');
            initVars(props);
            initEvents();
            console.log('后台管理模块初始化成功!');
        }
    });
});
