<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>分析子系统-系统设置</title>
    <link rel="stylesheet" href="<@com.rootPath/>/static/tp/layui/css/layui.css">
    <link rel="stylesheet" href="<@com.rootPath/>/static/tp/pace/pace-theme-flash.css">
    <link rel="stylesheet" href="<@com.rootPath/>/static/css/global.css">
    <script src="<@com.rootPath/>/static/tp/pace/pace.min.js"></script>
    <script src="<@com.rootPath/>/static/tp/layui/layui.js"></script>
    <script src="<@com.rootPath/>/static/js/global.js"></script>
</head>
<body>
<#--头部-->
<div class="layui-header header">
    <div class="admin-main">
        <a class="logo" href="<@com.rootPath/>/admin">数据分析系统管理</a>
        <a href="javascript:;" class="layui-icon hide-menu">&#xe60f;</a>
        <div class="nav">
            <a href=javascript:; class="setting-item">
                <i class="layui-icon">&#xe612;</i>
                系统管理员
            </a>
        </div>
    </div>
</div>
<div class="admin-layout-main layer-clear">
<#--左侧导航-->
    <ul class="layui-nav layui-nav-tree admin-aside" id="adminNav" lay-filter="admin">
        <li class="layui-nav-item" data-tid="analysis">
            <a href="javascript:;">
                <i class="layui-icon">&#xe62c;</i><cite>分析设置</cite>
            </a>
        </li>
        <li class="layui-nav-item" data-tid="rule">
            <a href="javascript:;">
                <i class="layui-icon">&#xe60a;</i><cite>规则设置</cite>
            </a>
        </li>
        <li class="layui-nav-item" data-tid="other">
            <a href="javascript:;">
                <i class="layui-icon">&#xe631;</i><cite>其他设置</cite>
            </a>
        </li>
    </ul>
<#--内容区-->
    <div class="admin-content">
        <div class="layui-tab" lay-filter="admin" id="adminTab">
            <ul class="layui-tab-title">
                <li class="layui-this" lay-id="index">使用说明</li>
            </ul>
            <div class="layui-tab-content">
                <div class="layui-tab-item layui-show">
                    <blockquote class="layui-elem-quote">欢迎使用后台管理系统!</blockquote>
                    <fieldset class="layui-elem-field layui-field-title">
                        <legend>分析设置</legend>
                        <div class="layui-field-box">
                            <p>
                                用于配置系统中的分析功能，可实现对各分析功能的图层、数据源、年份的设置，也支持自定义分析的定制。
                            </p>
                            <ul>
                                <li><cite>现状分析</cite><em>多年份</em></li>
                                <li><cite>规划分析</cite><em>单一年份</em></li>
                                <li><cite>基本农田分析</cite><em>返回字段</em></li>
                                <li><cite>综合分析</cite><em>多分析图层</em></li>
                                <li><cite>自定义分析</cite><em>自定义图层、结果展示</em></li>
                            </ul>
                        </div>
                    </fieldset>
                    <fieldset class="layui-elem-field layui-field-title">
                        <legend>规则设置</legend>
                        <div class="layui-field-box">
                            <p>
                                用于配置系统分析功能中的一些规则，目前主要有：
                            </p>
                            <ul>
                                <li><cite>拓扑前置检查</cite><em>checkTopoFirst</em></li>
                                <li><cite>遇错终止</cite><em>terminateWhenErr</em></li>
                                <li><cite>分析容差</cite><em>tolerance</em></li>
                            </ul>
                        </div>
                    </fieldset>
                    <fieldset class="layui-elem-field layui-field-title">
                        <legend>其他设置</legend>
                        <div class="layui-field-box">
                            <p>
                                用于配置系统用到的其他参数，如现状分析中需要使用的<em>字典项</em>。
                            </p>
                        </div>
                    </fieldset>
                </div>
            </div>
        </div>
    </div>
<#--底部-->
    <div class="layui-footer">
        <p>
            &copy;2017 GTMAP
        </p>
    </div>
</div>

<div id="analysisTpl" style="display: none">
    <blockquote class="layui-elem-quote b-l-n">
        <div class="layui-inline">
            <a class="layui-btn layui-btn-small addTr" data-operate="add" id="addTr"><i class="layui-icon">&#xe654;</i>&nbsp;新增</a>
            <a class="layui-btn layui-btn-small layui-btn-danger addTr" data-operate="del"><i class="layui-icon">&#xe640;</i>&nbsp;删除</a>
        </div>
    </blockquote>
    <div class="analysis-list-wrapper">
        <table id="analysisTable" class="layui-table" lay-filter="analysisTable">
        </table>
    </div>
    <script>
        layui.use('table', function () {
            var table = layui.table;
            table.render({
                elem: '#analysisTable'
                , id: 'analysisRender'
                , url: "/oma/admin/getModelList"
                ,height:"350"
                , cols: [[
                    {checkbox: 'true'}
                    , {field: 'id', title: 'ID', width: 100, align: 'center'}
                    , {field: 'name', title: '名称', width: 200, sort: true, edit: 'text'}
                    , {field: 'dataSource', title: '数据源', width: 100, align: 'center', sort: true, edit: 'text'}
                    , {field: 'layerName', title: '图层名', width: 200, align: 'center', sort: true, edit: 'text'}
                    , {field: 'outFields', title: '返回字段', width: 215, edit: 'text'}
                    , {title: '操作', width: 150, align: 'center', toolbar: '#modelEditTpl'}
                ]]
            });

        });
    </script>
    <script type="text/html" id="modelEditTpl">
        <a class="layui-btn layui-btn-mini info" lay-event="param">参数</a>
        <a class="layui-btn layui-btn-normal layui-btn-mini save" lay-event="save">保存</a>
    </script>
</div>

<#--字典配置页面模板-->
<script id="otherTpl" type="text/html">
    <fieldset class="layui-elem-field layui-field-title">
        <legend>字典项</legend>
        <div class="layui-field-box">
            <blockquote class="layui-elem-quote b-l-n">
                <div class="layui-inline">
                    <button class="layui-btn layui-btn-small dict-btn" data-opera="add"><i
                            class="layui-icon">&#xe654;</i>&nbsp;新增
                    </button>
                    <button class="layui-btn layui-btn-small layui-btn-danger dict-btn" data-opera="del"><i
                            class="layui-icon">&#xe640;</i>&nbsp;删除
                    </button>
                </div>
            </blockquote>
            <table class="layui-table">
                <colgroup>
                    <col width="50">
                    <col width="25%">
                    <col>
                    <col width="150">
                </colgroup>
                <thead>
                <tr>
                    <th>
                    </th>
                    <th>名称</th>
                    <th>子项</th>
                    <th>操作</th>
                </tr>
                </thead>
                <tbody>
                {{# layui.each(d.dicts, function(index, item){ }}
                <tr class="layui-form">
                    <td><input type="checkbox" name="chooseSingle" lay-filter="dicts-choose-single" lay-skin="primary"
                               value="{{ index }}"></td>
                <#--名称-->
                    <td>
                        <div class="layui-input-inline" style="width: 100%">
                            <input type="text" class="layui-input" name="name" value="{{ item.name }}"
                                   autocomplete="off" placeholder="请输入名称"
                                   required lay-verify="required">
                        </div>
                    </td>
                    <td>
                    <#--子项-->
                        <ul class="dicts-list">
                            {{# layui.each(item.items, function(idx, val) { }}
                            <li>
                                <div class="layui-inline">
                                    <div class="layui-input-inline">
                                        <input type="text" name="items[{{ idx }}].key" value="{{ val.key }}"
                                               autocomplete="off"
                                               class="layui-input">
                                    </div>
                                    <div class="layui-input-inline">
                                        <input type="text" name="items[{{ idx }}].value" value="{{ val.value }}"
                                               autocomplete="off"
                                               class="layui-input">
                                    </div>
                                    <div class="layui-input-inline">
                                        <a class="layui-btn layui-btn-mini layui-btn-danger dict-item-remove"
                                           title="移除该项">
                                            <i class="layui-icon">&#x1006;</i>
                                        </a>
                                    </div>
                                </div>
                            </li>
                            {{# });}}
                        </ul>
                    </td>
                <#--操作-->
                    <td>
                        <div class="layui-inline">
                            <button class="layui-btn layui-btn-small layui-btn-normal" lay-submit
                                    lay-filter="formEditDict">
                                <i class="layui-icon">&#xe605;</i>保存
                            </button>
                        </div>
                    </td>
                </tr>
                {{# }); }}

                {{# if(d.dicts.length === 0){ }}
                <tr align="center">
                    <td colspan="4"><em>无数据</em></td>
                </tr>
                {{# } }}
                </tbody>
            </table>
        <#--</div>-->
        </div>
    </fieldset>
</script>
<#--新增字典项 模板-->
<script id="dictNewTpl" type="text/html">
    <form class="layui-form">
        <div class="layui-form-item">
            <label class="layui-form-label">名称:</label>
            <div class="layui-input-block">
                <input type="text" name="name" value="{{ d.name }}" placeholder="请输入字典名称" required lay-verify="required"
                       autocomplete="off" class="layui-input">
            </div>
        </div>
        <div class="layui-form-item">
            <label class="layui-form-label">子项:</label>
            <div class="layui-input-block">
                <div class="layui-inline">
                    <a class="layui-btn layui-btn-mini layui-btn-normal m-l-5" id="dictNewItemBtn">添加</a>
                </div>
                <ul class="dict-new-list">
                </ul>
            </div>
        </div>
        <div class="layui-form-item">
            <div class="layui-input-block">
                <button class="layui-btn" lay-submit lay-filter="formNewDict">确定</button>
            </div>
        </div>
    </form>
</script>

<#--规则配置页面模板-->
<script id="ruleTpl" type="text/html">
    <form class="layui-form layui-form-pane">
        <div class="layui-form-item" pane>
            <label class="layui-form-label">拓扑检查</label>
            <div class="layui-input-block">
                <input type="checkbox" name="checkTopoFirst" {{# if (d.rule.checkTopoFirst) { }} checked {{# }}}
                       lay-skin="switch" lay-text="开|关" value="true">
            </div>
        </div>
        <div class="layui-form-item" pane>
            <label class="layui-form-label">遇错终止</label>
            <div class="layui-input-block">
                <input type="checkbox" name="terminateWhenErr" {{# if (d.rule.terminateWhenErr) { }} checked {{# }}}
                       lay-skin="switch" lay-text="开|关" value="true">
            </div>
        </div>
        <div class="layui-form-item">
            <label class="layui-form-label">容差值</label>
            <div class="layui-input-block">
                <input type="text" name="tolerance" placeholder="请输入浮点值" autocomplete="off" class="layui-input"
                       value="{{ d.rule.tolerance }}">
            </div>
        </div>
        <div class="layui-form-item">
            <div class="layui-input-block">
                <button class="layui-btn" lay-submit lay-filter="formRule">立即提交</button>
            </div>
        </div>
    </form>
</script>
<script type="text/html" id="paramsTpl">
    <form class="layui-form layui-form-pane param-form">
        {{# layui.each(d.data, function(idx, item){ }}
        <div class="layui-form-item">
            <label class="layui-form-label" style="width: 150px">{{ item.alias }}&nbsp;:</label>
            <div class="layui-input-inline">
                <input type="text" value="{{ item.val }}" name="{{ item.name }}" autocomplete="off" class="layui-input">
            </div>
        </div>
        {{# if (idx === d.data.length-1) { }}
        <div>
            <ul class="models-new-list">
        </div>
        <hr style="margin: 20px 0;"/>
        {{# } }}
        {{# });}}
    </form>
</script>
<script src="<@com.rootPath/>/static/tp/ko/knockout-3.4.2.js"></script>
<script>
    layui.use('admin', function (adminPage) {
        adminPage.init({
            rule: '${rule!}',
            models: '${models!"[]"}',
            dicts: '${dicts!"[]"}'
        });
    });
</script>
</body>
</html>