/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.analysis.core;

import cn.gtmap.onemap.analysis.core.BaseLogger;
import cn.gtmap.onemap.analysis.support.JSONMessageException;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

public class BaseController
extends BaseLogger {
    @ExceptionHandler(value={JSONMessageException.class})
    @ResponseBody
    public Map<String, ?> handlerJSONException(Exception e, HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", false);
        result.put("msg", e.getLocalizedMessage());
        return result;
    }

    protected void sendFile(InputStream inputStream, HttpServletResponse response, String fileName) throws IOException {
        if (inputStream == null || response == null) {
            return;
        }
        if (inputStream.available() > 0) {
            response.addHeader("Content-Disposition", "attachment; filename=" + fileName);
            response.setDateHeader("Last-Modified", new Date().getTime());
            response.setContentLength(inputStream.available());
            FileCopyUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
        } else {
            response.sendError(404, "request file not found");
        }
    }

    protected void error(String info, HttpServletResponse response) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", false);
        result.put("msg", info);
        try {
            response.getWriter().write(JSON.toJSONString(result));
        }
        catch (IOException e) {
            this.logger.error(e.getLocalizedMessage());
        }
    }
}

