/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.server.utils;

import cn.gtmap.dysjy.common.domain.BdcDysjPzDO;
import cn.gtmap.dysjy.common.domain.BdcDysjZbPzDO;
import cn.gtmap.dysjy.common.utils.CoeRuntimeContext;
import cn.gtmap.dysjy.common.utils.DataParseUtils;
import cn.gtmap.dysjy.common.utils.ResultHandleUtils;
import cn.gtmap.dysjy.exceptions.DysjyException;
import com.google.common.collect.Lists;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class DyRestRpcUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DyRestRpcUtils.class);
    @Autowired(required=false)
    private DiscoveryClient discoveryClient;
    @Autowired
    @Qualifier(value="dyRestTemplate")
    private RestTemplate dyRestTemplate;

    public <T> T getRpcRequest(BdcDysjPzDO bdcDysjPzDO, BdcDysjZbPzDO bdcDysjZbPzDO, Map<String, Object> params) {
        String url;
        String appName = Objects.nonNull(bdcDysjPzDO) ? bdcDysjPzDO.getQqyy() : bdcDysjZbPzDO.getQqyy();
        String string = url = Objects.nonNull(bdcDysjPzDO) ? bdcDysjPzDO.getDysjy() : bdcDysjZbPzDO.getDyzbsjy();
        if (StringUtils.isBlank((CharSequence)appName) || StringUtils.isBlank((CharSequence)url)) {
            throw new DysjyException("\u6267\u884cGET\u65b9\u5f0f\u8bf7\u6c42RPC\u8c03\u7528\u53d1\u751f\u9519\u8bef\uff0c\u539f\u56e0\uff1a\u672a\u5b9a\u4e49\u5e94\u7528\u540d\u79f0\u6216\u8bf7\u6c42URL\u5730\u5740\uff01");
        }
        try {
            Lists.newArrayList((Object[])bdcDysjPzDO.getCs().split(",")).forEach(key -> {
                if (Objects.isNull(params.get(key))) {
                    params.put((String)key, "");
                }
            });
            url = ResultHandleUtils.replaceParam(url, params);
            String requestUrl = this.resolveRequestUrl(appName, url, params);
            String result = (String)CoeRuntimeContext.getRuntimeData(requestUrl);
            if (StringUtils.isBlank((CharSequence)result)) {
                RestTemplate template = this.getRestTemplate(appName);
                result = (String)template.getForObject(requestUrl, String.class, new Object[0]);
                CoeRuntimeContext.setRuntimeData(requestUrl, result);
            }
            String dataId = Objects.nonNull(bdcDysjPzDO) ? null : bdcDysjZbPzDO.getDyzbid();
            return (T)DataParseUtils.parseType(dataId, result);
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884cGET\u65b9\u5f0f\u8bf7\u6c42RPC\u8c03\u7528\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)e);
            throw new DysjyException("\u6267\u884cGET\u65b9\u5f0f\u8bf7\u6c42RPC\u8c03\u7528\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public <T> T getRpcRequest(String dataId, String appName, String url, Map<String, Object> params) {
        if (StringUtils.isBlank((CharSequence)appName) || StringUtils.isBlank((CharSequence)url)) {
            throw new DysjyException("\u6267\u884cGET\u65b9\u5f0f\u8bf7\u6c42RPC\u8c03\u7528\u53d1\u751f\u9519\u8bef\uff0c\u539f\u56e0\uff1a\u672a\u5b9a\u4e49\u5e94\u7528\u540d\u79f0\u6216\u8bf7\u6c42URL\u5730\u5740\uff01");
        }
        try {
            String requestUrl = this.resolveRequestUrl(appName, url, params);
            RestTemplate template = this.getRestTemplate(appName);
            String result = (String)template.getForObject(requestUrl, String.class, new Object[0]);
            return (T)DataParseUtils.parseType(dataId, result);
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884cGET\u65b9\u5f0f\u8bf7\u6c42RPC\u8c03\u7528\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)e);
            throw new DysjyException("\u6267\u884cGET\u65b9\u5f0f\u8bf7\u6c42RPC\u8c03\u7528\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public <T> T getRpcRequest(String dataId, String appName, String url) {
        if (StringUtils.isBlank((CharSequence)appName) || StringUtils.isBlank((CharSequence)url)) {
            throw new DysjyException("\u6267\u884cGET\u65b9\u5f0f\u8bf7\u6c42RPC\u8c03\u7528\u53d1\u751f\u9519\u8bef\uff0c\u539f\u56e0\uff1a\u672a\u5b9a\u4e49\u5e94\u7528\u540d\u79f0\u6216\u8bf7\u6c42URL\u5730\u5740\uff01");
        }
        try {
            RestTemplate template = this.getRestTemplate(appName);
            String result = (String)template.getForObject(url, String.class, new Object[0]);
            return (T)DataParseUtils.parseType(dataId, result);
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884cGET\u65b9\u5f0f\u8bf7\u6c42RPC\u8c03\u7528\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u6c42\u76ee\u6807 {}, \u8bf7\u6c42\u5730\u5740 {}", new Object[]{appName, url, e});
            throw new DysjyException("\u6267\u884cGET\u65b9\u5f0f\u8bf7\u6c42RPC\u8c03\u7528\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u6c42\u76ee\u6807 " + appName + ", \u8bf7\u6c42\u5730\u5740 " + url + "\uff1a" + e.getMessage());
        }
    }

    public <T> T postRpcRequest(String dataId, String appName, String url, Object param) {
        if (StringUtils.isBlank((CharSequence)appName) || StringUtils.isBlank((CharSequence)url)) {
            throw new DysjyException("\u6267\u884cPOST\u65b9\u5f0f\u8bf7\u6c42RPC\u8c03\u7528\u53d1\u751f\u9519\u8bef\uff0c\u539f\u56e0\uff1a\u672a\u5b9a\u4e49\u5e94\u7528\u540d\u79f0\u6216\u8bf7\u6c42URL\u5730\u5740\uff01");
        }
        if (null == param) {
            return null;
        }
        try {
            RestTemplate template = this.getRestTemplate(appName);
            String result = (String)template.postForObject(url, param, String.class, new Object[0]);
            return (T)DataParseUtils.parseType(dataId, result);
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884cGET\u65b9\u5f0f\u8bf7\u6c42RPC\u8c03\u7528\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw new DysjyException("\u6267\u884cGET\u65b9\u5f0f\u8bf7\u6c42RPC\u8c03\u7528\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    private String resolveRequestUrl(String appName, String url, Map<String, Object> params) throws URISyntaxException {
        if (MapUtils.isEmpty(params)) {
            return url;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            url = url.replaceAll("#\\{" + entry.getKey() + "\\}", String.valueOf(entry.getValue()));
        }
        return "http://" + appName.trim() + url.trim();
    }

    public RestTemplate getRestTemplate(String appName) {
        if (Objects.isNull(this.discoveryClient)) {
            return new RestTemplate();
        }
        List servicesList = this.discoveryClient.getInstances(appName);
        if (CollectionUtils.isEmpty((Collection)servicesList)) {
            return new RestTemplate();
        }
        return this.dyRestTemplate;
    }

    public void deleteRpcRequest(String appName, String url, Map<String, Object> params) {
        if (StringUtils.isBlank((CharSequence)appName) || StringUtils.isBlank((CharSequence)url)) {
            throw new DysjyException("\u6267\u884cDELETE\u65b9\u5f0f\u8bf7\u6c42RPC\u8c03\u7528\u53d1\u751f\u9519\u8bef\uff0c\u539f\u56e0\uff1a\u672a\u5b9a\u4e49\u5e94\u7528\u540d\u79f0\u6216\u8bf7\u6c42URL\u5730\u5740\uff01");
        }
        try {
            RestTemplate template = this.getRestTemplate(appName);
            template.delete(url, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884cGET\u65b9\u5f0f\u8bf7\u6c42RPC\u8c03\u7528\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw new DysjyException("\u6267\u884cGET\u65b9\u5f0f\u8bf7\u6c42RPC\u8c03\u7528\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public void putRpcRequest(String appName, String url, Object param) {
        if (StringUtils.isBlank((CharSequence)appName) || StringUtils.isBlank((CharSequence)url)) {
            throw new DysjyException("\u6267\u884cDELETE\u65b9\u5f0f\u8bf7\u6c42RPC\u8c03\u7528\u53d1\u751f\u9519\u8bef\uff0c\u539f\u56e0\uff1a\u672a\u5b9a\u4e49\u5e94\u7528\u540d\u79f0\u6216\u8bf7\u6c42URL\u5730\u5740\uff01");
        }
        if (null != param) {
            try {
                RestTemplate template = this.getRestTemplate(appName);
                template.put(url, param, new Object[]{String.class});
            }
            catch (Exception e) {
                LOGGER.error("\u6267\u884cGET\u65b9\u5f0f\u8bf7\u6c42RPC\u8c03\u7528\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                throw new DysjyException("\u6267\u884cGET\u65b9\u5f0f\u8bf7\u6c42RPC\u8c03\u7528\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
    }

    public void patchRpcRequest(String appName, String url, Object param) {
        if (StringUtils.isBlank((CharSequence)appName) || StringUtils.isBlank((CharSequence)url)) {
            throw new DysjyException("\u6267\u884cDELETE\u65b9\u5f0f\u8bf7\u6c42RPC\u8c03\u7528\u53d1\u751f\u9519\u8bef\uff0c\u539f\u56e0\uff1a\u672a\u5b9a\u4e49\u5e94\u7528\u540d\u79f0\u6216\u8bf7\u6c42URL\u5730\u5740\uff01");
        }
        if (null != param) {
            try {
                RestTemplate template = this.getRestTemplate(appName);
                template.patchForObject(url, param, String.class, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("\u6267\u884cGET\u65b9\u5f0f\u8bf7\u6c42RPC\u8c03\u7528\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                throw new DysjyException("\u6267\u884cGET\u65b9\u5f0f\u8bf7\u6c42RPC\u8c03\u7528\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
    }
}

