/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.server.utils;

import cn.gtmap.dysjy.common.domain.BdcDysjCache;
import cn.gtmap.dysjy.common.domain.BdcDysjMethod;
import cn.gtmap.dysjy.common.utils.UUIDGenerator;
import cn.gtmap.dysjy.mybatis.mapper.DyEntityMapper;
import cn.gtmap.dysjy.mybatis.mapper.Example;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DyCacheUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DyCacheUtils.class);
    private static final List<BdcDysjMethod> BDC_DYSJ_METHOD_LIST = new ArrayList<BdcDysjMethod>();
    public static final String BDC_DYSJ_METHOD_LIST_KEY = "BDC_DYSJ_METHOD_LIST";
    @Autowired
    private DyEntityMapper dyEntityMapper;

    public String setData(String key, String data) {
        BdcDysjCache bdcDysjCache = new BdcDysjCache();
        bdcDysjCache.setId(key);
        bdcDysjCache.setData(data);
        bdcDysjCache.setCreateTime(new Date());
        this.dyEntityMapper.insertSelective(bdcDysjCache);
        return key;
    }

    public String setData(String data) {
        String key = UUIDGenerator.generate16();
        return this.setData(key, data);
    }

    public String getData(String key) {
        BdcDysjCache bdcDysjCache = this.dyEntityMapper.selectByPrimaryKey(BdcDysjCache.class, key);
        if (null == bdcDysjCache) {
            return null;
        }
        return bdcDysjCache.getData();
    }

    public String getAndDeleteData(String key) {
        BdcDysjCache bdcDysjCache = this.dyEntityMapper.selectByPrimaryKey(BdcDysjCache.class, key);
        if (null == bdcDysjCache) {
            return null;
        }
        this.dyEntityMapper.deleteByPrimaryKey(BdcDysjCache.class, key);
        return bdcDysjCache.getData();
    }

    @PostConstruct
    public void initBdcDysjMethod() {
        try {
            List<BdcDysjMethod> bdcDysjMethodList = this.dyEntityMapper.selectByExample(BdcDysjMethod.class, new Example(BdcDysjMethod.class));
            if (CollectionUtils.isNotEmpty(bdcDysjMethodList)) {
                BDC_DYSJ_METHOD_LIST.clear();
                BDC_DYSJ_METHOD_LIST.addAll(bdcDysjMethodList);
            }
            Calendar calendar = Calendar.getInstance();
            calendar.set(6, calendar.get(6) - 1);
            Example example = new Example(BdcDysjCache.class);
            example.createCriteria().andLessThan("createTime", calendar.getTime());
            this.dyEntityMapper.deleteByExample(BdcDysjCache.class, example);
        }
        catch (Exception e) {
            LOGGER.error("\u5237\u65b0\u6253\u5370\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<BdcDysjMethod> getBdcDysjMethodList() {
        return BDC_DYSJ_METHOD_LIST;
    }
}

