/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.mybatis.mapper;

import cn.gtmap.dysjy.mybatis.mapper.MapperTemplate;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.ibatis.jdbc.SQL;
import org.apache.ibatis.reflection.MetaObject;

public class BaseProvider {
    private static final String RECORD = "record";
    private static final String CONDITION = "condition";
    private static final String TYPEHANDLER = "typeHandler";
    private static final String JSON = "json";

    protected void notNullKeyProperty(String property, Object value) {
        if (value == null || value instanceof String && this.isEmpty((String)value)) {
            this.throwNullKeyException(property);
        }
    }

    protected void throwNullKeyException(String property) {
        throw new NullPointerException("\u4e3b\u952e\u5c5e\u6027" + property + "\u4e0d\u80fd\u4e3a\u7a7a!");
    }

    protected Class<?> getEntityClass(Map<String, Object> params) {
        Class entityClass = null;
        if (params.containsKey(RECORD)) {
            entityClass = this.getEntity(params).getClass();
        } else if (params.containsKey("entityClass")) {
            entityClass = (Class)params.get("entityClass");
        }
        if (entityClass == null) {
            throw new NoClassDefFoundError("\u65e0\u6cd5\u83b7\u53d6\u5b9e\u4f53\u7c7b\u578b!");
        }
        return entityClass;
    }

    protected Object getEntity(Map<String, Object> params) {
        Object result;
        if (params.containsKey(RECORD)) {
            result = params.get(RECORD) != null && (params.get(RECORD) instanceof List || params.get(RECORD) instanceof ArrayList) ? ((List)params.get(RECORD)).get(0) : params.get(RECORD);
        } else if (params.containsKey("key")) {
            result = params.get("key");
        } else {
            throw new NoClassDefFoundError("\u5f53\u524d\u65b9\u6cd5\u6ca1\u6709\u5b9e\u4f53\u6216\u4e3b\u952e\u53c2\u6570!");
        }
        if (result == null) {
            throw new NullPointerException("\u5b9e\u4f53\u6216\u8005\u4e3b\u952e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return result;
    }

    public JSONObject getJSONObject(Map<String, Object> params) {
        if (MapUtils.isEmpty(params) || !params.containsKey(JSON)) {
            throw new NullPointerException("\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return (JSONObject)MapUtils.getObject(params, (Object)JSON);
    }

    protected MetaObject getExample(Map<String, Object> params) {
        Object result = null;
        if (params.containsKey("example")) {
            result = params.get("example");
        }
        if (result == null) {
            return null;
        }
        MetaObject example = MapperTemplate.forObject(result);
        if (example.hasGetter("orderByClause") && example.hasGetter("oredCriteria") && example.hasGetter("distinct")) {
            return example;
        }
        throw new IllegalArgumentException("Example\u53c2\u6570\u4e0d\u662f\u5408\u6cd5\u7684Mybatis Example\u5bf9\u8c61!");
    }

    protected void applyOrderBy(SQL sql, MetaObject example) {
        if (example == null) {
            return;
        }
        Object orderBy = example.getValue("orderByClause");
        if (orderBy != null) {
            sql.ORDER_BY((String)orderBy);
        }
    }

    protected void applyWhere(SQL sql, MetaObject example) {
        if (example == null) {
            return;
        }
        String parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
        String parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
        String parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
        String parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
        String parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
        String parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        StringBuilder sb = new StringBuilder();
        List oredCriteria = (List)example.getValue("oredCriteria");
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); ++i) {
            MetaObject criteria = MapperTemplate.forObject(oredCriteria.get(i));
            List criterions = (List)criteria.getValue("criteria");
            if (criterions.isEmpty()) continue;
            if (firstCriteria) {
                firstCriteria = false;
            } else {
                sb.append(" or ");
            }
            sb.append('(');
            boolean firstCriterion = true;
            for (int j = 0; j < criterions.size(); ++j) {
                MetaObject criterion = MapperTemplate.forObject(criterions.get(j));
                if (firstCriterion) {
                    firstCriterion = false;
                } else {
                    sb.append(" and ");
                }
                if (((Boolean)criterion.getValue("noValue")).booleanValue()) {
                    sb.append(criterion.getValue(CONDITION));
                    continue;
                }
                if (((Boolean)criterion.getValue("singleValue")).booleanValue()) {
                    if (criterion.getValue(TYPEHANDLER) == null) {
                        sb.append(String.format(parmPhrase1, criterion.getValue(CONDITION), i, j));
                        continue;
                    }
                    sb.append(String.format(parmPhrase1_th, criterion.getValue(CONDITION), i, j, criterion.getValue(TYPEHANDLER)));
                    continue;
                }
                if (((Boolean)criterion.getValue("betweenValue")).booleanValue()) {
                    if (criterion.getValue(TYPEHANDLER) == null) {
                        sb.append(String.format(parmPhrase2, criterion.getValue(CONDITION), i, j, i, j));
                        continue;
                    }
                    sb.append(String.format(parmPhrase2_th, criterion.getValue(CONDITION), i, j, criterion.getValue(TYPEHANDLER), i, j, criterion.getValue(TYPEHANDLER)));
                    continue;
                }
                if (!((Boolean)criterion.getValue("listValue")).booleanValue()) continue;
                sb.append(criterion.getValue(CONDITION));
                sb.append(" (");
                List listItems = (List)criterion.getValue("value");
                boolean comma = false;
                for (int k = 0; k < listItems.size(); ++k) {
                    if (comma) {
                        sb.append(", ");
                    } else {
                        comma = true;
                    }
                    if (criterion.getValue(TYPEHANDLER) == null) {
                        sb.append(String.format(parmPhrase3, i, j, k));
                        continue;
                    }
                    sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getValue(TYPEHANDLER)));
                }
                sb.append(')');
            }
            sb.append(')');
        }
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }

    protected boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    protected boolean isNotEmpty(String value) {
        return !this.isEmpty(value);
    }
}

