/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.utils.thread;

import cn.gtmap.dysjy.common.spring.DyContainer;
import cn.gtmap.dysjy.common.spring.DyEnvironmentConfig;
import cn.gtmap.dysjy.common.utils.DateUtils;
import cn.gtmap.dysjy.common.utils.thread.CommonThread;
import cn.gtmap.dysjy.common.utils.thread.DyThreadTaskExecutor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
@Import(value={DyThreadTaskExecutor.class, DyContainer.class})
public class DyThreadEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(DyThreadEngine.class);

    public <T> List<T> excuteThread(List<T> list, boolean wait) {
        return this.excuteThread(list, wait, null);
    }

    public <T> List<T> excuteThread(List<T> list, boolean wait, Map<String, Object> taskMap) {
        if (CollectionUtils.isNotEmpty(list)) {
            ArrayList<Future> listThread = new ArrayList<Future>();
            ThreadPoolTaskExecutor taskExecutor = DyContainer.getBean(DyThreadTaskExecutor.class);
            if (taskMap != null) {
                taskMap.put("taskExecutor", taskExecutor);
            }
            String name = "";
            if (list.get(0) != null) {
                name = list.get(0).getClass().getSimpleName();
            }
            String dateStr = DateUtils.formateTimeYmdhms(new Date());
            taskExecutor.setThreadNamePrefix(dateStr + name + ":\u603b\u6570" + list.size());
            int countSize = list.size();
            boolean sfbjs = ((CommonThread)list.get(0)).isSfbjs();
            if (!sfbjs) {
                this.threadRule(countSize, 0, taskExecutor);
            }
            for (int i = 0; i < countSize; ++i) {
                Future future = taskExecutor.submit((Runnable)list.get(i));
                listThread.add(future);
            }
            if (wait) {
                this.shutDownThread(taskExecutor, sfbjs, listThread);
            }
        }
        return list;
    }

    private void shutDownThread(ThreadPoolTaskExecutor taskExecutor, boolean sfbjs, List<Future> list) {
        ThreadPoolExecutor threadPoolExecutor = taskExecutor.getThreadPoolExecutor();
        BlockingQueue<Runnable> queue = threadPoolExecutor.getQueue();
        long millis = 500L;
        int times = 0;
        while (true) {
            int count = threadPoolExecutor.getActiveCount();
            int queueSize = queue.size();
            if (queueSize == 0) {
                for (Future future : list) {
                    if (threadPoolExecutor.isShutdown()) break;
                    while (!future.isDone() && !future.isCancelled()) {
                        LOGGER.info("{}-\u7ebf\u7a0b\u6c60\u8fd8\u6709\u5728\u5de5\u4f5c\u7684\u7ebf\u7a0b", (Object)taskExecutor.getThreadNamePrefix());
                        try {
                            Thread.sleep(millis);
                        }
                        catch (Exception e) {
                            LOGGER.error(null, (Throwable)e);
                        }
                    }
                }
                break;
            }
            LOGGER.info("{}-\u7ebf\u7a0b\u6c60\u8fd8\u5728\u5de5\u4f5c\u4e2d\uff0c\u5f53\u524d\u89e6\u53d1{}\u4e2a\u7ebf\u7a0b\uff0c\u961f\u5217\u4e2d\u5b58\u5728{}\u4e2a\u4efb\u52a1\u6392\u961f", new Object[]{taskExecutor.getThreadNamePrefix(), count, queueSize});
            if (!sfbjs) {
                if (times > 20) {
                    millis = 1000L;
                } else if (times > 10) {
                    millis = 500L;
                }
            }
            try {
                Thread.sleep(millis);
            }
            catch (Exception e) {
                LOGGER.error(null, (Throwable)e);
            }
            ++times;
        }
        taskExecutor.destroy();
    }

    private ThreadPoolTaskExecutor threadRule(Integer size, int count, ThreadPoolTaskExecutor threadTaskExecutor) {
        Integer maxSize = (Integer)DyEnvironmentConfig.getEnvironment().getProperty("thread.max", Integer.class, (Object)150);
        Integer surplusSize = maxSize - CommonThread.getSumThread();
        ThreadPoolExecutor threadPoolExecutor = threadTaskExecutor.getThreadPoolExecutor();
        boolean hasThread = surplusSize > 0;
        Integer maxPoolSize = threadPoolExecutor.getMaximumPoolSize();
        if (hasThread) {
            Integer setSize = maxPoolSize;
            if (size < maxPoolSize) {
                setSize = size > surplusSize ? surplusSize : size;
            } else if (surplusSize < maxPoolSize) {
                setSize = surplusSize;
            }
            threadTaskExecutor.setCorePoolSize(setSize.intValue());
            threadPoolExecutor.setCorePoolSize(setSize);
            threadTaskExecutor.setMaxPoolSize(setSize.intValue());
            threadPoolExecutor.setMaximumPoolSize(setSize);
        } else if (size < 10) {
            threadTaskExecutor.setCorePoolSize(1);
            threadPoolExecutor.setCorePoolSize(1);
            threadTaskExecutor.setMaxPoolSize(1);
            threadPoolExecutor.setMaximumPoolSize(1);
        } else if (count > 10) {
            threadTaskExecutor.setCorePoolSize(5);
            threadPoolExecutor.setCorePoolSize(5);
            threadTaskExecutor.setMaxPoolSize(5);
            threadPoolExecutor.setMaximumPoolSize(5);
        } else {
            try {
                Thread.sleep(500L);
                this.threadRule(size, ++count, threadTaskExecutor);
            }
            catch (Exception e) {
                LOGGER.error(null, (Throwable)e);
            }
        }
        return threadTaskExecutor;
    }
}

