/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.utils.thread;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public abstract class CommonThread
implements Runnable {
    private Map<String, Object> taskMap;
    private boolean sfbjs;
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonThread.class);
    private static AtomicInteger sumThread = new AtomicInteger(0);

    public static Integer getSumThread() {
        return sumThread.get();
    }

    @Override
    public void run() {
        if (!this.sfbjs) {
            sumThread.incrementAndGet();
        }
        try {
            this.execute();
        }
        catch (Exception e) {
            if (this.taskMap != null && this.taskMap.get("taskExecutor") != null && !this.taskMap.containsKey("msg")) {
                this.taskMap.put("msg", StringUtils.isNotBlank((CharSequence)e.getMessage()) ? e.getMessage() : "");
                ThreadPoolTaskExecutor threadPoolTaskExecutor = (ThreadPoolTaskExecutor)this.taskMap.get("taskExecutor");
                threadPoolTaskExecutor.setWaitForTasksToCompleteOnShutdown(false);
                threadPoolTaskExecutor.destroy();
                LOGGER.error(threadPoolTaskExecutor.getThreadNamePrefix(), (Throwable)e);
            } else if (MapUtils.isEmpty(this.taskMap)) {
                LOGGER.error(null, (Throwable)e);
            }
        }
        finally {
            if (!this.sfbjs) {
                sumThread.decrementAndGet();
            }
        }
    }

    public abstract void execute() throws Exception;

    public void setTaskMap(Map<String, Object> taskMap) {
        this.taskMap = taskMap;
    }

    public void setSfbjs(boolean sfbjs) {
        this.sfbjs = sfbjs;
    }

    public boolean isSfbjs() {
        return this.sfbjs;
    }
}

