/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.utils.qrcode;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class FileUtil {
    public static void mkDir(File file) throws FileNotFoundException {
        if (file.getParentFile() == null) {
            file = file.getAbsoluteFile();
        }
        if (file.getParentFile().exists()) {
            if (!file.exists() && !file.mkdir()) {
                throw new FileNotFoundException();
            }
        } else {
            FileUtil.mkDir(file.getParentFile());
            if (!file.exists() && !file.mkdir()) {
                throw new FileNotFoundException();
            }
        }
    }

    public static File createFile(String filename) throws FileNotFoundException {
        if (filename == null || "".equals(filename)) {
            return null;
        }
        int index = filename.lastIndexOf(47);
        if (index <= 0) {
            return new File(filename);
        }
        String path = filename.substring(0, index);
        FileUtil.mkDir(new File(path));
        return new File(filename);
    }

    public static String convertFileToBase64(String imgPath) {
        byte[] data = null;
        try {
            FileInputStream in = new FileInputStream(imgPath);
            System.out.println("\u6587\u4ef6\u5927\u5c0f\uff08\u5b57\u8282\uff09=" + ((InputStream)in).available());
            data = new byte[((InputStream)in).available()];
            ((InputStream)in).read(data);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BASE64Encoder encoder = new BASE64Encoder();
        String base64Str = encoder.encode(data);
        return base64Str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File convertBase64ToFile(String fileBase64String, String filePath, String fileName) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            File dir = new File(filePath);
            if (!dir.exists() && dir.isDirectory()) {
                dir.mkdirs();
            }
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] bfile = decoder.decodeBuffer(fileBase64String);
            file = new File(filePath + File.separator + fileName);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bfile);
            File file2 = file;
            return file2;
        }
        catch (Exception e) {
            e.printStackTrace();
            File file3 = null;
            return file3;
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static double base64file_size(String base64String) {
        int size0 = base64String.length();
        String tail = base64String.substring(size0 - 10);
        int equalIndex = tail.indexOf("=");
        if (equalIndex > 0) {
            size0 -= 10 - equalIndex;
        }
        return (double)size0 - (double)size0 / 8.0 * 2.0;
    }

    public static String bytesToKB(Double bytes) {
        BigDecimal megabyte;
        BigDecimal filesize = new BigDecimal(bytes.toString());
        float returnValue = filesize.divide(megabyte = new BigDecimal(0x100000), 1, 1).floatValue();
        if (returnValue > 1.0f) {
            return returnValue + "MB";
        }
        BigDecimal kilobyte = new BigDecimal(1024);
        returnValue = filesize.divide(kilobyte, 1, 1).floatValue();
        return returnValue + "KB";
    }
}

