/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.utils;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;

public class TableUtil {
    private static final String MERGE_TYPE_BG = "bg";
    private static final String MERGE_TYPE_DYG = "dyg";

    public static void mergeTable(String mergeType, XWPFDocument document, int startIndex, int endIndex) {
        if (!mergeType.startsWith(MERGE_TYPE_BG)) {
            return;
        }
        try {
            XWPFTable startTabel = document.getTableArray(startIndex);
            XWPFTable endTabel = document.getTableArray(endIndex);
            for (int i = 0; i < endTabel.getRows().size(); ++i) {
                startTabel.addRow(endTabel.getRow(i));
            }
            int tablesIndex = document.getPosOfTable(endTabel);
            document.removeBodyElement(tablesIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void mergeCell(String mergeType, XWPFDocument document, int tableIndex, int colIndex, int rowStartIndex, String mergeCondition) {
        if (!mergeType.startsWith(MERGE_TYPE_DYG)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)mergeCondition)) {
            CTVMerge startMerge = CTVMerge.Factory.newInstance();
            startMerge.setVal(STMerge.RESTART);
            CTVMerge endMerge = CTVMerge.Factory.newInstance();
            endMerge.setVal(STMerge.CONTINUE);
            XWPFTable table = (XWPFTable)document.getTables().get(tableIndex);
            table.getRow(rowStartIndex).getCell(colIndex).getCTTc().getTcPr().setVMerge(startMerge);
            for (int i = rowStartIndex + 1; i <= table.getRows().size() - 1; ++i) {
                table.getRow(i).getCell(colIndex).getCTTc().getTcPr().setVMerge(endMerge);
            }
            return;
        }
        if (StringUtils.equals((CharSequence)"same", (CharSequence)mergeCondition)) {
            XWPFTable table = (XWPFTable)document.getTables().get(tableIndex);
            if (rowStartIndex >= table.getRows().size()) {
                return;
            }
            List<JSONObject> list = TableUtil.findSameRow(table, rowStartIndex);
            for (JSONObject jsonObject : list) {
                int start = jsonObject.getInteger("start");
                int end = jsonObject.getInteger("end");
                CTVMerge startMerge = CTVMerge.Factory.newInstance();
                startMerge.setVal(STMerge.RESTART);
                CTVMerge endMerge = CTVMerge.Factory.newInstance();
                endMerge.setVal(STMerge.CONTINUE);
                table.getRow(start).getCell(0).getCTTc().getTcPr().setVMerge(startMerge);
                for (int i = start + 1; i < end; ++i) {
                    table.getRow(i).getCell(0).getCTTc().getTcPr().setVMerge(endMerge);
                }
            }
        }
    }

    private static List<JSONObject> findSameRow(XWPFTable table, int rowStartIndex) {
        int startIndex = 0;
        String startText = table.getRow(startIndex).getCell(0).getText();
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        for (int endIndex = 1; endIndex < table.getRows().size(); ++endIndex) {
            String endText = table.getRow(endIndex).getCell(0).getText();
            if (StringUtils.equals((CharSequence)startText, (CharSequence)endText)) continue;
            if (endIndex - startIndex > 1) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("start", (Object)startIndex);
                jsonObject.put("end", (Object)endIndex);
                list.add(jsonObject);
            }
            startIndex = endIndex;
            startText = table.getRow(startIndex).getCell(0).getText();
        }
        return list;
    }
}

