/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.utils;

import cn.gtmap.dysjy.common.utils.DateUtils;
import cn.gtmap.dysjy.common.utils.ResultHandleUtils;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringToolUtils
extends StringUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringToolUtils.class);

    public static String replaceBracket(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        if (str.indexOf("\uff08") != -1) {
            str = str.replaceAll("\uff08", "(");
        }
        if (str.indexOf("\uff09") != -1) {
            str = str.replaceAll("\uff09", ")");
        }
        return str;
    }

    public static String replaceXml(String key, Object value, String xml, Map dataMap) {
        try {
            String defaultValue;
            xml = xml.replaceAll("\\$&amp;", "&");
            xml = xml.replaceAll("&amp;", "&");
            xml = xml.replaceAll("&lt;", "<");
            xml = xml.replaceAll("&gt;", ">");
            value = StringToolUtils.getValue(key, value, dataMap);
            if (ResultHandleUtils.isMethodString(key)) {
                return ResultHandleUtils.replaceXml(key, value, xml, dataMap);
            }
            if (value instanceof String && StringUtils.isBlank((CharSequence)((String)value)) && StringUtils.isNotBlank((CharSequence)(defaultValue = ResultHandleUtils.getDefaultValue(xml, key)))) {
                value = defaultValue;
            }
            xml = xml.replaceAll("\\>\\$" + StringUtils.upperCase((String)key) + "\\<", "\\>" + value + "\\<");
            xml = xml.replaceAll("\\>\\$" + StringUtils.lowerCase((String)key) + "\\<", "\\>" + value + "\\<");
            xml = xml.replaceAll("\\>\\$" + key + "\\<", "\\>" + value + "\\<");
            xml = xml.replaceAll("\\$\\{" + StringUtils.upperCase((String)key) + "\\}", String.valueOf(value));
            xml = xml.replaceAll("\\$\\{" + StringUtils.lowerCase((String)key) + "\\}", String.valueOf(value));
            xml = xml.replaceAll("\\$\\{" + key + "\\}", String.valueOf(value));
        }
        catch (Exception e) {
            LOGGER.debug("replaceAll \u5f02\u5e38", (Throwable)e);
        }
        return xml;
    }

    private static Object getValue(String key, Object value, Map dataMap) {
        if (Objects.nonNull(value) && StringUtils.isNotBlank((CharSequence)value.toString())) {
            return value;
        }
        value = dataMap.get(key.toLowerCase());
        if (Objects.nonNull(value) && StringUtils.isNotBlank((CharSequence)value.toString())) {
            return value;
        }
        value = dataMap.get(key.toUpperCase());
        if (Objects.nonNull(value) && StringUtils.isNotBlank((CharSequence)value.toString())) {
            return value;
        }
        if (StringUtils.startsWith((CharSequence)key, (CharSequence)"dydatetime")) {
            Date date = new Date();
            String pattern = "yyyy\u5e74MM\u6708dd\u65e5";
            String[] timeArray = key.split("_");
            if (timeArray.length > 1) {
                pattern = timeArray[1];
            }
            if (timeArray.length > 2) {
                String dataKey = timeArray[2];
                value = StringToolUtils.getValue(dataKey, dataMap);
                if (Objects.isNull(value)) {
                    return "";
                }
                if (value instanceof Date) {
                    date = (Date)value;
                } else if (value instanceof Long) {
                    date.setTime((Long)value);
                }
            }
            return DateUtils.formateTime(date, DateTimeFormatter.ofPattern(pattern, Locale.CHINA));
        }
        return "";
    }

    private static Object getValue(String key, Map dataMap) {
        if (StringUtils.isBlank((CharSequence)key) || MapUtils.isEmpty((Map)dataMap)) {
            return null;
        }
        Object value = dataMap.get(key);
        if (Objects.isNull(value)) {
            value = dataMap.get(key.toLowerCase());
        }
        if (Objects.isNull(value)) {
            value = dataMap.get(key.toUpperCase());
        }
        return value;
    }

    public static String valueOf(Object obj, String defaultVal) {
        return obj == null ? defaultVal : obj.toString();
    }
}

