/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.utils;

import cn.gtmap.dysjy.common.domain.BdcDysjMethod;
import cn.gtmap.dysjy.common.spring.DyContainer;
import cn.gtmap.dysjy.common.utils.CoeRuntimeContext;
import cn.gtmap.dysjy.common.utils.ExpressEvalUtil;
import cn.gtmap.dysjy.common.utils.JsonObjectUtil;
import cn.gtmap.dysjy.common.utils.UUIDGenerator;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultHandleUtils {
    private static final String ROW_DEFAULT_VALUE_REG = "default=\".*\"";
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultHandleUtils.class);

    public static String replaceXml(String key, Object value, String xml, Map dataMap) {
        if (!ResultHandleUtils.isMethodString(key)) {
            return xml;
        }
        try {
            String defaultValue;
            HashMap tempMap = new HashMap();
            tempMap.putAll(dataMap);
            Object realValue = null;
            realValue = ResultHandleUtils.isExpress(xml, key) ? ExpressEvalUtil.evalExpressString(key, dataMap) : ResultHandleUtils.getMethodKeyValue(key, tempMap, "");
            if ((Objects.isNull(realValue) || realValue instanceof String && StringUtils.isBlank((CharSequence)((String)realValue))) && StringUtils.isBlank((CharSequence)((String)(realValue = value))) && StringUtils.isNotBlank((CharSequence)(defaultValue = ResultHandleUtils.getDefaultValue(xml, key)))) {
                realValue = defaultValue;
            }
            int i = 0;
            if (StringUtils.isNotBlank((CharSequence)realValue.toString())) {
                realValue = realValue.toString().replace("\\)", ")");
                realValue = realValue.toString().replace("\\\uff09", "\uff09");
                realValue = realValue.toString().replace("\\(", "(");
                realValue = realValue.toString().replace("\\\uff08", "\uff08");
            }
            while (xml.contains("$" + key) && i < 10) {
                xml = xml.substring(0, xml.indexOf("$" + key)) + realValue + xml.substring(xml.indexOf("$" + key) + key.length() + 1);
                ++i;
            }
            return xml;
        }
        catch (Exception e) {
            LOGGER.debug("\u66ff\u6362xml\u5f02\u5e38 key: {}, value: {}, xml: {}", new Object[]{key, value, xml, e});
            return xml;
        }
    }

    public static String getDefaultValue(String xml, String key) {
        String matchString = "default-" + key + "=";
        String defaultReg = matchString + "\".*\"";
        Pattern defaultPattern = Pattern.compile(defaultReg);
        Matcher defaultMatcher = defaultPattern.matcher(xml.toLowerCase());
        if (defaultMatcher.find()) {
            String defaultValue = defaultMatcher.group().replace(matchString, "").replace("\"", "");
            return defaultValue;
        }
        xml = xml.toLowerCase();
        key = key.toLowerCase();
        String defaultValue = "";
        String xmlRowReg = "<data.*>.*" + key.replaceAll("\\?", "\\\\?") + ".*</data>";
        Pattern pattern = Pattern.compile(xmlRowReg);
        Matcher matcher = pattern.matcher(xml);
        if (matcher.find()) {
            String targetRowXml = matcher.group();
            Pattern pattern1 = Pattern.compile(ROW_DEFAULT_VALUE_REG);
            Matcher matcher1 = pattern1.matcher(targetRowXml);
            if (matcher1.find()) {
                defaultValue = matcher1.group().replace("default=", "").replace("\"", "");
            }
        }
        return defaultValue;
    }

    private static String[] getRealKey(String key) {
        int start = key.indexOf("(");
        int end = key.indexOf(")");
        if (start < 0 || end < 0) {
            return new String[]{key};
        }
        if (end == start + 1) {
            return new String[0];
        }
        String[] keyArray = key.substring(start + 1, end).split(",");
        for (int i = 0; i < keyArray.length; ++i) {
            keyArray[i] = keyArray[i].trim();
        }
        return keyArray;
    }

    private static String getRealResultByKey(String key, Map dataMap) {
        try {
            String classAndMethod = key.split("\\(")[0];
            int index = classAndMethod.lastIndexOf(".");
            String className = classAndMethod.substring(0, index);
            String methodName = classAndMethod.substring(index + 1);
            Class<?> clazz = Class.forName(className);
            Object targetValueObject = ResultHandleUtils.getValue(clazz, methodName, key, dataMap);
            String value = ResultHandleUtils.getPropValue(dataMap, key, targetValueObject);
            if (Objects.nonNull(value)) {
                return value;
            }
            return null;
        }
        catch (Exception e1) {
            String value = ExpressEvalUtil.evalExpressString(key, dataMap);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                return value;
            }
            return null;
        }
    }

    private static String getPropValue(Map dataMap, String key, Object targetValueObject) {
        if (Objects.isNull(targetValueObject)) {
            return "";
        }
        if (targetValueObject instanceof String || targetValueObject instanceof Boolean || targetValueObject instanceof BigDecimal || targetValueObject instanceof Double || targetValueObject instanceof Float || targetValueObject instanceof Integer || targetValueObject instanceof Long || targetValueObject instanceof Short) {
            return targetValueObject.toString();
        }
        if (!JSONObject.isValidObject((String)JSON.toJSONString((Object)targetValueObject))) {
            String uuid = "uuid_" + UUIDGenerator.generate16();
            dataMap.put(uuid, targetValueObject);
            return uuid;
        }
        if (key.indexOf(").") < 0) {
            if (Objects.nonNull(targetValueObject)) {
                if (targetValueObject instanceof Map && MapUtils.isEmpty((Map)((Map)targetValueObject))) {
                    return null;
                }
                return targetValueObject.toString();
            }
            return null;
        }
        String propName = key.split("\\).")[1];
        Object result = JsonObjectUtil.getJsonObjectValue(propName, targetValueObject);
        if (Objects.nonNull(result)) {
            return result.toString();
        }
        return "";
    }

    private static BdcDysjMethod getBdcDysjMethod(String key) {
        List bdcDysjMethodList = (List)CoeRuntimeContext.getRuntimeData("BDC_DYSJ_METHOD_LIST");
        if (CollectionUtils.isEmpty((Collection)bdcDysjMethodList)) {
            return null;
        }
        for (BdcDysjMethod bdcDysjMethod : bdcDysjMethodList) {
            if (!StringUtils.equals((CharSequence)bdcDysjMethod.getClassMethod(), (CharSequence)key)) continue;
            return bdcDysjMethod;
        }
        return null;
    }

    private static Object getValue(Class clazz, String methodName, String key, Map dataMap) {
        Method[] methodList = clazz.getDeclaredMethods();
        if (null == methodList || methodList.length == 0) {
            return null;
        }
        String[] keyArray = ResultHandleUtils.getRealKey(key);
        BdcDysjMethod bdcDysjMethod = ResultHandleUtils.getBdcDysjMethod(clazz.getName() + "." + methodName + "-" + keyArray.length);
        if (Objects.isNull(bdcDysjMethod)) {
            LOGGER.error("\u65b9\u6cd5\u4e0d\u5141\u8bb8\u8c03\u7528 classAndMethod: {}, paramCount: {}", (Object)(clazz.getName() + "." + methodName), (Object)keyArray.length);
            return new JSONObject();
        }
        for (Method method : methodList) {
            if (!method.getName().equals(methodName) || method.getParameterCount() != keyArray.length) continue;
            try {
                Class<?>[] methodClassList = method.getParameterTypes();
                ArrayList<Object> paramList = new ArrayList<Object>();
                for (int j = 0; j < methodClassList.length; ++j) {
                    Class<?> methodClass = methodClassList[j];
                    paramList.add(ResultHandleUtils.paramValue(methodClass, dataMap, keyArray, j));
                }
                Object result = CoeRuntimeContext.getRuntimeData(ResultHandleUtils.genCahceKey(clazz, methodName, paramList));
                if (Objects.nonNull(result)) {
                    return result;
                }
                Object object = ResultHandleUtils.getObject(clazz, method);
                result = method.invoke(object, paramList.toArray());
                if (!Objects.nonNull(result)) continue;
                CoeRuntimeContext.setRuntimeData(ResultHandleUtils.genCahceKey(clazz, methodName, paramList), result);
                return result;
            }
            catch (Exception e) {
                LOGGER.debug("\u8c03\u7528\u65b9\u6cd5\u5904\u7406\u8fd4\u56de\u7ed3\u679c\u6570\u636e\u5f02\u5e38 methodName: {}, key: {}", new Object[]{methodName, key, e});
            }
        }
        return null;
    }

    private static Object getObject(Class clazz, Method method) throws InstantiationException, IllegalAccessException {
        Object object = null;
        if (Modifier.isStatic(method.getModifiers())) {
            return object;
        }
        try {
            object = DyContainer.getBean(clazz);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Objects.isNull(object)) {
            object = clazz.newInstance();
        }
        return object;
    }

    private static String genCahceKey(Class clazz, String methodName, List<Object> paramList) {
        List stringList = paramList.stream().map(obj -> Objects.isNull(obj) ? "null" : obj.toString()).collect(Collectors.toList());
        Object[] array = new String[]{clazz.getName(), methodName, StringUtils.join(stringList, (String)"-")};
        return StringUtils.join((Object[])array, (String)"-");
    }

    private static Object paramValue(Class clazz, Map dataMap, String[] keyArray, int index) {
        String keyj = null;
        String value = null;
        try {
            keyj = keyArray[index];
            if (StringUtils.isNotBlank((CharSequence)keyj) && keyj.startsWith("\"") && keyj.endsWith("\"")) {
                return keyj.substring(1, keyj.length() - 1);
            }
            value = (String)dataMap.get(keyj);
            if (Objects.isNull(value)) {
                value = (String)dataMap.get(keyj.toLowerCase());
            }
            if (Objects.isNull(value)) {
                value = (String)dataMap.get(keyj.toUpperCase());
            }
            if (Objects.isNull(value) && !StringUtils.equals((CharSequence)"null", (CharSequence)keyj)) {
                value = keyj;
            }
            if (Objects.isNull(value)) {
                return null;
            }
            if (String.class.equals((Object)clazz)) {
                return value.toString();
            }
            if (BigDecimal.class.equals((Object)clazz)) {
                return new BigDecimal(value.toString());
            }
            if (StringBuffer.class.equals((Object)clazz)) {
                return new StringBuffer(value.toString());
            }
            if (StringBuilder.class.equals((Object)clazz)) {
                return new StringBuilder(value.toString());
            }
            if (Integer.class.equals((Object)clazz) || Integer.TYPE.equals(clazz)) {
                return new Integer(value.toString());
            }
            if (Long.class.equals((Object)clazz) || Long.TYPE.equals(clazz)) {
                return Long.valueOf(value.toString());
            }
            if (Float.class.equals((Object)clazz) || Float.TYPE.equals(clazz)) {
                return new Float(value.toString());
            }
            if (Double.class.equals((Object)clazz) || Double.TYPE.equals(clazz)) {
                return new Double(value.toString());
            }
            if (value.getClass().equals(JSONArray.class) || value instanceof List) {
                return value;
            }
            JSONObject jsonObject = JSON.parseObject((String)keyj);
            for (String key : jsonObject.keySet()) {
                Object jsonValue = jsonObject.get((Object)key);
                Object val = dataMap.get(jsonValue);
                if (!Objects.nonNull(val)) continue;
                jsonObject.put(key, val);
            }
            return JSON.parseObject((String)JSON.toJSONString((Object)jsonObject), (Class)clazz);
        }
        catch (Exception e) {
            LOGGER.debug("paramValue \u5f02\u5e38 keyj: {}, value: {}", (Object)keyj, value);
            return null;
        }
    }

    public static boolean isExpress(String xml, String key) {
        try {
            if (!xml.contains(key)) {
                return false;
            }
            int end = xml.indexOf(key);
            xml = xml.substring(0, end);
            int start = xml.lastIndexOf("<data");
            xml = xml.substring(start);
            String express = "";
            Pattern pattern1 = Pattern.compile("express=\".*\"");
            Matcher matcher1 = pattern1.matcher(xml);
            if (matcher1.find()) {
                express = matcher1.group().replace("express=", "").replace("\"", "");
            }
            return StringUtils.equals((CharSequence)express, (CharSequence)"true");
        }
        catch (Exception e) {
            LOGGER.error("isExpress \u5f02\u5e38 xml: {}, key: {}", new Object[]{xml, key, e});
            return false;
        }
    }

    private static String getMethodKeyValue(String key, Map dataMap, String resultString) {
        if (!ResultHandleUtils.isMethodString(key) || !ResultHandleUtils.isMethodString(key.replace(resultString, ""))) {
            return key;
        }
        Object value = CoeRuntimeContext.getRuntimeData(ResultHandleUtils.cacheKey(key, dataMap));
        if (Objects.nonNull(value)) {
            return value.toString();
        }
        int leftIndex = 0;
        block4: for (int i = 0; i < key.length(); ++i) {
            char tempChar = key.charAt(i);
            switch (tempChar) {
                case '(': {
                    if (i > 0 && StringUtils.equals((CharSequence)"\\", (CharSequence)String.valueOf(key.charAt(i - 1)))) continue block4;
                    leftIndex = i;
                    continue block4;
                }
                case ')': {
                    if (i > 0 && StringUtils.equals((CharSequence)"\\", (CharSequence)String.valueOf(key.charAt(i - 1)))) continue block4;
                    String oldString = StringUtils.substring((String)key, (int)ResultHandleUtils.getStart(key, leftIndex), (int)ResultHandleUtils.getEnd(key, i));
                    String newString = ResultHandleUtils.getRealResultByKey(oldString, dataMap);
                    if (StringUtils.isBlank((CharSequence)newString)) {
                        newString = "";
                    }
                    CoeRuntimeContext.setRuntimeData(ResultHandleUtils.cacheKey(key, dataMap), newString);
                    String result = key.replace(oldString, newString);
                    if (StringUtils.equals((CharSequence)result, (CharSequence)("(" + newString + ")"))) {
                        return newString;
                    }
                    return ResultHandleUtils.getMethodKeyValue(result, dataMap, newString);
                }
            }
        }
        CoeRuntimeContext.setRuntimeData(ResultHandleUtils.cacheKey(key, dataMap), key);
        return key;
    }

    private static String cacheKey(String key, Map dataMap) {
        return key + JSON.toJSONString((Object)dataMap);
    }

    public static boolean isMethodString(String param) {
        return !StringUtils.equals((CharSequence)"()", (CharSequence)param) && StringUtils.isNotBlank((CharSequence)param) && StringUtils.contains((CharSequence)param, (CharSequence)"(") && StringUtils.contains((CharSequence)param, (CharSequence)")") && StringUtils.indexOf((CharSequence)param, (CharSequence)"(") < StringUtils.indexOf((CharSequence)param, (CharSequence)")");
    }

    private static int getStart(String key, int end) {
        int index2;
        int index1 = StringUtils.lastIndexOf((CharSequence)(key = StringUtils.substring((String)key, (int)0, (int)end)), (CharSequence)",");
        int index = index1 < (index2 = StringUtils.lastIndexOf((CharSequence)key, (CharSequence)"(")) ? index2 : index1;
        return index + 1;
    }

    private static int getEnd(String key, int start) {
        key = StringUtils.substring((String)key, (int)(start + 1));
        int index1 = StringUtils.indexOf((CharSequence)key, (CharSequence)",");
        int index2 = StringUtils.indexOf((CharSequence)key, (CharSequence)")");
        int index = index1 < 0 && index2 < 0 ? key.length() : (index1 < 0 && index2 >= 0 ? index2 : (index2 < 0 && index1 >= 0 ? index1 : (index1 < index2 ? index1 : index2)));
        return start + index + 1;
    }

    public static String replaceParam(String dysjy, Map dataMap) {
        if (StringUtils.isBlank((CharSequence)dysjy)) {
            return dysjy;
        }
        HashMap<String, Object> tempMap = new HashMap<String, Object>();
        tempMap.putAll(dataMap);
        if (MapUtils.isNotEmpty((Map)dataMap)) {
            for (Object key2 : dataMap.keySet()) {
                Map<String, Object> valueMap;
                Object value = dataMap.get(key2);
                if (!JSONObject.isValidObject((String)value.toString()) || !MapUtils.isNotEmpty(valueMap = JsonObjectUtil.getJsonObjectValueMap(value.toString()))) continue;
                for (String newKey : valueMap.keySet()) {
                    tempMap.putIfAbsent(newKey, valueMap.get(newKey));
                }
            }
        }
        String tempString = dysjy;
        String exResult = dysjy;
        try {
            int end;
            int start;
            while ((start = tempString.indexOf("${")) > -1 && (end = tempString.indexOf("}")) >= start) {
                String methodValue;
                String method = tempString.substring(start + 2, end);
                if (ResultHandleUtils.isMethodString(method) && StringUtils.isNotBlank((CharSequence)(methodValue = ResultHandleUtils.getMethodKeyValue(method, tempMap, "")))) {
                    dysjy = dysjy.replace("${" + method + "}", methodValue);
                }
                tempString = tempString.substring(end + 1);
            }
        }
        catch (Exception e) {
            LOGGER.debug("\u53c2\u6570\u5904\u7406\u5f02\u5e38", (Throwable)e);
            return exResult;
        }
        tempMap.keySet().forEach(key -> dataMap.putIfAbsent(key, tempMap.get(key)));
        return dysjy;
    }
}

