/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.utils;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DysjyIPPortUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DysjyIPPortUtils.class);
    private static final String SPLIT = ":";
    private static final String PROTOCOL_HTTP = "http://";

    public static String getLocalPort() throws MalformedObjectNameException {
        MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> objectNames = beanServer.queryNames(new ObjectName("*:type=Connector,*"), Query.match(Query.attr("protocol"), Query.value("HTTP/1.1")));
        return objectNames.iterator().next().getKeyProperty("port");
    }

    public static String getLocalIP() {
        StringBuilder ipAddrStr = new StringBuilder();
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            LOGGER.error("\u672a\u77e5\u7684\u57df\u540d", (Throwable)e);
        }
        if (null != addr) {
            byte[] ipAddr = addr.getAddress();
            for (int i = 0; i < ipAddr.length; ++i) {
                if (i > 0) {
                    ipAddrStr = ipAddrStr.append(".");
                }
                ipAddrStr = ipAddrStr.append(ipAddr[i] & 0xFF);
            }
        }
        return ipAddrStr.toString();
    }

    public static String serverPath() {
        String ipAddrStr = DysjyIPPortUtils.getLocalIP();
        String port = null;
        try {
            port = DysjyIPPortUtils.getLocalPort();
        }
        catch (MalformedObjectNameException e) {
            LOGGER.error("\u7aef\u53e3\u83b7\u53d6\u5f02\u5e38\uff01", (Throwable)e);
        }
        if (StringUtils.isNotBlank((CharSequence)ipAddrStr) && StringUtils.isNotBlank((CharSequence)port)) {
            return PROTOCOL_HTTP + ipAddrStr + SPLIT + port;
        }
        return null;
    }

    public static String getClientIp(HttpServletRequest request) {
        if (request == null) {
            return "";
        }
        try {
            String ip = request.getHeader("x-forwarded-for");
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("Proxy-Client-IP");
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("WL-Proxy-Client-IP");
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_CLIENT_IP");
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_X_FORWARDED_FOR");
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getRemoteAddr();
            }
            return "0:0:0:0:0:0:0:1".equals(ip) ? "127.0.0.1" : ip;
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5ba2\u6237\u7aefip\u62a5\u9519" + e.getMessage());
            return "";
        }
    }
}

