/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.utils;

import cn.gtmap.dysjy.common.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DysjyDataUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DysjyDataUtil.class);
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static String sum(List<Object> dataList, String key) {
        if (CollectionUtils.isEmpty(dataList)) {
            return "";
        }
        if (CollectionUtils.isEmpty(dataList = dataList.stream().filter(object -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)JSON.parseObject((String)JSON.toJSONString((Object)object)).getString(key))).collect(Collectors.toList()))) {
            return "";
        }
        List bigDecimalList = dataList.stream().map(object -> new BigDecimal(JSON.parseObject((String)JSON.toJSONString((Object)object)).getString(key))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(bigDecimalList)) {
            return "";
        }
        BigDecimal sum = BigDecimal.ZERO;
        for (BigDecimal bigDecimal : bigDecimalList) {
            sum = sum.add(bigDecimal);
        }
        return sum.toString();
    }

    public static String joinString(List dataList, String key, String around, String delimiter) {
        try {
            List<String> stringList = DysjyDataUtil.getListString(dataList, key);
            if (CollectionUtils.isEmpty(stringList)) {
                return "";
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)delimiter)) {
                delimiter = ",";
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)around)) {
                stringList = stringList.stream().map(item -> around + item + around).collect(Collectors.toList());
            }
            return String.join((CharSequence)delimiter, stringList);
        }
        catch (Exception e) {
            LOGGER.error("joinString error dataList: {}, key: {}", new Object[]{JSON.toJSONString((Object)dataList), key, e});
            return "";
        }
    }

    public static String joinString(List dataList, String key, String delimiter) {
        try {
            List<String> stringList = DysjyDataUtil.getListString(dataList, key);
            if (CollectionUtils.isEmpty(stringList)) {
                return "";
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)delimiter)) {
                delimiter = ",";
            }
            return String.join((CharSequence)delimiter, stringList);
        }
        catch (Exception e) {
            LOGGER.error("joinString error dataList: {}, key: {}", new Object[]{JSON.toJSONString((Object)dataList), key, e});
            return "";
        }
    }

    public static String joinString(List dataList, String key, String delimiter, String filterKey, String filterValue) {
        try {
            List<String> stringList;
            if (CollectionUtils.isEmpty((Collection)dataList)) {
                return "";
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)filterKey)) {
                dataList = dataList.stream().filter(data -> {
                    JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)data));
                    return org.apache.commons.lang3.StringUtils.equals((CharSequence)filterValue, (CharSequence)jsonObject.getString(filterKey));
                }).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty(stringList = DysjyDataUtil.getListString(dataList, key))) {
                return "";
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)delimiter)) {
                delimiter = ",";
            }
            return String.join((CharSequence)delimiter, stringList);
        }
        catch (Exception e) {
            LOGGER.error("joinString error dataList: {}, key: {}", new Object[]{JSON.toJSONString((Object)dataList), key, e});
            return "";
        }
    }

    private static List<String> getListString(List dataList, String key) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return null;
        }
        List<String> stringList = dataList.stream().map(object -> {
            if (object instanceof String) {
                return object;
            }
            JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)object));
            String value = jsonObject.getString(key);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)value)) {
                value = jsonObject.getString(key.toLowerCase());
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)value)) {
                value = jsonObject.getString(key.toUpperCase());
            }
            return value;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(stringList)) {
            return stringList;
        }
        return stringList.stream().filter(data -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)data)).collect(Collectors.toList());
    }

    public static String dateFormat(String dateString, String sourceFormat, String targetFormat) {
        if (org.apache.commons.lang3.StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dateString, sourceFormat, targetFormat})) {
            return "";
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat(sourceFormat);
            Date date = format.parse(dateString);
            format = new SimpleDateFormat(targetFormat);
            return format.format(date);
        }
        catch (Exception e) {
            LOGGER.error("dateFormat error dateString: {}, sourceFormat: {}, targetFormat: {}", new Object[]{dateString, sourceFormat, targetFormat, e});
            return "";
        }
    }

    public static String currentDate2String(String formatString) {
        try {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)formatString)) {
                formatString = DEFAULT_DATE_FORMAT;
            }
            Date date = new Date();
            SimpleDateFormat format = new SimpleDateFormat(formatString);
            return format.format(new Date());
        }
        catch (Exception e) {
            LOGGER.error("currentDate2String error formatString: {}", (Object)formatString, (Object)e);
            return "";
        }
    }

    public static String date2String(Date date, String formatString) {
        if (StringUtils.isBlank((String)formatString)) {
            formatString = "yyyy\u5e74MM\u6708dd\u65e5";
        }
        return DateUtils.formateTime(date, DateTimeFormatter.ofPattern(formatString));
    }

    public static String long2String(long timestamp, String formatString) {
        Date date = new Date(timestamp);
        if (StringUtils.isBlank((String)formatString)) {
            formatString = "yyyy\u5e74MM\u6708dd\u65e5";
        }
        return DateUtils.formateTime(date, DateTimeFormatter.ofPattern(formatString));
    }
}

