/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtils.class);
    public static final DateTimeFormatter DATE_FORMATYMDHMS = DateTimeFormatter.ofPattern("yyyyMMddHHmmss", Locale.CHINA);
    public static SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");

    public static String formateTime(Date date, DateTimeFormatter dateTimeFormatter) {
        LocalDateTime localDateTime = DateUtils.date2LocalDateTime(date);
        return localDateTime.format(dateTimeFormatter);
    }

    public static String formateTimeYmdhms(Date date) {
        LocalDateTime localDateTime = DateUtils.date2LocalDateTime(date);
        return localDateTime.format(DATE_FORMATYMDHMS);
    }

    public static Date formatDate(String str, String pattern) {
        Date date = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)str)) {
                date = new SimpleDateFormat(pattern).parse(str);
            }
        }
        catch (ParseException e) {
            LOGGER.info("", (Throwable)e);
        }
        return date;
    }

    public static LocalDateTime date2LocalDateTime(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalDateTime();
    }
}

