/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.utils;

import cn.gtmap.dysjy.common.utils.JsonObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataParseUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataParseUtils.class);
    private static final String REGEX_NUMBER = "[0-9]+";
    private static final String BOOLEAN_CAP_TRUE = "TRUE";
    private static final String BOOLEAN_CAP_FALSE = "FALSE";
    private static final String BOOLEAN_LOW_TRUE = "true";
    private static final String BOOLEAN_LOW_FALSE = "false";

    public static <T> Object parseType(String dataId, String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        if (str.matches(REGEX_NUMBER)) {
            return Integer.parseInt(str);
        }
        if (BOOLEAN_CAP_TRUE.equals(str) || BOOLEAN_CAP_FALSE.equals(str) || BOOLEAN_LOW_TRUE.equals(str) || BOOLEAN_LOW_FALSE.equals(str)) {
            return Boolean.parseBoolean(str);
        }
        try {
            return new Gson().fromJson(str, new TypeToken<List<T>>(){}.getType());
        }
        catch (Exception exception) {
            try {
                return new Gson().fromJson(str, new TypeToken<List<String>>(){}.getType());
            }
            catch (Exception exception2) {
                try {
                    return new Gson().fromJson(str, new TypeToken<List<Integer>>(){}.getType());
                }
                catch (Exception exception3) {
                    try {
                        return new Gson().fromJson(str, new TypeToken<List<Map>>(){}.getType());
                    }
                    catch (Exception exception4) {
                        try {
                            ArrayList<Object> list = new ArrayList<Object>();
                            Map<String, Object> map = (Map<String, Object>)new Gson().fromJson(str, new TypeToken<Map>(){}.getType());
                            map = JsonObjectUtil.getJsonObjectValueMap(JSON.toJSONString((Object)map));
                            if (StringUtils.isNotBlank((CharSequence)dataId) && map.containsKey(dataId)) {
                                Object object = map.get(dataId);
                                try {
                                    JSONArray jsonArray = JSON.parseArray((String)String.valueOf(object));
                                    for (Object jsonObject : jsonArray) {
                                        list.add(JSON.parseObject((String)JSON.toJSONString(jsonObject)));
                                    }
                                    return list;
                                }
                                catch (Exception exception5) {
                                    // empty catch block
                                }
                            }
                            if (StringUtils.isBlank((CharSequence)dataId)) {
                                list.add(map);
                            }
                            return list;
                        }
                        catch (Exception exception6) {
                            LOGGER.debug("\u6570\u636e\u89e3\u6790\u5f02\u5e38 str: {}", (Object)str);
                            return str;
                        }
                    }
                }
            }
        }
    }
}

