/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.utils;

import cn.gtmap.dysjy.common.dto.ObjectFieldsDTO;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BeansResolveUtils
implements ApplicationContextAware {
    private static String DATE_FORMAT = new String("yyyy-MM-dd HH:mm:ss");
    private static final Logger LOGGER = LoggerFactory.getLogger(BeansResolveUtils.class);
    private static final String CLASS_NAME = BeansResolveUtils.class.getName();
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        if (null == this.applicationContext) {
            this.applicationContext = applicationContext;
        }
    }

    public <T> T getBeanByName(String name) {
        if (null == this.applicationContext || StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return (T)this.applicationContext.getBean(name);
    }

    public static List<String> getClassFieldsName(Field[] fields) {
        if (null == fields || 0 == fields.length) {
            return Collections.emptyList();
        }
        ArrayList<String> fieldsNameList = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            if (null == field) continue;
            fieldsNameList.add(field.getName());
        }
        return fieldsNameList;
    }

    public static Set<String> getSameFieldNames(ObjectFieldsDTO sourceObjFieldsDTO, ObjectFieldsDTO targetedObjFieldsDTO) {
        if (CollectionUtils.isEmpty(sourceObjFieldsDTO.getFieldNameSet()) || CollectionUtils.isEmpty(targetedObjFieldsDTO.getFieldNameSet())) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> sameFieldNamesSet = new HashSet<String>();
        for (String sourceFieldName : sourceObjFieldsDTO.getFieldNameSet()) {
            if (!targetedObjFieldsDTO.getFieldNameSet().contains(sourceFieldName)) continue;
            sameFieldNamesSet.add(sourceFieldName);
        }
        return sameFieldNamesSet;
    }

    public static <T> List<T> convertMapListToBeanList(List<Map> mapList, Class<T> clazz) {
        ArrayList<T> list = new ArrayList<T>();
        for (Map map : mapList) {
            try {
                T obj = clazz.newInstance();
                for (Object o : map.keySet()) {
                    for (Method m : clazz.getMethods()) {
                        if (!m.getName().toLowerCase().equals("set" + o.toString().toLowerCase())) continue;
                        m.invoke(obj, map.get(o));
                    }
                }
                list.add(obj);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
                LOGGER.error("map\u8f6c\u6362\u4e3a\u5b9e\u4f53\u5931\u8d25");
            }
        }
        return list;
    }

    public static <T> T convertMap2Bean(Map<String, Object> map, Class<T> T) {
        if (map == null || map.size() == 0) {
            return null;
        }
        Object mvalue = null;
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        Iterator<Map.Entry<String, Object>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            String key = it.next().getKey();
            mvalue = map.get(key);
            newMap.put(key.toUpperCase(Locale.US), mvalue);
        }
        T bean = null;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(T);
            bean = T.newInstance();
            for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
                String propertyName = descriptor.getName();
                String upperPropertyName = propertyName.toUpperCase();
                if (!newMap.keySet().contains(upperPropertyName)) continue;
                Object value = newMap.get(upperPropertyName);
                BeanUtils.copyProperty(bean, (String)propertyName, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bean;
    }
}

