/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.spirepdf;

import com.alibaba.fastjson.JSONObject;
import com.deepoove.poi.NiceXWPFDocument;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.template.ElementTemplate;
import com.deepoove.poi.template.run.RunTemplate;
import com.deepoove.poi.util.TableTools;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpireParagraphTablePolicy
implements RenderPolicy {
    public static final Logger LOGGER = LoggerFactory.getLogger(SpireParagraphTablePolicy.class);
    private static final String PDF_WORD_SUBTABLE_CELL_START2_REG = "[[";
    private static final String PDF_WORD_SUBTABLE_CELL_END_REG = "]]";
    private static final String PDF_WORD_SUBTABLE_NAME_REG = "\\{\\{TABLE_DL_[A-Za-z0-9_]+\\}\\}";
    private static final String PDF_WORD_SUBTABLE_NAME_REG_LOWER = "\\{\\{TABLE_dl_[A-Za-z0-9_]+\\}\\}";
    private static final String PDF_WORD_SUBTABLE_CELL_REG = "\\[\\[[A-Za-z0-9_]+\\]\\]";

    public SpireParagraphTablePolicy(Map<String, Object> data) {
    }

    public void render(ElementTemplate eleTemplate, Object data, XWPFTemplate template) {
        NiceXWPFDocument doc = template.getXWPFDocument();
        RunTemplate runTemplate = (RunTemplate)eleTemplate;
        XWPFRun run = runTemplate.getRun();
        try {
            if (!TableTools.isInsideTable((XWPFRun)run)) {
                throw new IllegalStateException("The template tag " + runTemplate.getSource() + " must be inside a table");
            }
            XmlCursor newCursor = ((XWPFParagraph)run.getParent()).getCTP().newCursor();
            newCursor.toParent();
            newCursor.toParent();
            newCursor.toParent();
            XmlObject object = newCursor.getObject();
            XWPFTable table = doc.getTableByCTTbl((CTTbl)object);
            this.render(table, data);
        }
        catch (Exception e) {
            throw new RenderException("dynamic table error:" + e.getMessage(), e);
        }
    }

    private void render(XWPFTable table, Object data) {
        if (null == table || null == data) {
            LOGGER.error("PDF\u3001WORD\u5904\u7406\u6570\u636e\u8868\u683c\u4e2d\u6b62\uff0c\u539f\u56e0\uff1a\u6ca1\u6709\u5b9a\u4e49\u6570\u636e\u8868\u683c\u6216\u8005\u65e0\u5bf9\u5e94\u6570\u636e\uff01");
            return;
        }
        List tableData = (List)data;
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)tableData)) {
            LOGGER.error("PDF\u3001WORD\u5904\u7406\u6570\u636e\u8868\u683c\u4e2d\u6b62\uff0c\u539f\u56e0\uff1a\u65e0\u5bf9\u5e94\u6570\u636e\uff01");
            return;
        }
        try {
            this.resolveGeneralTable(table, tableData);
        }
        catch (Exception exception) {
            LOGGER.error("\u5bfc\u51faPDF\u3001WORD\u5904\u7406\u5b50\u8868\u51fa\u73b0\u9519\u8bef\uff1a{}", (Object)exception.getMessage());
            throw exception;
        }
    }

    private void resolveGeneralTable(XWPFTable table, List<Map<String, Object>> data) {
        JSONObject resultMap = SpireParagraphTablePolicy.findTableSourceRow(table);
        int rowNum = resultMap.getInteger("rowNum");
        for (int i = 0; i < data.size(); ++i) {
            XWPFTableRow sourceRow = table.getRow(rowNum - 1);
            SpireParagraphTablePolicy.copyRow(table, sourceRow, rowNum, data.get(i));
        }
        table.removeRow(rowNum + data.size());
        table.removeRow(rowNum - 1);
    }

    private static JSONObject findTableSourceRow(XWPFTable table) {
        if (CollectionUtils.isEmpty((Collection)table.getRows())) {
            return null;
        }
        Pattern pattern = Pattern.compile(PDF_WORD_SUBTABLE_NAME_REG);
        Pattern patternlower = Pattern.compile(PDF_WORD_SUBTABLE_NAME_REG_LOWER);
        JSONObject resultMap = new JSONObject();
        for (int i = 0; i < table.getRows().size(); ++i) {
            XWPFTableRow row = table.getRow(i);
            if (CollectionUtils.isEmpty((Collection)row.getTableCells())) continue;
            for (int j = 0; j < row.getTableCells().size(); ++j) {
                String text = row.getCell(j).getText();
                if (!StringUtils.isNotBlank((CharSequence)text) || !pattern.matcher(text).find() && !patternlower.matcher(text).find()) continue;
                resultMap.put("rowNum", (Object)i);
                return resultMap;
            }
        }
        return resultMap;
    }

    public static void copyRow(XWPFTable table, XWPFTableRow sourceRow, int rowNum, Map<String, Object> dataMap) {
        XWPFTableRow newRow = table.insertNewTableRow(rowNum);
        newRow.getCtRow().setTrPr(sourceRow.getCtRow().getTrPr());
        for (int i = 0; i < sourceRow.getTableCells().size(); ++i) {
            XWPFTableCell oldCell = sourceRow.getCell(i);
            XWPFTableCell newCell = newRow.createCell();
            newCell.getCTTc().setTcPr(oldCell.getCTTc().getTcPr());
            newCell.removeParagraph(0);
            for (int j = 0; j < oldCell.getParagraphs().size(); ++j) {
                XWPFParagraph oldXWPFParagraph = (XWPFParagraph)oldCell.getParagraphs().get(j);
                XWPFParagraph newXWPFParagraph = newCell.addParagraph();
                newXWPFParagraph.getCTP().setPPr(oldXWPFParagraph.getCTP().getPPr());
                for (int k = 0; k < oldXWPFParagraph.getRuns().size(); ++k) {
                    XWPFRun oldRun = (XWPFRun)oldXWPFParagraph.getRuns().get(k);
                    XWPFRun newRun = newXWPFParagraph.createRun();
                    String oldText = oldRun.text();
                    LOGGER.debug("======= oldText: {}", (Object)oldText);
                    Pattern pattern = Pattern.compile(PDF_WORD_SUBTABLE_CELL_REG);
                    Matcher matcher = pattern.matcher(oldText);
                    newRun.setBold(oldRun.isBold());
                    newRun.getCTR().setRPr(oldRun.getCTR().getRPr());
                    if (matcher.find()) {
                        String key = matcher.group().replace(PDF_WORD_SUBTABLE_CELL_START2_REG, "").replace(PDF_WORD_SUBTABLE_CELL_END_REG, "");
                        Object resultObject = dataMap.get(key);
                        String resultString = null == resultObject ? "" : resultObject.toString();
                        newRun.setText(resultString, 0);
                        continue;
                    }
                    newRun.setText(oldRun.text(), 0);
                }
            }
        }
    }
}

