/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.spirepdf;

import cn.gtmap.dysjy.common.utils.PolicyUtil;
import com.alibaba.fastjson.JSONObject;
import com.deepoove.poi.NiceXWPFDocument;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.template.ElementTemplate;
import com.deepoove.poi.template.run.RunTemplate;
import com.deepoove.poi.util.TableTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SpireGeneralTablePolicy
implements RenderPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpireGeneralTablePolicy.class);
    private static final String PDF_WORD_SUBTABLE_CELL_START2_REG = "{{CELL_";
    private static final String PDF_WORD_SUBTABLE_CELL_END_REG = "}}";
    private static final String PDF_WORD_SUBTABLE_NAME_REG = "\\{\\{TABLE_[A-Za-z0-9_]+\\}\\}";
    private static final String PDF_WORD_SUBTABLE_CELL_REG = "\\{\\{CELL_[A-Za-z0-9_]+\\}\\}";

    public void render(ElementTemplate eleTemplate, Object data, XWPFTemplate template) {
        NiceXWPFDocument doc = template.getXWPFDocument();
        RunTemplate runTemplate = (RunTemplate)eleTemplate;
        XWPFRun run = runTemplate.getRun();
        try {
            if (!TableTools.isInsideTable((XWPFRun)run)) {
                throw new IllegalStateException("The template tag " + runTemplate.getSource() + " must be inside a table");
            }
            XmlCursor newCursor = ((XWPFParagraph)run.getParent()).getCTP().newCursor();
            newCursor.toParent();
            newCursor.toParent();
            newCursor.toParent();
            XmlObject object = newCursor.getObject();
            XWPFTable table = doc.getTableByCTTbl((CTTbl)object);
            this.render(table, data);
        }
        catch (Exception e) {
            throw new RenderException("dynamic table error:" + e.getMessage(), e);
        }
    }

    private void render(XWPFTable table, Object data) {
        if (null == table || null == data) {
            LOGGER.error("PDF\u3001WORD\u5904\u7406\u6570\u636e\u8868\u683c\u4e2d\u6b62\uff0c\u539f\u56e0\uff1a\u6ca1\u6709\u5b9a\u4e49\u6570\u636e\u8868\u683c\u6216\u8005\u65e0\u5bf9\u5e94\u6570\u636e\uff01");
            return;
        }
        List tableData = (List)data;
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)tableData)) {
            LOGGER.error("PDF\u3001WORD\u5904\u7406\u6570\u636e\u8868\u683c\u4e2d\u6b62\uff0c\u539f\u56e0\uff1a\u65e0\u5bf9\u5e94\u6570\u636e\uff01");
            return;
        }
        try {
            this.resolveGeneralTable(table, tableData);
        }
        catch (Exception exception) {
            LOGGER.error("\u5bfc\u51faPDF\u3001WORD\u5904\u7406\u5b50\u8868\u51fa\u73b0\u9519\u8bef\uff1a{}", (Object)exception.getMessage());
            throw exception;
        }
    }

    private void resolveGeneralTable(XWPFTable table, List<Map<String, Object>> data) {
        JSONObject resultMap = SpireGeneralTablePolicy.findTableSourceRow(table);
        Integer rowNum = resultMap.getInteger("rowNum");
        String tableText = resultMap.getString("tableText");
        List<String> nameList = this.getTableCellName(table, tableText);
        for (int i = data.size() - 1; i >= 0; --i) {
            List<String> copyNameList = nameList.stream().collect(Collectors.toList());
            XWPFTableRow sourceRow = table.getRow(rowNum.intValue());
            int startCell = this.findStartCell(sourceRow);
            SpireGeneralTablePolicy.copyRow(table, sourceRow, rowNum + 1, copyNameList, data.get(i), startCell);
        }
        table.removeRow(rowNum.intValue());
    }

    private int findStartCell(XWPFTableRow sourceRow) {
        for (int i = 0; i < sourceRow.getTableCells().size(); ++i) {
            if (!SpireGeneralTablePolicy.startCell(sourceRow.getCell(i).getText())) continue;
            return i;
        }
        return 0;
    }

    public static void copyRow(XWPFTable table, XWPFTableRow sourceRow, int rowIndex, List<String> nameList, Map<String, Object> valueMap, int startCell) {
        XWPFTableRow targetRow = table.insertNewTableRow(rowIndex);
        targetRow.setHeight(sourceRow.getHeight());
        List cellList = sourceRow.getTableCells();
        if (null == cellList) {
            return;
        }
        XWPFTableCell targetCell = null;
        int index = 0;
        int nameListSize = nameList.size();
        for (int cellIndex = 0; cellIndex < sourceRow.getTableCells().size(); ++cellIndex) {
            XWPFTableCell sourceCell = sourceRow.getCell(cellIndex);
            targetCell = targetRow.addNewTableCell();
            targetCell.getCTTc().setTcPr(sourceCell.getCTTc().getTcPr());
            if (cellIndex < startCell || cellIndex >= startCell + nameListSize) {
                nameList.add(index, null);
            }
            String valueString = null;
            Object value = valueMap.get(nameList.get(index));
            if (Objects.nonNull(value)) {
                valueString = String.valueOf(value);
            }
            if (sourceCell.getParagraphs() != null && sourceCell.getParagraphs().size() > 0) {
                ((XWPFParagraph)targetCell.getParagraphs().get(0)).getCTP().setPPr(((XWPFParagraph)sourceCell.getParagraphs().get(0)).getCTP().getPPr());
                if (((XWPFParagraph)sourceCell.getParagraphs().get(0)).getRuns() != null && ((XWPFParagraph)sourceCell.getParagraphs().get(0)).getRuns().size() > 0) {
                    XWPFRun cellR = ((XWPFParagraph)targetCell.getParagraphs().get(0)).createRun();
                    cellR.setBold(((XWPFRun)((XWPFParagraph)sourceCell.getParagraphs().get(0)).getRuns().get(0)).isBold());
                    cellR.getCTR().setRPr(((XWPFRun)((XWPFParagraph)sourceCell.getParagraphs().get(0)).getRuns().get(0)).getCTR().getRPr());
                }
            }
            PolicyUtil.addBreakInCellNew(targetCell, valueString, true);
            ++index;
        }
    }

    private static boolean startCell(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return false;
        }
        Pattern pattern = Pattern.compile(PDF_WORD_SUBTABLE_NAME_REG);
        Matcher matcher = pattern.matcher(text);
        return matcher.find();
    }

    private static JSONObject findTableSourceRow(XWPFTable table) {
        if (CollectionUtils.isEmpty((Collection)table.getRows())) {
            return null;
        }
        Pattern pattern = Pattern.compile(PDF_WORD_SUBTABLE_NAME_REG);
        JSONObject resultMap = new JSONObject();
        for (int i = 0; i < table.getRows().size(); ++i) {
            XWPFTableRow row = table.getRow(i);
            if (CollectionUtils.isEmpty((Collection)row.getTableCells())) continue;
            for (int j = 0; j < row.getTableCells().size(); ++j) {
                String text = row.getCell(j).getText();
                if (!StringUtils.isNotBlank((CharSequence)text) || !pattern.matcher(text).find()) continue;
                resultMap.put("rowNum", (Object)i);
                resultMap.put("tableText", (Object)text);
                return resultMap;
            }
        }
        return resultMap;
    }

    private List<String> getTableCellName(XWPFTable table, String tableText) {
        String text = table.getText();
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        int start = (text = text.substring(0, text.indexOf(tableText))).lastIndexOf("{{TABLE_");
        if (start > -1) {
            text = text.substring(start);
        }
        Pattern pattern = Pattern.compile(PDF_WORD_SUBTABLE_CELL_REG);
        Matcher matcher = pattern.matcher(text);
        ArrayList<String> cellNameList = new ArrayList<String>(10);
        while (matcher.find()) {
            cellNameList.add(matcher.group().replace(PDF_WORD_SUBTABLE_CELL_START2_REG, "").replace(PDF_WORD_SUBTABLE_CELL_END_REG, ""));
        }
        return cellNameList;
    }
}

