/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.mybatis.page;

import cn.gtmap.dysjy.mybatis.mapper.DyEntityMapper;
import cn.gtmap.dysjy.mybatis.page.dialect.DatabaseDialectShortName;
import cn.gtmap.dysjy.mybatis.page.dialect.Dialect;
import cn.gtmap.dysjy.mybatis.page.helper.DialectHelper;
import cn.gtmap.dysjy.mybatis.page.helper.SqlHelper;
import com.alibaba.fastjson.JSONObject;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.PatternMatchUtils;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class PaginationInterceptor
implements Interceptor {
    private static final int MAPPED_STATEMENT_INDEX = 0;
    private static final int PARAMETER_INDEX = 1;
    private static final int ROWBOUNDS_INDEX = 2;
    private static final String LOADTOTAL = "loadTotal";
    private static final ThreadLocal<Integer> PAGINATION_TOTAL = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private static final Logger LOGGER = LoggerFactory.getLogger(DyEntityMapper.class);
    private Dialect dialect;
    private String mappedStatementIdRegex;

    public static int getPaginationTotal() {
        return PAGINATION_TOTAL.get();
    }

    public static void setPaginationTotal(Integer total) {
        PAGINATION_TOTAL.set(total);
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] queryArgs = invocation.getArgs();
        MappedStatement ms = (MappedStatement)queryArgs[0];
        Object parameter = queryArgs[1];
        RowBounds rowBounds = (RowBounds)queryArgs[2];
        int offset = rowBounds.getOffset();
        int limit = rowBounds.getLimit();
        Map parameterMap = new HashMap();
        if (parameter != null && queryArgs[1] instanceof Map) {
            parameterMap = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)parameter), Map.class);
        }
        String modifySql = "";
        BoundSql boundSql = ms.getBoundSql(parameter);
        String initSql = boundSql.getSql().trim();
        boolean intercept = PatternMatchUtils.simpleMatch((String)this.mappedStatementIdRegex, (String)ms.getId());
        if (intercept && this.dialect.supportsLimit() && (offset != 0 || limit != Integer.MAX_VALUE)) {
            String sql = StringUtils.isNotBlank((CharSequence)modifySql) ? modifySql : initSql;
            Executor executor = (Executor)invocation.getTarget();
            HashMap map = (HashMap)JSONObject.parseObject((String)JSONObject.toJSONString((Object)parameter), HashMap.class);
            if (map == null || !map.containsKey(LOADTOTAL) || map.get(LOADTOTAL) == null || ((Boolean)map.get(LOADTOTAL)).booleanValue()) {
                Connection connection = executor.getTransaction().getConnection();
                int count = SqlHelper.getCount(sql, ms, connection, parameter, this.dialect);
                PaginationInterceptor.setPaginationTotal(count);
            } else {
                PaginationInterceptor.setPaginationTotal(-1);
            }
            if (parameterMap.get("sort") != null) {
                String orderBy = parameterMap.get("sort").toString();
                sql = "SELECT * FROM (" + initSql + ") A ORDER BY " + orderBy;
            }
            modifySql = this.dialect.getLimitString(sql, offset, limit);
        }
        if (StringUtils.isNotBlank((CharSequence)modifySql)) {
            MappedStatement newMs = this.newMappedStatement(ms, boundSql, modifySql);
            queryArgs[2] = new RowBounds(0, Integer.MAX_VALUE);
            queryArgs[0] = newMs;
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        String dialectClass = properties.getProperty("dialectClass");
        if (StringUtils.isBlank((CharSequence)dialectClass)) {
            String dialectShortName = properties.getProperty("dialect");
            this.checkDialect(dialectShortName);
            this.dialect = DialectHelper.getDialect(DatabaseDialectShortName.valueOf(dialectShortName.toUpperCase()));
        } else {
            try {
                this.dialect = (Dialect)Class.forName(dialectClass).newInstance();
            }
            catch (Exception e) {
                LOGGER.error("Plug-in [PaginationInterceptor] cannot create dialect instance by dialectClass: " + dialectClass, (Throwable)e);
                throw new ClassCastException("Plug-in [PaginationInterceptor] cannot create dialect instance by dialectClass: " + dialectClass);
            }
        }
        this.mappedStatementIdRegex = properties.getProperty("stmtIdRegex", "*.*ByPage");
    }

    private void checkDialect(String dialectShortName) {
        DatabaseDialectShortName.valueOf(dialectShortName.toUpperCase());
    }

    private MappedStatement newMappedStatement(MappedStatement ms, BoundSql boundSql, String sql) {
        BoundSql newBoundSql = this.newBoundSql(ms, boundSql, sql);
        RawSqlSource sqlSource = new RawSqlSource(newBoundSql);
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), (SqlSource)sqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        String[] keyProperties = ms.getKeyProperties();
        builder.keyProperty(keyProperties == null ? null : keyProperties[0]);
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    private BoundSql newBoundSql(MappedStatement ms, BoundSql boundSql, String sql) {
        BoundSql newBoundSql = new BoundSql(ms.getConfiguration(), sql, boundSql.getParameterMappings(), boundSql.getParameterObject());
        for (ParameterMapping mapping : boundSql.getParameterMappings()) {
            String prop = mapping.getProperty();
            if (!boundSql.hasAdditionalParameter(prop)) continue;
            newBoundSql.setAdditionalParameter(prop, boundSql.getAdditionalParameter(prop));
        }
        return newBoundSql;
    }

    public class RawSqlSource
    implements SqlSource {
        private BoundSql boundSql;

        public RawSqlSource(BoundSql boundSql) {
            this.boundSql = boundSql;
        }

        public BoundSql getBoundSql(Object parameterObject) {
            return this.boundSql;
        }
    }
}

