/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.mybatis.mapper;

import cn.gtmap.dysjy.mybatis.mapper.DyEntityMapper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.commons.beanutils.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateConvert
implements Converter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DyEntityMapper.class);

    public Object convert(Class arg0, Object arg1) {
        if (arg1 == null) {
            return null;
        }
        String p = arg1.toString();
        if (p == null || p.trim().length() == 0) {
            return null;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return df.parse(p.trim());
        }
        catch (Exception e) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                return df.parse(p.trim());
            }
            catch (ParseException ex) {
                try {
                    LocalDateTime datetime = LocalDateTime.parse(p.trim(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.S"));
                    return Date.from(datetime.atZone(ZoneId.systemDefault()).toInstant());
                }
                catch (Exception exe) {
                    try {
                        Date date = new Date();
                        date.setTime(Long.parseLong(p.trim()));
                        return date;
                    }
                    catch (Exception ee) {
                        LOGGER.error(ee.getMessage(), (Throwable)ee);
                        return null;
                    }
                }
            }
        }
    }
}

