/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class JavaCodeUtil {
    public static String codeToClass(String code, String compilePath) {
        String className = JavaCodeUtil.getClassNameFromCode(code);
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = javaCompiler.getStandardFileManager(null, null, null);
        StringObject stringObject = new StringObject(className, code);
        List<String> options = Arrays.asList("-d", compilePath);
        JavaCompiler.CompilationTask task = javaCompiler.getTask(null, fileManager, null, options, null, Collections.singletonList(stringObject));
        if (task.call().booleanValue()) {
            String packageName = JavaCodeUtil.getPackageNameInFirstLine(code);
            String classFileName = className + ".class";
            return compilePath + "/" + packageName + "/" + classFileName;
        }
        return null;
    }

    public static String javaToClass(String fileName, String compilePath) throws IOException {
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = javaCompiler.getStandardFileManager(null, null, null);
        Iterable<? extends JavaFileObject> fileObjects = fileManager.getJavaFileObjects(fileName);
        List<String> options = Arrays.asList("-d", compilePath);
        JavaCompiler.CompilationTask task = javaCompiler.getTask(null, fileManager, null, options, null, fileObjects);
        if (task.call().booleanValue()) {
            String line;
            File sourceFile = new File(fileName);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(sourceFile));
            while ((line = bufferedReader.readLine()) != null && !line.startsWith("package")) {
            }
            String packageName = line;
            packageName = packageName.replaceAll("package", "").trim().replaceAll("\\.", "/");
            packageName = packageName.substring(0, packageName.length() - 1);
            String sourceFileName = sourceFile.getName();
            String[] split = sourceFileName.split("\\.");
            String simpleClassName = split[0] + ".class";
            return compilePath + "/" + packageName + "/" + simpleClassName;
        }
        return null;
    }

    public static String getPackageNameInFirstLine(String code) {
        return code.substring(0, code.indexOf(";")).replace("package ", "").replaceAll("\\.", "/");
    }

    public static String getClassNameFromCode(String code) {
        int classBlank = code.indexOf("class ") + 6;
        String className = code.substring(classBlank);
        int nextBlank = className.indexOf(" ");
        if ((className = className.substring(0, nextBlank)).contains("{")) {
            int i = className.indexOf("{");
            className = className.substring(0, i);
        }
        return className;
    }

    public static String getProjectPath() {
        String path = JavaCodeUtil.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (System.getProperty("os.name").contains("dows")) {
            path = path.substring(1);
        }
        if (path.contains("jar")) {
            path = path.substring(0, path.lastIndexOf(".")).substring(0, path.lastIndexOf("/"));
            return path;
        }
        return path.replace("target/classes/", "");
    }

    public static class StringObject
    extends SimpleJavaFileObject {
        private final String content;

        public StringObject(String className, String contents) {
            super(URI.create(className), JavaFileObject.Kind.SOURCE);
            this.content = contents;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.content;
        }
    }
}

