/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.spirepdf;

import cn.gtmap.dysjy.common.service.rest.BdcPrintRestService;
import cn.gtmap.dysjy.common.spirepdf.SpirePdfService;
import cn.gtmap.dysjy.exceptions.DysjyException;
import cn.gtmap.pdf.model.dto.OfficeExportDTO;
import com.spire.pdf.PdfDocument;
import com.spire.pdf.PdfPageBase;
import com.spire.pdf.graphics.PdfBrush;
import com.spire.pdf.graphics.PdfBrushes;
import com.spire.pdf.graphics.PdfFontBase;
import com.spire.pdf.graphics.PdfStringFormat;
import com.spire.pdf.graphics.PdfTextAlignment;
import com.spire.pdf.graphics.PdfTilingBrush;
import com.spire.pdf.graphics.PdfTrueTypeFont;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dysjy"})
public class SpirePdfController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpirePdfController.class);
    @Value(value="${print.path:/usr/local/bdc3/print/}")
    private String path;
    @Autowired
    private SpirePdfService officePdfService;
    @Autowired
    private BdcPrintRestService bdcPrintRestService;

    /*
     * Enabled aggressive block sorting
     */
    @GetMapping(value={"/pdf/exportWithDealPdf"})
    public void exportPdf(HttpServletResponse response, @ModelAttribute OfficeExportDTO officeExportDTO, Map<String, Object> paramMap) {
        if (null == officeExportDTO) {
            throw new DysjyException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u4f20\u5165\u6253\u5370\u6709\u6548\u53c2\u6570!");
        }
        if (StringUtils.isBlank((CharSequence)officeExportDTO.getModelName())) {
            throw new DysjyException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u6307\u5b9a\u6253\u5370\u6a21\u677f!");
        }
        if (StringUtils.isBlank((CharSequence)officeExportDTO.getXmlData())) {
            throw new DysjyException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u6307\u5b9a\u6253\u5370\u6570\u636e\u6e90!");
        }
        this.resolveModelFile(officeExportDTO);
        Object pdfFileName = this.officePdfService.generatePdfFile(officeExportDTO, paramMap);
        if (!Objects.nonNull(pdfFileName)) {
            LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u5931\u8d25\uff0c\u56e0\u4e3a\u672a\u6210\u529f\u751f\u6210PDF\u6587\u4ef6\uff0c\u76ee\u6807\u6587\u4ef6\u540d\uff1a{}", (Object)officeExportDTO.getFileName());
            throw new DysjyException("\u7cfb\u7edf\u5bfc\u51faPDF\u5931\u8d25\uff0c\u56e0\u4e3a\u672a\u6210\u529f\u751f\u6210PDF\u6587\u4ef6");
        }
        if (pdfFileName instanceof String) {
            if (Base64.isBase64((String)((String)pdfFileName))) {
                this.downLoadByteFile(response, officeExportDTO, Base64.decodeBase64((String)((String)pdfFileName)));
                return;
            }
            this.downLoadStringFile(response, officeExportDTO, (String)pdfFileName);
            return;
        }
        if (pdfFileName instanceof byte[]) {
            this.downLoadByteFile(response, officeExportDTO, (byte[])pdfFileName);
            return;
        }
        if (pdfFileName instanceof File) {
            this.downLoadFile(response, officeExportDTO, (File)pdfFileName);
            return;
        }
        LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u5931\u8d25 \u8fd4\u56de\u6587\u4ef6\u7c7b\u578b\u5f02\u5e38\uff0c\u76ee\u6807\u6587\u4ef6\u540d\uff1a{}", (Object)officeExportDTO.getFileName());
        throw new DysjyException("\u7cfb\u7edf\u5bfc\u51faPDF\u5931\u8d25\uff0c\u8fd4\u56de\u6587\u4ef6\u7c7b\u578b\u5f02\u5e38");
    }

    private void downLoadFile(HttpServletResponse response, OfficeExportDTO officeExportDTO, File pdfFile) {
        ServletOutputStream outputStream = null;
        try {
            outputStream = response.getOutputStream();
            if (!pdfFile.exists() || pdfFile.length() == 0L || !pdfFile.canRead()) {
                LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u5931\u8d25\uff0c\u76ee\u6807PDF\u6587\u4ef6\u4e0d\u53ef\u64cd\u4f5c\u6216\u65e0\u5185\u5bb9\uff1a{}", (Object)pdfFile);
                throw new DysjyException("\u7cfb\u7edf\u5bfc\u51faPDF\u5931\u8d25\uff0c\u76ee\u6807PDF\u6587\u4ef6\u4e0d\u53ef\u64cd\u4f5c\u6216\u65e0\u5185\u5bb9");
            }
            String fileName = StringUtils.isBlank((CharSequence)officeExportDTO.getFileName()) ? "\u6279\u91cfPDF\u6587\u4ef6" : officeExportDTO.getFileName();
            String file = URLEncoder.encode(fileName + ".pdf", "utf-8");
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename=" + file);
            FileUtils.copyFile((File)pdfFile, (OutputStream)outputStream);
        }
        catch (Exception e) {
            LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u62a5\u9519\uff1a{}", (Object)e.toString());
            throw new DysjyException("\u7cfb\u7edf\u5bfc\u51faPDF\u62a5\u9519\uff0c\u5904\u7406\u7ec8\u6b62");
        }
        finally {
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u5173\u95ed\u8d44\u6e90\u62a5\u9519\uff1a{}", (Object)e.getMessage());
                }
            }
            if (pdfFile.exists()) {
                pdfFile.delete();
            }
        }
    }

    private void downLoadByteFile(HttpServletResponse response, OfficeExportDTO officeExportDTO, byte[] byteList) {
        ServletOutputStream outputStream = null;
        try {
            outputStream = response.getOutputStream();
            String fileName = StringUtils.isBlank((CharSequence)officeExportDTO.getFileName()) ? "\u6279\u91cfPDF\u6587\u4ef6" : officeExportDTO.getFileName();
            String file = URLEncoder.encode(fileName + ".pdf", "utf-8");
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename=" + file);
            outputStream.write(byteList);
        }
        catch (Exception e) {
            LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u62a5\u9519\uff1a{}", (Object)e.toString());
            throw new DysjyException("\u7cfb\u7edf\u5bfc\u51faPDF\u62a5\u9519\uff0c\u5904\u7406\u7ec8\u6b62");
        }
        finally {
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u5173\u95ed\u8d44\u6e90\u62a5\u9519\uff1a{}", (Object)e.getMessage());
                }
            }
        }
    }

    private void downLoadStringFile(HttpServletResponse response, OfficeExportDTO officeExportDTO, String pdfFileName) {
        ServletOutputStream outputStream = null;
        try {
            outputStream = response.getOutputStream();
            File pdfFile = new File(pdfFileName);
            if (!pdfFile.exists() || pdfFile.length() == 0L || !pdfFile.canRead()) {
                LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u5931\u8d25\uff0c\u76ee\u6807PDF\u6587\u4ef6\u4e0d\u53ef\u64cd\u4f5c\u6216\u65e0\u5185\u5bb9\uff1a{}", (Object)pdfFileName);
                throw new DysjyException("\u7cfb\u7edf\u5bfc\u51faPDF\u5931\u8d25\uff0c\u76ee\u6807PDF\u6587\u4ef6\u4e0d\u53ef\u64cd\u4f5c\u6216\u65e0\u5185\u5bb9");
            }
            String fileName = StringUtils.isBlank((CharSequence)officeExportDTO.getFileName()) ? "\u6279\u91cfPDF\u6587\u4ef6" : officeExportDTO.getFileName();
            String file = URLEncoder.encode(fileName + ".pdf", "utf-8");
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename=" + file);
            FileUtils.copyFile((File)pdfFile, (OutputStream)outputStream);
        }
        catch (Exception e) {
            LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u62a5\u9519\uff1a{}", (Object)e.toString());
            throw new DysjyException("\u7cfb\u7edf\u5bfc\u51faPDF\u62a5\u9519\uff0c\u5904\u7406\u7ec8\u6b62");
        }
        finally {
            File file;
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u5173\u95ed\u8d44\u6e90\u62a5\u9519\uff1a{}", (Object)e.getMessage());
                }
            }
            if (null != pdfFileName && (file = new File(pdfFileName)).exists()) {
                file.delete();
            }
        }
    }

    @RequestMapping(value={"/pdf/export"})
    public void exportPdf(HttpServletResponse response, @RequestParam String modelName, @RequestParam String fileName, @RequestBody Map<String, Object> paramMap) {
        OfficeExportDTO officeExportDTO = new OfficeExportDTO();
        officeExportDTO.setModelName(modelName);
        officeExportDTO.setFileName(fileName);
        String xmlData = this.bdcPrintRestService.getPrintXmlByTemplateName(modelName, paramMap);
        officeExportDTO.setXmlData(xmlData);
        officeExportDTO.setModelName(this.path + officeExportDTO.getModelName());
        this.exportPdf(response, officeExportDTO, paramMap);
    }

    @GetMapping(value={"/pdf/exportPdf"})
    public void exportPdf(HttpServletResponse response, @ModelAttribute OfficeExportDTO officeExportDTO) {
        if (null == officeExportDTO) {
            throw new DysjyException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u4f20\u5165\u6253\u5370\u6709\u6548\u53c2\u6570!");
        }
        if (StringUtils.isBlank((CharSequence)officeExportDTO.getModelName())) {
            throw new DysjyException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u6307\u5b9a\u6253\u5370\u6a21\u677f!");
        }
        if (StringUtils.isBlank((CharSequence)officeExportDTO.getXmlData())) {
            throw new DysjyException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u6307\u5b9a\u6253\u5370\u6570\u636e\u6e90!");
        }
        this.resolveModelFile(officeExportDTO);
        ServletOutputStream outputStream = null;
        String pdfFileName = null;
        try {
            outputStream = response.getOutputStream();
            pdfFileName = this.officePdfService.generatePdfFile(officeExportDTO);
            if (StringUtils.isBlank((CharSequence)pdfFileName)) {
                LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u5931\u8d25\uff0c\u56e0\u4e3a\u672a\u6210\u529f\u751f\u6210PDF\u6587\u4ef6\uff0c\u76ee\u6807\u6587\u4ef6\u540d\uff1a{}", (Object)officeExportDTO.getFileName());
                throw new DysjyException("\u7cfb\u7edf\u5bfc\u51faPDF\u5931\u8d25\uff0c\u56e0\u4e3a\u672a\u6210\u529f\u751f\u6210PDF\u6587\u4ef6");
            }
            File pdfFile = new File(pdfFileName);
            if (!pdfFile.exists() || pdfFile.length() == 0L || !pdfFile.canRead()) {
                LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u5931\u8d25\uff0c\u76ee\u6807PDF\u6587\u4ef6\u4e0d\u53ef\u64cd\u4f5c\u6216\u65e0\u5185\u5bb9\uff1a{}", (Object)pdfFileName);
                throw new DysjyException("\u7cfb\u7edf\u5bfc\u51faPDF\u5931\u8d25\uff0c\u76ee\u6807PDF\u6587\u4ef6\u4e0d\u53ef\u64cd\u4f5c\u6216\u65e0\u5185\u5bb9");
            }
            String fileName = StringUtils.isBlank((CharSequence)officeExportDTO.getFileName()) ? "\u6279\u91cfPDF\u6587\u4ef6" : officeExportDTO.getFileName();
            String file = URLEncoder.encode(fileName + ".pdf", "utf-8");
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename=" + file);
            FileUtils.copyFile((File)pdfFile, (OutputStream)outputStream);
        }
        catch (Exception e) {
            LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u62a5\u9519\uff1a{}", (Object)e.toString());
            throw new DysjyException("\u7cfb\u7edf\u5bfc\u51faPDF\u62a5\u9519\uff0c\u5904\u7406\u7ec8\u6b62");
        }
        finally {
            File file;
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u5173\u95ed\u8d44\u6e90\u62a5\u9519\uff1a{}", (Object)e.getMessage());
                }
            }
            if (null != pdfFileName && (file = new File(pdfFileName)).exists()) {
                file.delete();
            }
        }
    }

    @GetMapping(value={"/pdf/export/watermark"})
    public void exportPdfWaterMark(HttpServletResponse response, @ModelAttribute OfficeExportDTO officeExportDTO, String watermark) {
        if (null == officeExportDTO) {
            throw new DysjyException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u4f20\u5165\u6253\u5370\u6709\u6548\u53c2\u6570!");
        }
        if (StringUtils.isBlank((CharSequence)officeExportDTO.getModelName())) {
            throw new DysjyException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u6307\u5b9a\u6253\u5370\u6a21\u677f!");
        }
        if (StringUtils.isBlank((CharSequence)officeExportDTO.getXmlData())) {
            throw new DysjyException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u6307\u5b9a\u6253\u5370\u6570\u636e\u6e90!");
        }
        this.resolveModelFile(officeExportDTO);
        ServletOutputStream outputStream = null;
        String pdfFileName = null;
        try {
            outputStream = response.getOutputStream();
            pdfFileName = this.officePdfService.generatePdfFile(officeExportDTO);
            if (StringUtils.isBlank((CharSequence)pdfFileName)) {
                LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u5931\u8d25\uff0c\u56e0\u4e3a\u672a\u6210\u529f\u751f\u6210PDF\u6587\u4ef6\uff0c\u76ee\u6807\u6587\u4ef6\u540d\uff1a{}", (Object)officeExportDTO.getFileName());
                throw new DysjyException("\u7cfb\u7edf\u5bfc\u51faPDF\u5931\u8d25\uff0c\u56e0\u4e3a\u672a\u6210\u529f\u751f\u6210PDF\u6587\u4ef6");
            }
            File pdfFile = new File(pdfFileName);
            if (!pdfFile.exists() || pdfFile.length() == 0L || !pdfFile.canRead()) {
                LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u5931\u8d25\uff0c\u76ee\u6807PDF\u6587\u4ef6\u4e0d\u53ef\u64cd\u4f5c\u6216\u65e0\u5185\u5bb9\uff1a{}", (Object)pdfFileName);
                throw new DysjyException("\u7cfb\u7edf\u5bfc\u51faPDF\u5931\u8d25\uff0c\u76ee\u6807PDF\u6587\u4ef6\u4e0d\u53ef\u64cd\u4f5c\u6216\u65e0\u5185\u5bb9");
            }
            String fileName = StringUtils.isBlank((CharSequence)officeExportDTO.getFileName()) ? "\u6279\u91cfPDF\u6587\u4ef6" : officeExportDTO.getFileName();
            String file = URLEncoder.encode(fileName + ".pdf", "utf-8");
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename=" + file);
            PdfDocument pdf = new PdfDocument();
            pdf.loadFromFile(pdfFileName);
            if (pdf.getPages() != null && pdf.getPages().getCount() > 0) {
                for (int i = 0; i < pdf.getPages().getCount(); ++i) {
                    PdfPageBase page = pdf.getPages().get(i);
                    this.insertWatermark(page, watermark);
                }
            }
            pdf.saveToFile(this.path + "/temp/" + fileName + "textwatermark.pdf");
            File waterFile = new File(this.path + "/temp/" + fileName + "textwatermark.pdf");
            FileUtils.copyFile((File)waterFile, (OutputStream)outputStream);
        }
        catch (Exception e) {
            LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u62a5\u9519\uff1a{}", (Object)e.toString());
            throw new DysjyException("\u7cfb\u7edf\u5bfc\u51faPDF\u62a5\u9519\uff0c\u5904\u7406\u7ec8\u6b62");
        }
        finally {
            File file;
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u5173\u95ed\u8d44\u6e90\u62a5\u9519\uff1a{}", (Object)e.getMessage());
                }
            }
            if (null != pdfFileName && (file = new File(pdfFileName)).exists()) {
                file.delete();
            }
        }
    }

    private void insertWatermark(PdfPageBase page, String watermark) {
        Dimension dimension2D = new Dimension();
        PdfTrueTypeFont font1 = new PdfTrueTypeFont(new Font("Arial Unicode MS", 0, 14), true);
        ((Dimension2D)dimension2D).setSize(page.getCanvas().getClientSize().getWidth() / 5.0, page.getCanvas().getClientSize().getHeight() / 5.0);
        PdfTilingBrush brush = new PdfTilingBrush((Dimension2D)dimension2D);
        brush.getGraphics().setTransparency(0.4f);
        brush.getGraphics().save();
        brush.getGraphics().translateTransform((double)((float)brush.getSize().getWidth() / 4.0f), (double)((float)brush.getSize().getHeight() / 5.0f));
        brush.getGraphics().rotateTransform(-45.0f);
        brush.getGraphics().drawString(watermark, (PdfFontBase)font1, PdfBrushes.getViolet(), 0.0f, 0.0f, new PdfStringFormat(PdfTextAlignment.Center));
        brush.getGraphics().restore();
        brush.getGraphics().setTransparency(1.0f);
        Rectangle2D.Float loRect = new Rectangle2D.Float();
        loRect.setFrame(new Point2D.Float(0.0f, 0.0f), page.getCanvas().getClientSize());
        page.getCanvas().drawRectangle((PdfBrush)brush, (Rectangle2D)loRect);
    }

    @PostMapping(value={"/pdf/file"})
    public String generatePdfFile(@RequestBody OfficeExportDTO officeExportDTO) {
        if (null == officeExportDTO) {
            throw new DysjyException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u4f20\u5165\u6253\u5370\u6709\u6548\u53c2\u6570!");
        }
        if (StringUtils.isBlank((CharSequence)officeExportDTO.getModelName())) {
            throw new DysjyException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u6307\u5b9a\u6253\u5370\u6a21\u677f!");
        }
        if (StringUtils.isBlank((CharSequence)officeExportDTO.getXmlData())) {
            throw new DysjyException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u6307\u5b9a\u6253\u5370\u6570\u636e\u6e90!");
        }
        this.resolveModelFile(officeExportDTO);
        return this.officePdfService.generatePdfFile(officeExportDTO);
    }

    private void resolveModelFile(OfficeExportDTO officeExportDTO) {
        String filePath = officeExportDTO.getModelName();
        if (!SpirePdfController.isHttpUrl(filePath)) {
            File diskFile = new File(filePath);
            if (!diskFile.exists()) {
                LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u5931\u8d25\uff0c\u56e0\u4e3a\u672a\u627e\u5230\u672c\u5730\u6a21\u677f\u6587\u4ef6\uff1a{}", (Object)officeExportDTO.getModelName());
                throw new DysjyException("\u7cfb\u7edf\u5bfc\u51faPDF\u62a5\u9519\uff0c\u5904\u7406\u7ec8\u6b62");
            }
        } else {
            String[] urlArr = filePath.split("/");
            if (null == urlArr) {
                LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u5931\u8d25\uff0c\u56e0\u4e3a\u672a\u627e\u5230\u672c\u5730\u6a21\u677f\u6587\u4ef6\uff1a{}", (Object)officeExportDTO.getModelName());
                throw new DysjyException("\u7cfb\u7edf\u5bfc\u51faPDF\u62a5\u9519\uff0c\u5904\u7406\u7ec8\u6b62");
            }
            String urlFileName = urlArr[urlArr.length - 1] + ".docx";
            File diskFile = new File(this.path + urlFileName);
            if (!diskFile.exists()) {
                try {
                    FileUtils.copyURLToFile((URL)new URIBuilder(filePath).build().toURL(), (File)diskFile, (int)5000, (int)30000);
                }
                catch (Exception e) {
                    LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u5931\u8d25\uff0c\u56e0\u4e3a\u6a21\u677f\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff1a{}, {}", (Object)officeExportDTO.getModelName(), (Object)e.getMessage());
                    throw new DysjyException("\u7cfb\u7edf\u5bfc\u51faPDF\u62a5\u9519\uff0c\u5904\u7406\u7ec8\u6b62");
                }
            }
            officeExportDTO.setModelName(diskFile.getAbsolutePath());
        }
    }

    private static boolean isHttpUrl(String urls) {
        String regex = "[a-zA-z]+://[^\\s]*";
        Pattern pat = Pattern.compile(regex.trim());
        Matcher mat = pat.matcher(urls.trim());
        return mat.matches();
    }
}

