/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.spirepdf;

import cn.gtmap.dysjy.exceptions.DysjyException;
import com.deepoove.poi.NiceXWPFDocument;
import com.deepoove.poi.policy.DynamicTableRenderPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.TextAlignment;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpireOfficeInCellTablePolicy
extends DynamicTableRenderPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpireOfficeInCellTablePolicy.class);
    private static final String PDF_WORD_INCELL_TABLE_NAME_REG = "\\{\\{TABLE_NQ_[A-Za-z0-9_]+\\}\\}";
    private static final String PDF_WORD_SUBTABLE_CELL_START3_REG = "{{";
    private static final String PDF_WORD_SUBTABLE_CELL_END_REG = "}}";
    private Map<String, Object> officeData;

    public SpireOfficeInCellTablePolicy() {
    }

    public SpireOfficeInCellTablePolicy(Map<String, Object> data) {
        this.officeData = data;
    }

    public void render(XWPFTable table, Object data) {
        if (null == table || null == data) {
            LOGGER.error("PDF\u3001WORD\u5904\u7406\u6570\u636e\u8868\u683c\u4e2d\u6b62\uff0c\u539f\u56e0\uff1a\u6ca1\u6709\u5b9a\u4e49\u6570\u636e\u8868\u683c\u6216\u8005\u65e0\u5bf9\u5e94\u6570\u636e\uff01");
            return;
        }
        if (CollectionUtils.isEmpty((Collection)table.getRows())) {
            LOGGER.error("PDF\u3001WORD\u5904\u7406\u6570\u636e\u8868\u683c\u4e2d\u6b62\uff0c\u539f\u56e0\uff1a\u8868\u683c\u65e0\u6570\u636e\u884c\u5185\u5bb9\uff01");
            return;
        }
        List tableData = (List)data;
        String tableName = this.getTableName(table);
        if (null == tableName) {
            LOGGER.error("PDF\u3001WORD\u5904\u7406\u6570\u636e\u8868\u683c\u4e2d\u6b62\uff0c\u539f\u56e0\uff1a\u5355\u5143\u683c\u5185\u5d4c\u8868\u89e3\u6790\u9519\u8bef");
            return;
        }
        String[] tempArr = tableName.split("_");
        int cellLocationRow = Integer.parseInt(tempArr[tempArr.length - 2]);
        int cellLocationCol = Integer.parseInt(tempArr[tempArr.length - 1]);
        List rows = table.getRows();
        XWPFTableCell cell = ((XWPFTableRow)rows.get(cellLocationRow)).getCell(cellLocationCol);
        List paragraphs = cell.getParagraphs();
        if (CollectionUtils.isNotEmpty((Collection)paragraphs)) {
            Iterator it = paragraphs.iterator();
            int pos = paragraphs.size() - 1;
            while (it.hasNext()) {
                cell.removeParagraph(pos--);
            }
        }
        XWPFParagraph paragraph = cell.addParagraph();
        XWPFRun run = paragraph.createRun();
        if (CollectionUtils.isEmpty((Collection)tableData)) {
            paragraph.setAlignment(ParagraphAlignment.CENTER);
            run.setText("");
            return;
        }
        String[][] fieldNameArray = this.getFieldNameArray(tableData);
        int colNum = fieldNameArray.length;
        int rowNum = tableData.size();
        XWPFTable inCellTable = ((NiceXWPFDocument)cell.getXWPFDocument()).insertNewTable(run, rowNum, colNum);
        inCellTable.setLeftBorder(XWPFTable.XWPFBorderType.SINGLE, 2, 0, "000000");
        inCellTable.setRightBorder(XWPFTable.XWPFBorderType.SINGLE, 2, 0, "000000");
        inCellTable.setTopBorder(XWPFTable.XWPFBorderType.SINGLE, 2, 0, "000000");
        inCellTable.setBottomBorder(XWPFTable.XWPFBorderType.SINGLE, 2, 0, "000000");
        inCellTable.setInsideHBorder(XWPFTable.XWPFBorderType.SINGLE, 2, 0, "000000");
        inCellTable.setInsideVBorder(XWPFTable.XWPFBorderType.SINGLE, 2, 0, "000000");
        for (int r = 0; r < rowNum; ++r) {
            for (int c = 0; c < colNum; ++c) {
                XWPFParagraph p1 = inCellTable.getRow(r).getCell(c).addParagraph();
                p1.setAlignment(ParagraphAlignment.CENTER);
                p1.setVerticalAlignment(TextAlignment.CENTER);
                XWPFRun r1 = p1.createRun();
                if (r == 0) {
                    r1.setText(fieldNameArray[c][2]);
                } else {
                    r1.setText((String)((Map)tableData.get(r)).get(fieldNameArray[c][1]));
                }
                r1.setFontSize(10);
            }
        }
        List newParagraphs = cell.getParagraphs();
        if (CollectionUtils.isNotEmpty((Collection)newParagraphs)) {
            cell.removeParagraph(newParagraphs.size() - 1);
        }
    }

    private String[][] getFieldNameArray(List<Map<String, Object>> tableData) {
        Map<String, Object> fieldNameMap = tableData.get(0);
        String[][] fieldNameArray = new String[fieldNameMap.size()][3];
        for (Map.Entry<String, Object> entry : fieldNameMap.entrySet()) {
            String[] field = entry.getKey().split("_");
            if (field.length != 2) {
                LOGGER.error("\u89e3\u6790\u5185\u5d4c\u8868\u683c\u5b57\u6bb5\u540d\u5931\u8d25\uff0c\u539f\u56e0\uff1axml\u5b57\u6bb5\u540d\u914d\u7f6e\u9519\u8bef");
                throw new DysjyException("xml\u5355\u5143\u683c\u5d4c\u5957\u5b50\u8868\u5b57\u6bb5\u540d\u79f0\u914d\u7f6e\u9519\u8bef\uff0c\u89e3\u6790\u5931\u8d25");
            }
            int sequence = Integer.parseInt(field[0]);
            if (sequence < 0 || sequence >= fieldNameMap.size()) {
                LOGGER.error("\u89e3\u6790\u5185\u5d4c\u8868\u683c\u5b57\u6bb5\u540d\u5931\u8d25\uff0c\u539f\u56e0\uff1axml\u5b57\u6bb5\u540d\u914d\u7f6e\u9519\u8bef");
                throw new DysjyException("xml\u5355\u5143\u683c\u5d4c\u5957\u5b50\u8868\u5b57\u6bb5\u540d\u79f0\u914d\u7f6e\u9519\u8bef\uff0c\u89e3\u6790\u5931\u8d25");
            }
            fieldNameArray[sequence][0] = field[0];
            fieldNameArray[sequence][1] = field[1];
            fieldNameArray[sequence][2] = (String)entry.getValue();
        }
        return fieldNameArray;
    }

    private String getTableName(XWPFTable table) {
        ArrayList<String> tableNameList = new ArrayList<String>();
        String text = table.getText();
        Pattern pattern = Pattern.compile(PDF_WORD_INCELL_TABLE_NAME_REG);
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            String t = matcher.group();
            tableNameList.add(t.replace(PDF_WORD_SUBTABLE_CELL_START3_REG, "").replace(PDF_WORD_SUBTABLE_CELL_END_REG, ""));
        }
        for (String tableName : tableNameList) {
            String[] tempArr = tableName.split("_");
            int cellLocationRow = Integer.parseInt(tempArr[tempArr.length - 2]);
            int cellLocationCol = Integer.parseInt(tempArr[tempArr.length - 1]);
            XWPFTableCell cell = ((XWPFTableRow)table.getRows().get(cellLocationRow)).getCell(cellLocationCol);
            if (cell.getParagraphs().size() <= 0) continue;
            return tableName;
        }
        return null;
    }
}

