/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.service.impl;

import cn.gtmap.dysjy.common.enums.DbSourceEnum;
import cn.gtmap.dysjy.common.mapper.BdcRegisterConfigMapper;
import cn.gtmap.dysjy.common.service.BdcDyConfigService;
import cn.gtmap.dysjy.common.service.BdcDyDataService;
import cn.gtmap.dysjy.exceptions.DysjyException;
import cn.gtmap.dysjy.exceptions.MissingArgumentException;
import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bdcDyConfigServiceImpl")
public class BdcDyConfigServiceImpl
implements BdcDyConfigService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BdcDyConfigServiceImpl.class);
    @Autowired
    private BdcRegisterConfigMapper bdcRegisterConfigMapper;
    @Autowired(required=false)
    private List<BdcDyDataService> bdcDyDataServiceList;

    @Override
    public List<Map> executeConfigSql(Map configParam, String dbsource) {
        if (StringUtils.isBlank((CharSequence)dbsource)) {
            throw new MissingArgumentException("\u7f3a\u5931\u6570\u636e\u5e93\u914d\u7f6e\u4fe1\u606f\uff01");
        }
        if (DbSourceEnum.LOCAL.getName().equals(dbsource)) {
            return this.bdcRegisterConfigMapper.executeConfigSql(configParam);
        }
        if (CollectionUtils.isEmpty(this.bdcDyDataServiceList)) {
            throw new DysjyException("\u975e\u672c\u5730\u6570\u636e\u5e93\u9700\u5b9e\u73b0 BdcDyDataService \u63a5\u53e3\u83b7\u53d6\u6570\u636e\u903b\u8f91");
        }
        for (BdcDyDataService bdcDyDataService : this.bdcDyDataServiceList) {
            List<Map> resultMap = bdcDyDataService.executeDBSourceConfigSql(configParam, dbsource);
            if (!CollectionUtils.isNotEmpty(resultMap)) continue;
            LOGGER.debug("\u7528\u6237SQL\u8fd4\u56de\u6570\u636e: " + JSON.toJSONString(resultMap));
            return resultMap;
        }
        throw new DysjyException("\u8bf7\u7ee7\u627f\u63a5\u53e3 BdcDyDataService \u5b9e\u73b0\u67e5\u8be2\u6570\u636e\u903b\u8f91");
    }
}

