/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.annotations;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.server.ConfigurableWebServerFactory;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;

@Configuration
@ComponentScan(basePackages={"cn.gtmap.dysjy.web", "cn.gtmap.pdf", "cn.gtmap.dysjy.common.spirepdf"})
@EnableFeignClients(basePackages={"cn.gtmap.dysjy.common.service.feign"})
public class DysjyWebConfig {
    @Bean
    @ConditionalOnMissingBean(value={WebServerFactoryCustomizer.class})
    public WebServerFactoryCustomizer<ConfigurableWebServerFactory> webServerFactoryCustomizer() {
        return new WebServerFactoryCustomizer<ConfigurableWebServerFactory>(){

            public void customize(ConfigurableWebServerFactory factory) {
                ErrorPage error404Page = new ErrorPage(HttpStatus.NOT_FOUND, "/gtMap/index.html");
                factory.addErrorPages(new ErrorPage[]{error404Page});
            }
        };
    }
}

