/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.utils.qrcode;

import cn.gtmap.dysjy.common.utils.qrcode.FileUtil;
import cn.gtmap.dysjy.common.utils.qrcode.MatrixToImageUtil;
import cn.gtmap.dysjy.common.utils.qrcode.QrCodeConfig;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrCodeGenWrapper {
    private static final Logger logger = LoggerFactory.getLogger(QrCodeGenWrapper.class);
    private static final int QUIET_ZONE_SIZE = 4;

    public static QrCodeConfig.QrCodeConfigBuilder createQrCodeConfig() {
        return new QrCodeConfig.QrCodeConfigBuilder();
    }

    public static BufferedImage asBufferedImage(QrCodeConfig qrCodeConfig) throws WriterException, IOException {
        BitMatrix bitMatrix = QrCodeGenWrapper.encode(qrCodeConfig);
        return MatrixToImageUtil.toBufferedImage(qrCodeConfig, bitMatrix);
    }

    public static boolean asFile(QrCodeConfig qrCodeConfig, String absFileName) throws WriterException, IOException {
        File file = FileUtil.createFile(absFileName);
        if (file == null) {
            throw new IllegalArgumentException("file not exists! absFile: " + absFileName);
        }
        BufferedImage bufferedImage = QrCodeGenWrapper.asBufferedImage(qrCodeConfig);
        if (!ImageIO.write((RenderedImage)bufferedImage, qrCodeConfig.getPicType(), file)) {
            throw new IOException("save qrcode image error!");
        }
        return true;
    }

    private static BitMatrix encode(QrCodeConfig qrCodeConfig) throws WriterException {
        ErrorCorrectionLevel errorCorrectionLevel = ErrorCorrectionLevel.L;
        int quietZone = 1;
        if (qrCodeConfig.getHints() != null) {
            if (qrCodeConfig.getHints().containsKey(EncodeHintType.ERROR_CORRECTION)) {
                errorCorrectionLevel = ErrorCorrectionLevel.valueOf((String)qrCodeConfig.getHints().get(EncodeHintType.ERROR_CORRECTION).toString());
            }
            if (qrCodeConfig.getHints().containsKey(EncodeHintType.MARGIN)) {
                quietZone = Integer.parseInt(qrCodeConfig.getHints().get(EncodeHintType.MARGIN).toString());
            }
            if (quietZone > 4) {
                quietZone = 4;
            } else if (quietZone < 0) {
                quietZone = 0;
            }
        }
        QRCode code = Encoder.encode((String)qrCodeConfig.getMsg(), (ErrorCorrectionLevel)errorCorrectionLevel, qrCodeConfig.getHints());
        return QrCodeGenWrapper.renderResult(code, qrCodeConfig.getW(), qrCodeConfig.getH(), quietZone);
    }

    private static BitMatrix renderResult(QRCode code, int width, int height, int quietZone) {
        ByteMatrix input = code.getMatrix();
        if (input == null) {
            throw new IllegalStateException();
        }
        int inputWidth = input.getWidth();
        int inputHeight = input.getHeight();
        int qrWidth = inputWidth + quietZone * 2;
        int qrHeight = inputHeight + quietZone * 2;
        int minSize = Math.min(width, height);
        int scale = QrCodeGenWrapper.calculateScale(qrWidth, minSize);
        if (scale > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("qrCode scale enable! scale: {}, qrSize:{}, expectSize:{}x{}", new Object[]{scale, qrWidth, width, height});
            }
            int padding = (minSize - qrWidth * scale) / 4 * quietZone;
            int tmpValue = qrWidth * scale + padding;
            if (width == height) {
                width = tmpValue;
                height = tmpValue;
            } else if (width > height) {
                width = width * tmpValue / height;
                height = tmpValue;
            } else {
                height = height * tmpValue / width;
                width = tmpValue;
            }
        }
        int outputWidth = Math.max(width, qrWidth);
        int outputHeight = Math.max(height, qrHeight);
        int multiple = Math.min(outputWidth / qrWidth, outputHeight / qrHeight);
        int leftPadding = (outputWidth - inputWidth * multiple) / 2;
        int topPadding = (outputHeight - inputHeight * multiple) / 2;
        BitMatrix output = new BitMatrix(outputWidth, outputHeight);
        int inputY = 0;
        int outputY = topPadding;
        while (inputY < inputHeight) {
            int inputX = 0;
            int outputX = leftPadding;
            while (inputX < inputWidth) {
                if (input.get(inputX, inputY) == 1) {
                    output.setRegion(outputX, outputY, multiple, multiple);
                }
                ++inputX;
                outputX += multiple;
            }
            ++inputY;
            outputY += multiple;
        }
        return output;
    }

    private static int calculateScale(int qrCodeSize, int expectSize) {
        if (qrCodeSize >= expectSize) {
            return 0;
        }
        int scale = expectSize / qrCodeSize;
        int abs = expectSize - scale * qrCodeSize;
        if ((double)abs < (double)expectSize * 0.15) {
            return 0;
        }
        return scale;
    }
}

