/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.spirepdf.impl;

import cn.gtmap.dysjy.common.domain.BdcDysjPzDO;
import cn.gtmap.dysjy.common.service.PdfDealService;
import cn.gtmap.dysjy.common.service.rest.BdcDysjPzRestService;
import cn.gtmap.dysjy.common.spirepdf.SpireDataService;
import cn.gtmap.dysjy.common.spirepdf.SpireDocService;
import cn.gtmap.dysjy.common.spirepdf.SpirePdfService;
import cn.gtmap.dysjy.common.spirepdf.SpirePdfTask;
import cn.gtmap.dysjy.exceptions.DysjyException;
import cn.gtmap.pdf.model.dto.OfficeExportDTO;
import cn.gtmap.pdf.service.TemplateClientDealService;
import cn.gtmap.pdf.utils.OfficeUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.docx4j.fonts.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SpirePdfServiceImpl
implements SpirePdfService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpirePdfServiceImpl.class);
    @Value(value="${print.path:/usr/local/bdc3/print/}")
    private String printPath;
    private Mapper fontMapper;
    @Autowired
    private SpireDocService spireDocService;
    @Autowired
    private SpireDataService spireDataService;
    @Autowired(required=false)
    private TemplateClientDealService templateSpecialDealService;
    @Autowired(required=false)
    private PdfDealService pdfDealService;
    @Autowired
    private BdcDysjPzRestService bdcDysjPzRestService;
    private ExecutorService executor = new ThreadPoolExecutor(4, 6, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(200), new ThreadPoolExecutor.CallerRunsPolicy());

    private BdcDysjPzDO getBdcDysjPzDO(OfficeExportDTO officeExportDTO) {
        String tempName = officeExportDTO.getModelName().replaceAll(this.printPath, "");
        return this.bdcDysjPzRestService.getZbpzByMcmc(tempName);
    }

    @Override
    public String generatePdfFile(OfficeExportDTO officeExportDTO) {
        try {
            List<Map<String, Object>> dataList = this.spireDataService.getValDataList(officeExportDTO.getXmlData());
            if (CollectionUtils.isEmpty(dataList)) {
                return null;
            }
            int dataSize = dataList.size();
            LOGGER.debug("\u5bfc\u51faPDF\u6587\u6863\uff1a{}\uff0c\u5171{}\u9875", (Object)officeExportDTO.getFileName(), (Object)dataSize);
            BlockingQueue<Runnable> queue = ((ThreadPoolExecutor)this.executor).getQueue();
            ArrayList<Future<String>> tasksList = new ArrayList<Future<String>>(dataSize);
            for (int index = 0; index < dataSize; ++index) {
                int freeCount = queue.remainingCapacity();
                if (freeCount <= 10) {
                    LOGGER.debug("\u5bfc\u51faPDF\u7ebf\u7a0b\u6c60\u961f\u5217\u5269\u4f59\u7a7a\u95f4\u8f83\u5c11\uff0c\u5f00\u59cb\u7b49\u5f85\u63d0\u4ea4\u4efb\u52a1\uff0c\u6587\u4ef6\u540d\uff1a{}", (Object)officeExportDTO.getFileName());
                    long start = System.currentTimeMillis();
                    do {
                        Thread.sleep(500L);
                    } while (queue.remainingCapacity() <= 10 || System.currentTimeMillis() - start < 5000L);
                }
                LOGGER.debug("\u5bfc\u51faPDF\u5904\u7406\u7b2c{}\u4e2a\u5b50\u4efb\u52a1\u63d0\u4ea4", (Object)(index + 1));
                SpirePdfTask pdfTask = new SpirePdfTask(this.spireDocService, dataList.get(index), index, officeExportDTO.getModelName(), this.printPath, this.fontMapper, this.templateSpecialDealService, this.getBdcDysjPzDO(officeExportDTO));
                tasksList.add(this.executor.submit(pdfTask));
            }
            LOGGER.debug("PDF\u5bfc\u51fa\u4e2d\u95f4\u4e34\u65f6\u6587\u4ef6\u5904\u7406\u5b8c\u6bd5\uff0c\u5f00\u59cb\u5408\u5e76\u6587\u4ef6:{}\uff01", (Object)officeExportDTO.getFileName());
            HashMap<String, String> pdfFileInfoMap = new HashMap<String, String>(tasksList.size());
            for (int index = 0; index < tasksList.size(); ++index) {
                pdfFileInfoMap.put(String.valueOf(index), (String)((Future)tasksList.get(index)).get());
            }
            return this.mergePdfFiles(pdfFileInfoMap, officeExportDTO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DysjyException("\u751f\u6210\u7684\u4e34\u65f6PDF\u6587\u4ef6\u62a5\u9519\uff0c\u5904\u7406\u7ec8\u6b62, \u5f02\u5e38\u539f\u56e0\uff1a" + e.toString());
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String mergePdfFiles(Map<String, String> pdfFiles, OfficeExportDTO officeExportDTO) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Object generatePdfFile(OfficeExportDTO officeExportDTO, Map<String, Object> paramMap) {
        String pdfFileName = this.generatePdfFile(officeExportDTO);
        if (Objects.nonNull(this.pdfDealService)) {
            try {
                Object result = this.pdfDealService.dealPdf(officeExportDTO.getModelName(), pdfFileName, paramMap);
                if (Objects.nonNull(result)) {
                    File wordFile;
                    String newPdfFileName;
                    if (result instanceof String && !StringUtils.equals((CharSequence)pdfFileName, (CharSequence)(newPdfFileName = (String)result)) && (wordFile = new File(pdfFileName)).exists()) {
                        wordFile.delete();
                    }
                    return result;
                }
            }
            catch (Exception e) {
                LOGGER.error("pdfDealService \u5904\u7406PDF\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            }
        }
        return pdfFileName;
    }

    @PostConstruct
    public void init() {
        this.fontMapper = OfficeUtils.getFontMapper((String)this.printPath);
    }
}

