/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.web.controller;

import cn.gtmap.dysjy.common.domain.BdcDysjPzDO;
import cn.gtmap.dysjy.common.domain.BdcDysjZbPzDO;
import cn.gtmap.dysjy.common.dto.BdcDysjPzDTO;
import cn.gtmap.dysjy.common.dto.BdcZsmbpzFileDTO;
import cn.gtmap.dysjy.common.qo.BdcDysjPzDateQO;
import cn.gtmap.dysjy.common.service.rest.BdcDysjPzRestService;
import cn.gtmap.dysjy.common.service.rest.BdcPrintRestService;
import cn.gtmap.dysjy.common.spirepdf.SpirePdfController;
import cn.gtmap.dysjy.common.utils.Base64Util;
import cn.gtmap.dysjy.common.utils.DateUtils;
import cn.gtmap.dysjy.common.utils.StringToolUtils;
import cn.gtmap.dysjy.exceptions.DysjyException;
import cn.gtmap.dysjy.exceptions.MissingArgumentException;
import cn.gtmap.pdf.PdfController;
import cn.gtmap.pdf.model.dto.OfficeExportDTO;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/rest/v1.0/dysjpz"})
@Api(tags={"\u6253\u5370\u6570\u636e\u6e90"})
public class DysjyController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DysjyController.class);
    public static final int LAYUI_SUCCESS_CODE = 0;
    @Value(value="${print.path:/usr/local/bdc3/print/}")
    private String printPath;
    @Value(value="${dysjy.db.source:}")
    private String dbSourceList;
    @Value(value="${dysjy.doc4j.mbname:}")
    private String doc4jPdfMbName;
    @Autowired
    private BdcPrintRestService bdcPrintRestService;
    @Autowired
    private BdcDysjPzRestService bdcDysjPzRestService;
    @Autowired
    private PdfController pdfController;
    @Autowired
    private SpirePdfController spirePdfController;

    @GetMapping(value={"print/model/path"})
    public String getPrintPath() {
        return this.printPath;
    }

    @PostMapping(value={"/pzxx/jgjy"})
    public Object jypzxx(@RequestBody String params) {
        return this.bdcPrintRestService.jypzxx(params);
    }

    @RequestMapping(value={"/dysj/page"})
    public Object listBdcDysjPz(@RequestParam int page, @RequestParam int size, BdcDysjPzDateQO bdcDysjPzDateQO) {
        PageRequest pageRequest = new PageRequest(page - 1, size, null);
        Page<BdcDysjPzDO> bdcDysjPzDOPage = this.bdcDysjPzRestService.listBdcDysjPz((Pageable)pageRequest, JSON.toJSONString((Object)bdcDysjPzDateQO));
        if (bdcDysjPzDOPage.hasContent()) {
            for (BdcDysjPzDO bdcDysjPzDO : bdcDysjPzDOPage.getContent()) {
                if (!StringUtils.isNotBlank((CharSequence)bdcDysjPzDO.getDysjy())) continue;
                bdcDysjPzDO.setDysjy(Base64Util.encodeByteToBase64Str(StringToolUtils.replaceBracket(bdcDysjPzDO.getDysjy()).getBytes()));
            }
        }
        return this.addLayUiCode(bdcDysjPzDOPage);
    }

    public Object addLayUiCode(Page page) {
        HashMap<String, Object> map = null;
        if (page != null) {
            map = (HashMap<String, Object>)JSONObject.parseObject((String)JSONObject.toJSONString((Object)page), Map.class);
            if (map != null) {
                map.put("msg", "\u6210\u529f");
            }
            if (map == null) {
                map = new HashMap<String, Object>(1);
                map.put("msg", "\u65e0\u6570\u636e");
            }
            map.put("code", 0);
        }
        return map;
    }

    @PostMapping(value={"/pzxx/xml"})
    public String sendXmlToRedis(@RequestBody String xml) {
        return this.bdcDysjPzRestService.sendXmlToRedis(xml);
    }

    @GetMapping(value={"/pdf/{redisKey}"})
    public void getPdfViewData(HttpServletResponse response, @PathVariable(value="redisKey") String redisKey) {
        if (StringUtils.isBlank((CharSequence)redisKey)) {
            throw new DysjyException("PDF\u6253\u5370\u9884\u89c8\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u83b7\u53d6\u5230\u53c2\u6570\u4fe1\u606f\uff01");
        }
        String data = this.getXmlFromRedis(redisKey);
        if (StringUtils.isBlank((CharSequence)data)) {
            throw new DysjyException("PDF\u6253\u5370\u9884\u89c8\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u83b7\u53d6\u5230\u53c2\u6570\u4fe1\u606f\uff01");
        }
        Map dataMap = (Map)JSON.parseObject((String)data, Map.class);
        String xmlData = this.getPrintData(dataMap);
        if (StringUtils.isBlank((CharSequence)xmlData)) {
            throw new MissingArgumentException("\u8bc1\u660e\u5355\u5bfc\u51fapdf\u4e2d\u6b62\uff0c\u539f\u56e0\uff1a\u672a\u83b7\u53d6\u5230\u6570\u636e\u4fe1\u606f\uff01");
        }
        OfficeExportDTO pdfExportDTO = new OfficeExportDTO();
        pdfExportDTO.setModelName(this.printPath + (String)dataMap.get("pdfpath"));
        pdfExportDTO.setFileName((String)dataMap.get("dylx"));
        pdfExportDTO.setXmlData(xmlData);
        if (StringUtils.isNotBlank((CharSequence)this.doc4jPdfMbName) && Arrays.asList(this.doc4jPdfMbName.split(",")).contains(dataMap.get("pdfpath"))) {
            this.pdfController.exportPdf(response, pdfExportDTO);
        } else {
            this.spirePdfController.exportPdf(response, pdfExportDTO, this.paramMap(dataMap));
        }
    }

    private Map<String, Object> paramMap(Map<String, String> dataMap) {
        String paramsStr = JSON.toJSONString((Object)dataMap.get("params"));
        List<Map> paramMapList = new ArrayList(1);
        if (JSON.isValidObject((String)paramsStr)) {
            Map paramsMap = (Map)JSON.parseObject((String)paramsStr, Map.class);
            paramMapList.add(paramsMap);
        } else {
            paramMapList = JSON.parseArray((String)paramsStr, Map.class);
        }
        Map<String, Object> paramMap = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(paramMapList)) {
            paramMap = (Map)paramMapList.get(0);
        }
        return paramMap;
    }

    @GetMapping(value={"/print/xml/{redisKey}"})
    public String getXmlFromRedis(@PathVariable(value="redisKey") String redisKey) {
        return this.bdcDysjPzRestService.getXmlFromRedis(redisKey);
    }

    private String getPrintData(Map<String, String> dataMap) {
        HashMap<String, List<Map>> params = new HashMap<String, List<Map>>(1);
        String paramsStr = JSON.toJSONString((Object)dataMap.get("params"));
        List<Map> paramMapList = new ArrayList(1);
        if (JSON.isValidObject((String)paramsStr)) {
            Map paramsMap = (Map)JSON.parseObject((String)paramsStr, Map.class);
            paramMapList.add(paramsMap);
        } else {
            paramMapList = JSON.parseArray((String)paramsStr, Map.class);
        }
        params.put(dataMap.get("dylx"), paramMapList);
        return this.bdcPrintRestService.print(params);
    }

    @PostMapping(value={"/pzxx"})
    public BdcDysjPzDTO saveOrUpdate(@RequestBody BdcDysjPzDTO bdcDysjPzDTO) {
        BdcDysjPzDTO bdcDysjPzDTO1 = this.bdcDysjPzRestService.saveOrUpdatePzxx(bdcDysjPzDTO);
        if (StringUtils.isNotBlank((CharSequence)bdcDysjPzDTO1.getDysjy())) {
            bdcDysjPzDTO1.setDysjy(Base64Util.encodeByteToBase64Str(bdcDysjPzDTO1.getDysjy().getBytes()));
        }
        for (BdcDysjZbPzDO bdcDysjZbPzDO1 : bdcDysjPzDTO1.getBdcDysjZbPzDOList()) {
            bdcDysjZbPzDO1.setDyzbsjy(Base64Util.encodeByteToBase64Str(bdcDysjZbPzDO1.getDyzbsjy().getBytes()));
        }
        return bdcDysjPzDTO1;
    }

    @GetMapping(value={"/pzxx/{dylx}"})
    public BdcDysjPzDTO getPzxx(@PathVariable(value="dylx") String dylx) {
        if (StringUtils.isBlank((CharSequence)dylx)) {
            throw new MissingArgumentException("\u7f3a\u5931\u67e5\u8be2\u53c2\u6570\uff1a\u6253\u5370\u7c7b\u578b\uff08dylx\uff09\uff01");
        }
        BdcDysjPzDTO bdcDysjPzDTO = this.bdcDysjPzRestService.getPzxx(dylx);
        if (StringUtils.isNotBlank((CharSequence)bdcDysjPzDTO.getDysjy())) {
            bdcDysjPzDTO.setDysjy(StringToolUtils.replaceBracket(Base64Util.encodeByteToBase64Str(bdcDysjPzDTO.getDysjy().getBytes())));
        }
        if (CollectionUtils.isNotEmpty(bdcDysjPzDTO.getBdcDysjZbPzDOList())) {
            for (BdcDysjZbPzDO bdcDysjZbPzDO : bdcDysjPzDTO.getBdcDysjZbPzDOList()) {
                if (!StringUtils.isNotBlank((CharSequence)bdcDysjZbPzDO.getDyzbsjy())) continue;
                bdcDysjZbPzDO.setDyzbsjy(StringToolUtils.replaceBracket(Base64Util.encodeByteToBase64Str(bdcDysjZbPzDO.getDyzbsjy().getBytes())));
            }
        }
        return bdcDysjPzDTO;
    }

    @PostMapping(value={"/export"})
    public void exportDypz(HttpServletResponse response, @ModelAttribute BdcZsmbpzFileDTO dypzDTO) {
        if (null == dypzDTO || StringUtils.isBlank((CharSequence)dypzDTO.getFiledata())) {
            throw new DysjyException("\u672a\u5b9a\u4e49\u8981\u5bfc\u51fa\u7684\u6253\u5370\u6570\u636e\u6e90\u6a21\u677f\u6570\u636e");
        }
        List dysjPzDTOList = JSON.parseArray((String)dypzDTO.getFiledata(), BdcDysjPzDTO.class);
        if (CollectionUtils.isEmpty((Collection)dysjPzDTOList)) {
            throw new DysjyException("\u672a\u5b9a\u4e49\u8981\u5bfc\u51fa\u7684\u6253\u5370\u6570\u636e\u6e90\u6a21\u677f\u6570\u636e");
        }
        ArrayList<BdcDysjPzDTO> dysjPzDTOList1 = new ArrayList<BdcDysjPzDTO>();
        for (BdcDysjPzDTO dypzDTO1 : dysjPzDTOList) {
            BdcDysjPzDTO dysjPzDTO = this.bdcDysjPzRestService.getPzxx(dypzDTO1.getDylx());
            dysjPzDTOList1.add(dysjPzDTO);
        }
        try (BufferedOutputStream bos = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            String fileName = URLEncoder.encode("\u4e0d\u52a8\u4ea7\u6743\u5229\u6253\u5370\u6570\u636e\u6e90\u914d\u7f6e\u5bfc\u51fa\u6587\u4ef6" + DateUtils.formateTimeYmdhms(new Date()) + ".txt", "utf-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setCharacterEncoding("utf-8");
            response.setContentType("application/octet-stream");
            bos.write(JSON.toJSONString(dysjPzDTOList1).getBytes("UTF-8"));
            bos.flush();
        }
        catch (Exception e) {
            throw new DysjyException("\u6743\u5229\u5176\u4ed6\u72b6\u51b5\u9644\u8bb0\u6a21\u677f\u5bfc\u51fa\u51fa\u9519\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
    }

    @GetMapping(value={"print/model/dbSource"})
    public JSONObject getDBSource() {
        JSONObject result = new JSONObject();
        result.put("code", (Object)200);
        result.put("data", (Object)this.dbSourceList);
        return result;
    }

    @RequestMapping(value={"/importYz"})
    public Map importDypzYz(HttpServletRequest request, MultipartFile file) {
        StringBuffer buff = new StringBuffer();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                buff.append(line);
            }
        }
        catch (IOException e) {
            LOGGER.error("\u6253\u5370\u6570\u636e\u6e90\u914d\u7f6e\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            throw new DysjyException("\u6253\u5370\u6570\u636e\u6e90\u914d\u7f6e\u6a21\u677f\u5bfc\u5165\u5931\u8d25!");
        }
        String dypzListJson = buff.toString();
        if (null == dypzListJson) {
            throw new DysjyException("\u6253\u5370\u6570\u636e\u6e90\u914d\u7f6e\u6a21\u677f\u5bfc\u5165\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a!");
        }
        List dysjPzDTOList = JSON.parseArray((String)dypzListJson, BdcDysjPzDTO.class);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dysjPzDTOList)) {
            throw new DysjyException("\u6a21\u677f\u5bfc\u51fa\u9519\uff0c\u5bfc\u5165\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Object> res = new HashMap<String, Object>(3);
        String dylxMessage = "";
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dysjPzDTOList)) {
            for (BdcDysjPzDTO bdcDysjPzDTO : dysjPzDTOList) {
                bdcDysjPzDTO.setDysjy(StringToolUtils.replaceBracket(Base64Util.encodeByteToBase64Str(bdcDysjPzDTO.getDysjy().getBytes())));
                bdcDysjPzDTO.setDyzd(StringToolUtils.replaceBracket(Base64Util.encodeByteToBase64Str(bdcDysjPzDTO.getDyzd().getBytes())));
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(bdcDysjPzDTO.getBdcDysjZbPzDOList())) continue;
                for (BdcDysjZbPzDO bdcDysjZbPzDO : bdcDysjPzDTO.getBdcDysjZbPzDOList()) {
                    bdcDysjZbPzDO.setDyzbsjy(StringToolUtils.replaceBracket(Base64Util.encodeByteToBase64Str(bdcDysjZbPzDO.getDyzbsjy().getBytes())));
                }
            }
        }
        for (BdcDysjPzDTO dypzDTO : dysjPzDTOList) {
            BdcDysjPzDTO dysjPzDTO1 = this.bdcDysjPzRestService.getPzxx(dypzDTO.getDylx());
            if (null == dysjPzDTO1 || !StringUtils.isNotBlank((CharSequence)dysjPzDTO1.getDylx())) continue;
            dylxMessage = dylxMessage + dysjPzDTO1.getDylx() + "\uff0c";
        }
        res.put("savedata", dysjPzDTOList);
        LOGGER.info("\u6253\u5370\u7c7b\u578b\u91cd\u590d\u7684\u6709{}", (Object)dylxMessage);
        if (StringUtils.isNotBlank((CharSequence)dylxMessage)) {
            res.put("code", 2);
            res.put("message", dylxMessage);
            return res;
        }
        return res;
    }

    @PostMapping(value={"/import"})
    public Map importDypz(@RequestBody List<BdcDysjPzDTO> bdcDysjPzDTOList) {
        Integer count = 0;
        if (org.apache.commons.collections.CollectionUtils.isEmpty(bdcDysjPzDTOList)) {
            throw new DysjyException("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        for (BdcDysjPzDTO dypzDTO : bdcDysjPzDTOList) {
            BdcDysjPzDTO dysjPzDTO = this.bdcDysjPzRestService.getPzxx(dypzDTO.getDylx());
            if (null != dysjPzDTO && StringUtils.isNotBlank((CharSequence)dypzDTO.getDylx())) {
                dypzDTO.setId(dysjPzDTO.getId());
                this.bdcDysjPzRestService.saveOrUpdatePzxx(dypzDTO);
                continue;
            }
            this.bdcDysjPzRestService.saveOrUpdatePzxx(dysjPzDTO);
        }
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("code", "1");
        data.put("count", bdcDysjPzDTOList);
        return data;
    }

    @DeleteMapping(value={"/dysj"})
    public Object deleteBdcDysjPz(@RequestBody List<BdcDysjPzDO> bdcDysjPzDOList) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(bdcDysjPzDOList)) {
            for (BdcDysjPzDO bdcDysjPzDO : bdcDysjPzDOList) {
                bdcDysjPzDO.setDysjy(new String(Base64Util.decodeBase64StrToByte(StringToolUtils.replaceBracket(bdcDysjPzDO.getDysjy()))));
            }
        }
        return this.bdcDysjPzRestService.deleteBdcDysjPzDO(bdcDysjPzDOList);
    }

    @DeleteMapping(value={"/dysj/{id}"})
    public Object deleteBdcDysjPz(@PathVariable String id) {
        return this.bdcDysjPzRestService.deleteBdcDysjPzDO(id);
    }

    @GetMapping(value={"/pzxx/checkDylx"})
    public int checkDylx(@RequestParam(value="dylx") String dylx) {
        if (StringUtils.isBlank((CharSequence)dylx)) {
            throw new MissingArgumentException("\u7f3a\u5931\u67e5\u8be2\u53c2\u6570\uff1a\u6253\u5370\u7c7b\u578b\uff08dylx\uff09\uff01");
        }
        return this.bdcDysjPzRestService.checkDylx(dylx);
    }
}

