/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.server.utils;

import cn.gtmap.dysjy.common.domain.BdcDysjCache;
import cn.gtmap.dysjy.common.domain.BdcDysjPzDO;
import cn.gtmap.dysjy.common.domain.BdcDysjTokenDO;
import cn.gtmap.dysjy.common.domain.BdcDysjZbPzDO;
import cn.gtmap.dysjy.common.service.BdcDyDataService;
import cn.gtmap.dysjy.common.utils.UUIDGenerator;
import cn.gtmap.dysjy.mybatis.mapper.DyEntityMapper;
import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DyCacheUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DyCacheUtils.class);
    private static final Map<String, String> cacheMap = new ConcurrentHashMap<String, String>();
    @Value(value="${dysjy.server.single:false}")
    private Boolean singleServer;
    @Autowired
    private DyEntityMapper dyEntityMapper;
    @Autowired(required=false)
    private List<BdcDyDataService> bdcDyDataServiceList;

    public String setData(String key, String data) {
        if (this.singleServer.booleanValue()) {
            cacheMap.put(key, data);
            return key;
        }
        BdcDysjCache bdcDysjCache = new BdcDysjCache();
        bdcDysjCache.setId(key);
        bdcDysjCache.setData(data);
        bdcDysjCache.setCreateTime(new Date());
        this.dyEntityMapper.insertSelective(bdcDysjCache);
        return key;
    }

    public String setData(String data) {
        String key = UUIDGenerator.generate16();
        return this.setData(key, data);
    }

    public String getData(String key) {
        if (this.singleServer.booleanValue()) {
            return cacheMap.get(key);
        }
        BdcDysjCache bdcDysjCache = this.dyEntityMapper.selectByPrimaryKey(BdcDysjCache.class, key);
        if (null == bdcDysjCache) {
            return null;
        }
        return bdcDysjCache.getData();
    }

    public String getData(String key, Integer useTime) {
        BdcDysjCache bdcDysjCache;
        if (null == useTime) {
            useTime = 120;
        }
        if (null == (bdcDysjCache = this.dyEntityMapper.selectByPrimaryKey(BdcDysjCache.class, key))) {
            return null;
        }
        if (System.currentTimeMillis() - bdcDysjCache.getCreateTime().getTime() > (long)(useTime * 60 * 60)) {
            return null;
        }
        return bdcDysjCache.getData();
    }

    public String setLocalData(String key, String data) {
        BdcDysjCache bdcDysjCache = new BdcDysjCache();
        bdcDysjCache.setId(key);
        bdcDysjCache.setData(data);
        bdcDysjCache.setCreateTime(new Date());
        this.dyEntityMapper.insertSelective(bdcDysjCache);
        return key;
    }

    public void setToken(BdcDysjTokenDO bdcDysjTokenDO) {
        if (null == bdcDysjTokenDO || StringUtils.isBlank((CharSequence)bdcDysjTokenDO.getTokenValue())) {
            return;
        }
        bdcDysjTokenDO.setUpdateTime(new Date());
        this.dyEntityMapper.deleteByPrimaryKey(BdcDysjTokenDO.class, bdcDysjTokenDO.getId());
        this.dyEntityMapper.insertSelective(bdcDysjTokenDO);
    }

    public void setSingleServerTrue() {
        this.singleServer = Boolean.TRUE;
    }

    public BdcDysjTokenDO getToken(BdcDysjPzDO bdcDysjPzDO) {
        BdcDysjTokenDO bdcDysjTokenDO = this.dyEntityMapper.selectByPrimaryKey(BdcDysjTokenDO.class, bdcDysjPzDO.getId());
        if (Objects.nonNull(bdcDysjTokenDO)) {
            return bdcDysjTokenDO;
        }
        if (StringUtils.isNotBlank((CharSequence)bdcDysjTokenDO.getTokenValue()) && System.currentTimeMillis() < bdcDysjTokenDO.getUpdateTime().getTime() + (long)(60000 * bdcDysjTokenDO.getValidTime())) {
            return bdcDysjTokenDO;
        }
        if (CollectionUtils.isNotEmpty(this.bdcDyDataServiceList)) {
            for (BdcDyDataService bdcDyDataService : this.bdcDyDataServiceList) {
                bdcDysjTokenDO = bdcDyDataService.initToken(bdcDysjPzDO);
                if (!Objects.nonNull(bdcDysjTokenDO)) continue;
                LOGGER.debug("\u7528\u6237\u8fd4\u56detoken bdcDysjPzDO: {}, bdcDysjTokenDO: {}", (Object)JSON.toJSONString((Object)bdcDysjPzDO), (Object)JSON.toJSONString((Object)bdcDysjTokenDO));
                this.dyEntityMapper.insertSelective(bdcDysjTokenDO);
                return bdcDysjTokenDO;
            }
        }
        LOGGER.debug("\u7528\u6237\u672a\u5b9e\u73b0\u63a5\u53e3\u6216\u672a\u8fd4\u56detoken bdcDysjPzDO: {}", (Object)JSON.toJSONString((Object)bdcDysjPzDO));
        return null;
    }

    public BdcDysjTokenDO getToken(BdcDysjZbPzDO bdcDysjZbPzDO) {
        BdcDysjTokenDO bdcDysjTokenDO = this.dyEntityMapper.selectByPrimaryKey(BdcDysjTokenDO.class, bdcDysjZbPzDO.getId());
        if (Objects.nonNull(bdcDysjTokenDO)) {
            return bdcDysjTokenDO;
        }
        if (StringUtils.isNotBlank((CharSequence)bdcDysjTokenDO.getTokenValue()) && System.currentTimeMillis() < bdcDysjTokenDO.getUpdateTime().getTime() + (long)(60000 * bdcDysjTokenDO.getValidTime())) {
            return bdcDysjTokenDO;
        }
        if (CollectionUtils.isNotEmpty(this.bdcDyDataServiceList)) {
            for (BdcDyDataService bdcDyDataService : this.bdcDyDataServiceList) {
                bdcDysjTokenDO = bdcDyDataService.initToken(bdcDysjZbPzDO);
                if (!Objects.nonNull(bdcDysjTokenDO)) continue;
                LOGGER.debug("\u7528\u6237\u8fd4\u56detoken bdcDysjZbPzDO: {}, bdcDysjTokenDO: {}", (Object)JSON.toJSONString((Object)bdcDysjZbPzDO), (Object)JSON.toJSONString((Object)bdcDysjTokenDO));
                this.dyEntityMapper.insertSelective(bdcDysjTokenDO);
                return bdcDysjTokenDO;
            }
        }
        LOGGER.debug("\u7528\u6237\u672a\u5b9e\u73b0\u63a5\u53e3\u6216\u672a\u8fd4\u56detoken bdcDysjZbPzDO: {}", (Object)JSON.toJSONString((Object)bdcDysjZbPzDO));
        return null;
    }
}

