/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.utils;

import cn.gtmap.dysjy.common.utils.ResultHandleUtils;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringToolUtils
extends StringUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringToolUtils.class);

    public static String replaceBracket(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        if (str.indexOf("\uff08") != -1) {
            str = str.replaceAll("\uff08", "(");
        }
        if (str.indexOf("\uff09") != -1) {
            str = str.replaceAll("\uff09", ")");
        }
        return str;
    }

    public static String replaceXml(String key, Object value, String xml, Map dataMap) {
        try {
            value = StringToolUtils.getValue(key, value, dataMap);
            if (ResultHandleUtils.isMethodString(key)) {
                return ResultHandleUtils.replaceXml(key, value, xml, dataMap);
            }
            xml = xml.replaceAll("\\$&amp;", "&");
            xml = xml.replaceAll("&amp;", "&");
            xml = xml.replaceAll("\\>\\$" + StringUtils.upperCase((String)key) + "\\<", "\\>" + value + "\\<");
            xml = xml.replaceAll("\\>\\$" + StringUtils.lowerCase((String)key) + "\\<", "\\>" + value + "\\<");
            xml = xml.replaceAll("\\>\\$" + key + "\\<", "\\>" + value + "\\<");
            xml = xml.replaceAll("\\$\\{[" + StringUtils.upperCase((String)key) + "}]+\\}", String.valueOf(value));
            xml = xml.replaceAll("\\$\\{[" + StringUtils.lowerCase((String)key) + "}]+\\}", String.valueOf(value));
            xml = xml.replaceAll("\\$\\{[" + key + "}]+\\}", String.valueOf(value));
        }
        catch (Exception e) {
            LOGGER.debug("replaceAll \u5f02\u5e38", (Throwable)e);
        }
        return xml;
    }

    private static Object getValue(String key, Object value, Map dataMap) {
        if (Objects.nonNull(value)) {
            return value;
        }
        value = dataMap.get(key.toLowerCase());
        if (Objects.nonNull(value)) {
            return value;
        }
        return dataMap.get(key.toUpperCase());
    }

    public static String valueOf(Object obj, String defaultVal) {
        return obj == null ? defaultVal : obj.toString();
    }
}

