/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.utils;

import cn.gtmap.dysjy.common.domain.BdcDysjMethod;
import cn.gtmap.dysjy.common.spring.DyContainer;
import cn.gtmap.dysjy.common.utils.CoeRuntimeContext;
import cn.gtmap.dysjy.common.utils.ExpressEvalUtil;
import cn.gtmap.dysjy.common.utils.JsonObjectUtil;
import cn.gtmap.dysjy.mybatis.mapper.DyEntityMapper;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultHandleUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultHandleUtils.class);

    public static String replaceXml(String key, Object value, String xml, Map dataMap) {
        if (!ResultHandleUtils.isMethodString(key)) {
            return xml;
        }
        try {
            Object realValue = ResultHandleUtils.getMethodKeyValue(key, dataMap);
            if (Objects.isNull(realValue)) {
                realValue = value;
            }
            return xml.substring(0, xml.indexOf("$" + key)) + realValue + xml.substring(xml.indexOf("$" + key) + key.length() + 1);
        }
        catch (Exception e) {
            LOGGER.debug("\u66ff\u6362xml\u5f02\u5e38 key: {}, value: {}, xml: {}", new Object[]{key, value, xml, e});
            return xml;
        }
    }

    private static String[] getRealKey(String key) {
        int start = key.indexOf("(");
        int end = key.indexOf(")");
        if (start < 0 || end < 0) {
            return new String[]{key};
        }
        if (end == start + 1) {
            return new String[0];
        }
        String[] keyArray = key.substring(start + 1, end).split(",");
        for (int i = 0; i < keyArray.length; ++i) {
            keyArray[i] = keyArray[i].trim();
        }
        return keyArray;
    }

    private static String getRealResultByKey(String key, Map dataMap) {
        try {
            Object targetValueObject;
            String value;
            String classAndMethod = key.split("\\(")[0];
            int index = classAndMethod.lastIndexOf(".");
            String className = classAndMethod.substring(0, index);
            String methodName = classAndMethod.substring(index + 1);
            Class<?> clazz = Class.forName(className);
            Object object = null;
            try {
                object = DyContainer.getBean(clazz);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (Objects.isNull(object)) {
                object = clazz.newInstance();
            }
            if (Objects.nonNull(value = ResultHandleUtils.getPropValue(key, targetValueObject = ResultHandleUtils.getValue(clazz, methodName, object, key, dataMap)))) {
                return value;
            }
            return null;
        }
        catch (Exception e1) {
            String value = ExpressEvalUtil.evalExpressString(key, dataMap);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                return value;
            }
            return null;
        }
    }

    private static String getPropValue(String key, Object targetValueObject) {
        if (key.indexOf(").") < 0) {
            if (Objects.nonNull(targetValueObject)) {
                return targetValueObject.toString();
            }
            return null;
        }
        String propName = key.split("\\).")[1];
        return JsonObjectUtil.getJsonObjectValue(propName, targetValueObject);
    }

    private static Object getValue(Class clazz, String methodName, Object object, String key, Map dataMap) {
        Method[] methodList = clazz.getDeclaredMethods();
        if (null == methodList || methodList.length == 0) {
            return null;
        }
        String[] keyArray = ResultHandleUtils.getRealKey(key);
        DyEntityMapper dyEntityMapper = DyContainer.getBean(DyEntityMapper.class);
        BdcDysjMethod bdcDysjMethod = dyEntityMapper.selectByPrimaryKey(BdcDysjMethod.class, clazz.getName() + "." + methodName + "-" + keyArray.length);
        if (Objects.isNull(bdcDysjMethod)) {
            LOGGER.error("\u65b9\u6cd5\u4e0d\u5141\u8bb8\u8c03\u7528 classAndMethod: {}, paramCount: {}", (Object)(clazz.getName() + "." + methodName), (Object)keyArray.length);
            return new JSONObject();
        }
        for (Method method : methodList) {
            if (!method.getName().equals(methodName) || method.getParameterCount() != keyArray.length) continue;
            try {
                Class<?>[] methodClassList = method.getParameterTypes();
                ArrayList<Object> paramList = new ArrayList<Object>();
                for (int j = 0; j < methodClassList.length; ++j) {
                    Class<?> methodClass = methodClassList[j];
                    paramList.add(ResultHandleUtils.paramValue(methodClass, dataMap, keyArray, j));
                }
                Object result = CoeRuntimeContext.getRuntimeData(ResultHandleUtils.genCahceKey(clazz, methodName, paramList));
                if (Objects.nonNull(result)) {
                    return result;
                }
                result = method.invoke(object, paramList.toArray());
                if (!Objects.nonNull(result)) continue;
                CoeRuntimeContext.setRuntimeData(ResultHandleUtils.genCahceKey(clazz, methodName, paramList), result);
                return result;
            }
            catch (Exception e) {
                LOGGER.debug("\u8c03\u7528\u65b9\u6cd5\u5904\u7406\u8fd4\u56de\u7ed3\u679c\u6570\u636e\u5f02\u5e38 methodName: {}, key: {}", new Object[]{methodName, key, e});
            }
        }
        return null;
    }

    private static String genCahceKey(Class clazz, String methodName, List<Object> paramList) {
        List stringList = paramList.stream().map(obj -> Objects.isNull(obj) ? "null" : obj.toString()).collect(Collectors.toList());
        Object[] array = new String[]{clazz.getName(), methodName, StringUtils.join(stringList, (String)"-")};
        return StringUtils.join((Object[])array, (String)"-");
    }

    private static Object paramValue(Class clazz, Map dataMap, String[] keyArray, int index) {
        String keyj = keyArray[index];
        Object value = dataMap.get(keyj.toLowerCase());
        if (Objects.isNull(value)) {
            value = dataMap.get(keyj.toUpperCase());
        }
        if (Objects.isNull(value) && !StringUtils.equals((CharSequence)"null", (CharSequence)keyj)) {
            value = keyj;
        }
        if (Objects.isNull(value)) {
            return null;
        }
        if (String.class.equals((Object)clazz)) {
            return value.toString();
        }
        if (BigDecimal.class.equals((Object)clazz)) {
            return new BigDecimal(value.toString());
        }
        if (StringBuffer.class.equals((Object)clazz)) {
            return new StringBuffer(value.toString());
        }
        if (StringBuilder.class.equals((Object)clazz)) {
            return new StringBuilder(value.toString());
        }
        if (Integer.class.equals((Object)clazz) || Integer.TYPE.equals(clazz)) {
            return new Integer(value.toString());
        }
        if (Float.class.equals((Object)clazz) || Float.TYPE.equals(clazz)) {
            return new Float(value.toString());
        }
        if (Double.class.equals((Object)clazz) || Double.TYPE.equals(clazz)) {
            return new Double(value.toString());
        }
        if (value.getClass().equals(JSONArray.class)) {
            return value;
        }
        JSONObject jsonObject = JSON.parseObject((String)keyj);
        for (String key : jsonObject.keySet()) {
            Object jsonValue = jsonObject.get((Object)key);
            Object val = dataMap.get(jsonValue);
            if (!Objects.nonNull(val)) continue;
            jsonObject.put(key, val);
        }
        return JSON.parseObject((String)JSON.toJSONString((Object)jsonObject), (Class)clazz);
    }

    private static String getMethodKeyValue(String key, Map dataMap) {
        if (!ResultHandleUtils.isMethodString(key)) {
            return key;
        }
        int leftIndex = 0;
        block4: for (int i = 0; i < key.length(); ++i) {
            char tempChar = key.charAt(i);
            switch (tempChar) {
                case '(': {
                    leftIndex = i;
                    continue block4;
                }
                case ')': {
                    String oldString = StringUtils.substring((String)key, (int)ResultHandleUtils.getStart(key, leftIndex), (int)ResultHandleUtils.getEnd(key, i));
                    String newString = ResultHandleUtils.getRealResultByKey(oldString, dataMap);
                    if (StringUtils.isBlank((CharSequence)newString)) {
                        newString = "";
                    }
                    return ResultHandleUtils.getMethodKeyValue(key.replace(oldString, newString), dataMap);
                }
            }
        }
        return key;
    }

    public static boolean isMethodString(String param) {
        return StringUtils.isNotBlank((CharSequence)param) && StringUtils.contains((CharSequence)param, (CharSequence)"(") && StringUtils.contains((CharSequence)param, (CharSequence)")") && StringUtils.indexOf((CharSequence)param, (CharSequence)"(") < StringUtils.indexOf((CharSequence)param, (CharSequence)")");
    }

    private static int getStart(String key, int end) {
        int index2;
        int index1 = StringUtils.lastIndexOf((CharSequence)(key = StringUtils.substring((String)key, (int)0, (int)end)), (CharSequence)",");
        int index = index1 < (index2 = StringUtils.lastIndexOf((CharSequence)key, (CharSequence)"(")) ? index2 : index1;
        return index + 1;
    }

    private static int getEnd(String key, int start) {
        key = StringUtils.substring((String)key, (int)(start + 1));
        int index1 = StringUtils.indexOf((CharSequence)key, (CharSequence)",");
        int index2 = StringUtils.indexOf((CharSequence)key, (CharSequence)")");
        int index = index1 < 0 && index2 < 0 ? key.length() : (index1 < 0 && index2 >= 0 ? index2 : (index2 < 0 && index1 >= 0 ? index1 : (index1 < index2 ? index1 : index2)));
        return start + index + 1;
    }

    public static String replaceParam(String dysjy) {
        if (StringUtils.isBlank((CharSequence)dysjy)) {
            return dysjy;
        }
        String tempString = dysjy;
        String exResult = dysjy;
        try {
            int end;
            int start;
            while ((start = tempString.indexOf("${")) > -1 && (end = tempString.indexOf("}")) >= start) {
                String methodValue;
                String method = tempString.substring(start + 2, end);
                if (ResultHandleUtils.isMethodString(method) && StringUtils.isNotBlank((CharSequence)(methodValue = ResultHandleUtils.getMethodKeyValue(method, new HashMap())))) {
                    dysjy = dysjy.replace("${" + method + "}", methodValue);
                }
                tempString = tempString.substring(end + 1);
            }
        }
        catch (Exception e) {
            LOGGER.debug("\u53c2\u6570\u5904\u7406\u5f02\u5e38", (Throwable)e);
            return exResult;
        }
        return dysjy;
    }
}

