/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.utils;

import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DysjyDataUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DysjyDataUtil.class);
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static String joinString(List dataList, String key, String delimiter) {
        try {
            if (CollectionUtils.isEmpty((Collection)dataList)) {
                return "";
            }
            if (StringUtils.isBlank((CharSequence)delimiter)) {
                delimiter = ",";
            }
            List stringList = dataList.stream().map(object -> {
                String value = JSON.parseObject((String)JSON.toJSONString((Object)object)).getString(key);
                return Objects.isNull(value) ? "" : String.valueOf(value);
            }).collect(Collectors.toList());
            return String.join((CharSequence)delimiter, stringList);
        }
        catch (Exception e) {
            LOGGER.error("joinString error dataList: {}, key: {}", new Object[]{JSON.toJSONString((Object)dataList), key, e});
            return "";
        }
    }

    public static String currentDate2String(String formatString) {
        try {
            if (StringUtils.isBlank((CharSequence)formatString)) {
                formatString = DEFAULT_DATE_FORMAT;
            }
            Date date = new Date();
            SimpleDateFormat format = new SimpleDateFormat(formatString);
            return format.format(new Date());
        }
        catch (Exception e) {
            LOGGER.error("currentDate2String error formatString: {}", (Object)formatString, (Object)e);
            return "";
        }
    }
}

