/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.spirepdf;

import cn.gtmap.dysjy.common.domain.BdcDysjPzDO;
import cn.gtmap.dysjy.common.spirepdf.SpireDocService;
import cn.gtmap.dysjy.common.spirepdf.SpireOfficeUtil;
import cn.gtmap.pdf.service.TemplateClientDealService;
import cn.gtmap.pdf.utils.OfficeUtils;
import com.deepoove.poi.NiceXWPFDocument;
import com.spire.doc.Document;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.docx4j.fonts.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpirePdfTask
implements Callable<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpirePdfTask.class);
    private SpireDocService spireDocService;
    private Map<String, Object> pdfData;
    private int index;
    private String printPath;
    private String modelName;
    private Mapper fontMapper;
    private TemplateClientDealService templateSpecialDealService;
    private BdcDysjPzDO bdcDysjPzDO;

    public SpirePdfTask(SpireDocService spireDocService, Map<String, Object> pdfData, int index, String modelName, String printPath, Mapper fontMapper, TemplateClientDealService templateSpecialDealService, BdcDysjPzDO bdcDysjPzDO) {
        this.spireDocService = spireDocService;
        this.printPath = printPath;
        this.pdfData = pdfData;
        this.index = index;
        this.modelName = modelName;
        this.fontMapper = fontMapper;
        this.templateSpecialDealService = templateSpecialDealService;
        this.bdcDysjPzDO = bdcDysjPzDO;
    }

    /*
     * Loose catch block
     */
    @Override
    public String call() throws Exception {
        LOGGER.debug("PDF\u5bfc\u51fa\u6b63\u5728\u5904\u7406\u7b2c{}\u4efd\u6587\u4ef6\uff01", (Object)(this.index + 1));
        String tempWordFileName = SpireOfficeUtil.generateWordFileName(this.printPath);
        String tempPdfFileName = SpireOfficeUtil.generatePdfFileName(this.printPath, null);
        try {
            try (FileOutputStream wordFileOutStream = new FileOutputStream(tempWordFileName);){
                Document doc;
                int pageCount;
                NiceXWPFDocument document = this.spireDocService.getNiceXWPFDocument(this.modelName, this.pdfData);
                document.write((OutputStream)wordFileOutStream);
                wordFileOutStream.flush();
                wordFileOutStream.close();
                this.deleteBlankParagraph(tempWordFileName);
                if (Objects.nonNull(this.templateSpecialDealService)) {
                    this.templateSpecialDealService.dealTemplate(this.modelName, tempWordFileName);
                }
                if ((pageCount = (doc = new Document(tempWordFileName)).getPageCount()) > 3 || Objects.nonNull(this.bdcDysjPzDO) && "docx4j".equals(this.bdcDysjPzDO.getZhfs())) {
                    OfficeUtils.convertDocxToPDF((String)tempWordFileName, (String)tempPdfFileName, (Mapper)this.fontMapper, (String)this.printPath, (String)this.modelName);
                } else {
                    SpireOfficeUtil.convertDocxToPDF(tempWordFileName, tempPdfFileName, this.fontMapper);
                }
                OfficeUtils.addWaterMarkConfigToPdfFile((String)tempPdfFileName, this.pdfData, (String)this.printPath, null);
                OfficeUtils.addPicWaterMarkConfigToPdfFile((String)tempPdfFileName, this.pdfData, (String)this.printPath);
                OfficeUtils.addQzPicConfigToPdfFile((String)tempPdfFileName, this.pdfData, (String)this.printPath);
                LOGGER.debug("\u5f53\u524d\u5904\u7406\u7b2c{}\u9875\u6587\u6863\u5b8c\u6210", (Object)(this.index + 1));
                String string = tempPdfFileName;
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            File wordFile = new File(tempWordFileName);
            if (wordFile.exists()) {
                wordFile.delete();
            }
        }
    }

    private void deleteBlankParagraph(String tempWordFileName) {
        try {
            XWPFParagraph paragraph;
            List runs;
            IBodyElement element;
            XWPFDocument document = new XWPFDocument(Files.newInputStream(Paths.get(tempWordFileName, new String[0]), new OpenOption[0]));
            List elements = document.getBodyElements();
            for (int i = 0; i < 1000 && (element = (IBodyElement)elements.get(elements.size() - 1)) instanceof XWPFParagraph && (runs = (paragraph = (XWPFParagraph)element).getRuns()).size() == 0; ++i) {
                document.removeBodyElement(document.getPosOfParagraph(paragraph));
            }
            FileOutputStream fos = new FileOutputStream(tempWordFileName);
            document.write((OutputStream)fos);
            ((OutputStream)fos).close();
            document.close();
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u6587\u4ef6\u5c3e\u90e8\u7a7a\u767d\u6bb5\u843d\u5f02\u5e38", (Throwable)e);
        }
    }
}

