/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.spirepdf;

import cn.gtmap.dysjy.common.utils.UUIDGenerator;
import cn.gtmap.dysjy.exceptions.DysjyException;
import com.spire.doc.Document;
import com.spire.doc.FileFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.util.Matrix;
import org.docx4j.fonts.IdentityPlusMapper;
import org.docx4j.fonts.Mapper;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.PhysicalFonts;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.RFonts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpireOfficeUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpireOfficeUtil.class);

    public static void convertDocxToPDF(String docxPath, String pdfPath, Mapper fontMapper) throws Exception {
        Document doc = new Document();
        doc.loadFromFile(docxPath);
        doc.saveToFile(pdfPath, FileFormat.PDF);
    }

    private static void configSimSunFont(WordprocessingMLPackage wordMLPackage, Mapper fontMapper) throws Exception {
        wordMLPackage.setFontMapper(fontMapper);
        RFonts rfonts = Context.getWmlObjectFactory().createRFonts();
        rfonts.setAsciiTheme(null);
        rfonts.setAscii("SimSun");
        wordMLPackage.getMainDocumentPart().getPropertyResolver().getDocumentDefaultRPr().setRFonts(rfonts);
    }

    public static Mapper getFontMapper(String printPath) {
        try {
            String fontFamily = "SimSun";
            URL simsunUrl = new URL("file:" + printPath + "simsun.ttc");
            PhysicalFonts.addPhysicalFonts((String)fontFamily, (URL)simsunUrl);
            PhysicalFont simsunFont = PhysicalFonts.get((String)fontFamily);
            URL simheiUrl = new URL("file:" + printPath + "simhei.ttc");
            PhysicalFonts.addPhysicalFonts((String)fontFamily, (URL)simheiUrl);
            PhysicalFont simheiFont = PhysicalFonts.get((String)fontFamily);
            IdentityPlusMapper fontMapper = new IdentityPlusMapper();
            fontMapper.put("\u5b8b\u4f53", simsunFont);
            fontMapper.put("\u9ed1\u4f53", simheiFont);
            return fontMapper;
        }
        catch (Exception e) {
            LOGGER.warn("\u76ee\u5f55\u65e0\u6307\u5b9aPDF\u6253\u5370\u9700\u8981\u5b57\u4f53\uff1a{}", (Object)printPath);
            return SpireOfficeUtil.getFontMapper();
        }
    }

    public static Mapper getFontMapper() {
        IdentityPlusMapper fontMapper = new IdentityPlusMapper();
        fontMapper.put("\u5fae\u8f6f\u96c5\u9ed1", PhysicalFonts.get((String)"Microsoft Yahei"));
        fontMapper.put("\u9ed1\u4f53", PhysicalFonts.get((String)"SimHei"));
        fontMapper.put("\u6977\u4f53", PhysicalFonts.get((String)"KaiTi"));
        fontMapper.put("\u96b6\u4e66", PhysicalFonts.get((String)"LiSu"));
        fontMapper.put("\u5b8b\u4f53", PhysicalFonts.get((String)"SimSun"));
        fontMapper.put("\u5b8b\u4f53\u6269\u5c55", PhysicalFonts.get((String)"simsun-extB"));
        fontMapper.put("\u65b0\u5b8b\u4f53", PhysicalFonts.get((String)"NSimSun"));
        fontMapper.put("\u4eff\u5b8b", PhysicalFonts.get((String)"FangSong"));
        fontMapper.put("\u4eff\u5b8b_GB2312", PhysicalFonts.get((String)"FangSong_GB2312"));
        fontMapper.put("\u5e7c\u5706", PhysicalFonts.get((String)"YouYuan"));
        fontMapper.put("\u534e\u6587\u5b8b\u4f53", PhysicalFonts.get((String)"STSong"));
        fontMapper.put("\u534e\u6587\u4eff\u5b8b", PhysicalFonts.get((String)"STFangsong"));
        fontMapper.put("\u534e\u6587\u4e2d\u5b8b", PhysicalFonts.get((String)"STZhongsong"));
        fontMapper.put("\u534e\u6587\u884c\u6977", PhysicalFonts.get((String)"STXingkai"));
        return fontMapper;
    }

    public static String generateWordFileName(String printPath) {
        return printPath + "temp/" + UUIDGenerator.generate16() + ".docx";
    }

    public static String generatePdfFileName(String printPath, String localFile) {
        if (StringUtils.isNotBlank((CharSequence)localFile)) {
            return printPath + "temp/" + localFile;
        }
        return printPath + "temp/" + UUIDGenerator.generate16() + ".pdf";
    }

    public static void addWaterMarkToPdfFile(String pdfFilePath, String waterMark, String fontPath) {
        SpireOfficeUtil.appendWaterMark(pdfFilePath, waterMark, fontPath, 30.0f, 1.0f);
    }

    public static void addWaterMarkToPdfFileWithFontSzie(String pdfFilePath, String waterMark, String fontPath, float fontSzie) {
        float factor = (float)Math.sin(0.7853981633974483);
        SpireOfficeUtil.appendWaterMark(pdfFilePath, waterMark, fontPath, fontSzie, factor);
    }

    private static void appendWaterMark(String pdfFilePath, String waterMark, String fontPath, float fontSize, float factor) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{pdfFilePath, waterMark, fontPath})) {
            throw new DysjyException("\u672a\u6307\u5b9aPDF\u6587\u4ef6\u3001\u6c34\u5370\u5185\u5bb9\u3001\u5b57\u4f53\u8def\u5f84\u53c2\u6570");
        }
        File pdfFile = new File(pdfFilePath);
        if (!pdfFile.exists()) {
            throw new DysjyException("\u672a\u627e\u5230\u6307\u5b9a\u8def\u5f84PDF\u6587\u4ef6");
        }
        try {
            PDDocument doc = PDDocument.load((File)pdfFile);
            doc.setAllSecurityToBeRemoved(true);
            for (PDPage page : doc.getPages()) {
                PDPageContentStream cs = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.APPEND, true, true);
                PDType0Font font = PDType0Font.load((PDDocument)doc, (InputStream)new FileInputStream(fontPath + "simsun.ttf"), (boolean)true);
                PDResources resources = page.getResources();
                PDExtendedGraphicsState r0 = new PDExtendedGraphicsState();
                r0.setNonStrokingAlphaConstant(Float.valueOf(0.5f));
                r0.setAlphaSourceFlag(true);
                cs.setGraphicsStateParameters(r0);
                cs.setNonStrokingColor(220, 220, 220);
                cs.beginText();
                cs.setFont((PDFont)font, fontSize);
                float h = (float)waterMark.length() * fontSize;
                for (int i = 0; i <= 5; ++i) {
                    cs.setTextMatrix(Matrix.getRotateInstance((double)-150.0, (float)(i * 200), (float)0.0f));
                    cs.showText(waterMark);
                    for (int j = 0; j < 10; ++j) {
                        float ty = (float)j * h * factor;
                        cs.setTextMatrix(Matrix.getRotateInstance((double)-150.0, (float)(i * 200), (float)ty));
                        cs.showText(waterMark);
                    }
                }
                cs.endText();
                cs.restoreGraphicsState();
                cs.close();
            }
            doc.save(pdfFile);
        }
        catch (Exception e) {
            LOGGER.error("PDF{}\u6dfb\u52a0\u6c34\u5370\u5931\u8d25: {}", (Object)pdfFilePath, (Object)e.getMessage());
        }
    }
}

