/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.spirepdf;

import cn.gtmap.dysjy.common.spirepdf.impl.SpireDataServiceImpl;
import cn.gtmap.dysjy.common.utils.UUIDGenerator;
import cn.gtmap.dysjy.exceptions.DysjyException;
import com.deepoove.poi.NiceXWPFDocument;
import com.deepoove.poi.data.style.TableStyle;
import com.deepoove.poi.policy.DynamicTableRenderPolicy;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.ICell;
import org.apache.poi.xwpf.usermodel.LineSpacingRule;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.TextAlignment;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SpireDocTablePolicy
extends DynamicTableRenderPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpireDocTablePolicy.class);
    private static final String PDF_WORD_SUBTABLE_NAME_REG = "\\{\\{TABLE_[A-Za-z0-9_]+\\}\\}";
    private static final String PDF_WORD_SUBTABLE_CELL_REG = "\\{\\{CELL_[A-Za-z0-9_]+\\}\\}";
    private static final String PDF_WORD_SUBTABLE_CHECKBOX_REG = "\\{\\{&[A-Za-z0-9_]+";
    private static final String PDF_WORD_SUBTABLE_CHECKBOX_ALL_REG = "\\{\\{&[A-Za-z0-9_]+(#[0-9]+#)?\\}\\}";
    private static final String PDF_WORD_SUBTABLE_IMAGE_REG = "\\{\\{>[A-Za-z0-9_]+";
    private static final String PDF_WORD_SUBTABLE_CELL_START_REG = "\\{\\{CELL_[A-Za-z0-9_]+";
    private static final String PDF_WORD_SUBTABLE_CELL_START2_REG = "{{CELL_";
    private static final String PDF_WORD_SUBTABLE_CHECKBOX_START_REG = "{{&";
    private static final String PDF_WORD_SUBTABLE_IMAGE_START_REG = "{{>";
    private static final String PDF_WORD_SUBTABLE_IMAGE_START_REG2 = "PICT_";
    private static final String PDF_WORD_SUBTABLE_INNERTABLE_START_REG = "{{TABLE_ZB_";
    private static final String PDF_WORD_SUBTABLE_CELL_START3_REG = "{{";
    private static final String PDF_WORD_SUBTABLE_CELL_END_REG = "}}";
    private static final String PDF_WORD_SUBTABLE_INDEX_REG = "#[0-9]+#";
    private static final String PDF_WORD_SUBTABLE_INDEX_START_REG = "#";
    private static final String PDF_WORD_SUBTABLE_INDEX_END_REG = "#}}";
    private static final String PDF_WORD_CELL_TEXT_SPLIT = "_&&_";
    private static final TableStyle TABLE_ROW_STYLE = new TableStyle();
    private Map<String, Object> officeData;

    public SpireDocTablePolicy() {
    }

    public SpireDocTablePolicy(Map<String, Object> data) {
        this.officeData = data;
    }

    public void render(XWPFTable table, Object data) {
        if (null == table || null == data) {
            LOGGER.error("PDF\u3001WORD\u5904\u7406\u6570\u636e\u8868\u683c\u4e2d\u6b62\uff0c\u539f\u56e0\uff1a\u6ca1\u6709\u5b9a\u4e49\u6570\u636e\u8868\u683c\u6216\u8005\u65e0\u5bf9\u5e94\u6570\u636e\uff01");
            return;
        }
        List tableData = (List)data;
        if (CollectionUtils.isEmpty((Collection)tableData)) {
            LOGGER.error("PDF\u3001WORD\u5904\u7406\u6570\u636e\u8868\u683c\u4e2d\u6b62\uff0c\u539f\u56e0\uff1a\u65e0\u5bf9\u5e94\u6570\u636e\uff01");
            return;
        }
        String tableName = this.getTableName(table);
        try {
            if (this.isExpandTable(tableName)) {
                this.resolveMergeTable(table, tableData);
            } else {
                this.resolveGeneralTable(table, tableData);
            }
        }
        catch (Exception exception) {
            LOGGER.error("\u5bfc\u51faPDF\u3001WORD\u5904\u7406\u5b50\u8868\u51fa\u73b0\u9519\u8bef\uff1a{}", (Object)exception.getMessage());
            throw exception;
        }
    }

    private boolean isExpandTable(String tableName) {
        return StringUtils.startsWith((CharSequence)tableName, (CharSequence)"TABLE_ZT_") || StringUtils.startsWith((CharSequence)tableName, (CharSequence)"TABLE_zt_");
    }

    private void resolveMergeTable(XWPFTable table, List<Map<String, Object>> data) {
        List rows = table.getRows();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            LOGGER.error("PDF\u3001WORD\u5904\u7406\u6570\u636e\u8868\u683c\u4e2d\u6b62\uff0c\u539f\u56e0\uff1a\u8868\u683c\u65e0\u6570\u636e\u884c\u5185\u5bb9\uff01");
            return;
        }
        int size = rows.size();
        for (int index = 1; index < data.size(); ++index) {
            for (int i = 0; i < size; ++i) {
                XWPFTableRow newRow = table.insertNewTableRow(table.getRows().size());
                this.copyTableRow(newRow, (XWPFTableRow)rows.get(i), index);
            }
        }
        this.setTableData(table.getRows(), data);
    }

    public void copyTableRow(XWPFTableRow target, XWPFTableRow source, int index) {
        if (source.getCtRow() != null) {
            target.getCtRow().setTrPr(source.getCtRow().getTrPr());
        }
        for (int i = 0; i < source.getTableCells().size(); ++i) {
            XWPFTableCell cell1 = target.getCell(i);
            XWPFTableCell cell2 = source.getCell(i);
            if (cell1 == null) {
                cell1 = target.addNewTableCell();
            }
            this.copyTableCell(cell1, cell2, index);
        }
    }

    public void copyTableCell(XWPFTableCell target, XWPFTableCell source, int index) {
        if (source.getCTTc() != null) {
            target.getCTTc().setTcPr(source.getCTTc().getTcPr());
        }
        for (int pos = 0; pos < target.getParagraphs().size(); ++pos) {
            target.removeParagraph(pos);
        }
        for (XWPFParagraph sp : source.getParagraphs()) {
            XWPFParagraph targetP = target.addParagraph();
            this.copyParagraph(targetP, sp, index);
        }
    }

    public void copyParagraph(XWPFParagraph target, XWPFParagraph source, int index) {
        target.getCTP().setPPr(source.getCTP().getPPr());
        for (int pos = target.getRuns().size() - 1; pos >= 0; --pos) {
            target.removeRun(pos);
        }
        for (XWPFRun s : source.getRuns()) {
            XWPFRun targetrun = target.createRun();
            this.copyRun(targetrun, s, index);
        }
    }

    public void copyRun(XWPFRun target, XWPFRun source, int index) {
        target.getCTR().setRPr(source.getCTR().getRPr());
        String text = source.text();
        if (StringUtils.startsWith((CharSequence)text, (CharSequence)PDF_WORD_SUBTABLE_INNERTABLE_START_REG)) {
            target.setText(text);
            return;
        }
        if (StringUtils.startsWith((CharSequence)text, (CharSequence)PDF_WORD_SUBTABLE_CELL_START3_REG)) {
            String endIndex = PDF_WORD_SUBTABLE_INDEX_START_REG + index + PDF_WORD_SUBTABLE_INDEX_END_REG;
            text = text.replace(PDF_WORD_SUBTABLE_CELL_END_REG, endIndex);
        } else if (StringUtils.startsWith((CharSequence)text, (CharSequence)PDF_WORD_SUBTABLE_IMAGE_START_REG2)) {
            text = text + PDF_WORD_SUBTABLE_INDEX_START_REG + index + PDF_WORD_SUBTABLE_INDEX_START_REG;
        }
        target.setText(text);
    }

    private void setTableData(List<XWPFTableRow> rows, List<Map<String, Object>> data) {
        int subTableIndex = 1;
        HashMap<String, Integer> checkBoxMap = new HashMap<String, Integer>(10);
        for (XWPFTableRow row : rows) {
            List cells = row.getTableICells();
            for (ICell cell : cells) {
                String text = ((XWPFTableCell)cell).getText().trim();
                if (StringUtils.startsWith((CharSequence)text, (CharSequence)PDF_WORD_SUBTABLE_CHECKBOX_START_REG)) {
                    if (checkBoxMap.containsKey(text)) {
                        int checkBoxIndex = (Integer)checkBoxMap.get(text);
                        checkBoxMap.put(text, ++checkBoxIndex);
                    } else {
                        checkBoxMap.put(text, 0);
                    }
                    this.resolveCheckBox(data, (XWPFTableCell)cell, text, (Integer)checkBoxMap.get(text));
                    continue;
                }
                if (text.startsWith(PDF_WORD_SUBTABLE_IMAGE_START_REG)) {
                    this.resolveImage(data, (XWPFTableCell)cell, text);
                    continue;
                }
                if (text.startsWith(PDF_WORD_SUBTABLE_IMAGE_START_REG2)) {
                    this.resolveImageWithSize(data, (XWPFTableCell)cell, text);
                    continue;
                }
                if (text.endsWith(PDF_WORD_SUBTABLE_INDEX_END_REG)) {
                    this.resolveExpandTable(data, (XWPFTableCell)cell, text);
                    continue;
                }
                if (text.startsWith(PDF_WORD_SUBTABLE_INNERTABLE_START_REG)) {
                    subTableIndex = this.resolveInnerTable(subTableIndex, (XWPFTableCell)cell, text);
                    continue;
                }
                if (!text.startsWith(PDF_WORD_SUBTABLE_CELL_START3_REG)) continue;
                this.resolveFirstTable(data, (XWPFTableCell)cell, text);
            }
        }
    }

    private void resolveImage(List<Map<String, Object>> data, XWPFTableCell cell, String text) {
        int indexNum = 0;
        String index = this.splitStr(text, PDF_WORD_SUBTABLE_INDEX_REG);
        if (StringUtils.isNotBlank((CharSequence)index)) {
            index = index.replace(PDF_WORD_SUBTABLE_INDEX_START_REG, "");
            indexNum = Integer.parseInt(index);
        }
        String cellName = this.splitStr(text, PDF_WORD_SUBTABLE_IMAGE_REG);
        this.insertPicture(data, cell, indexNum, cellName, 60, 60);
    }

    private void resolveImageWithSize(List<Map<String, Object>> data, XWPFTableCell cell, String text) {
        int indexNum;
        String cellName;
        int width = 60;
        int height = 60;
        if (this.isMatch(text, "_[0-9]+_[0-9]+")) {
            String[] arr = text.split("_");
            if (null == arr || arr.length < 4 || arr.length > 5) {
                LOGGER.error("PDF\u3001Word\u5904\u7406\u56fe\u7247\u51fa\u9519\uff0c\u6a21\u677f\u672a\u8bbe\u7f6e\u6b63\u786e\u683c\u5f0f");
                return;
            }
            cellName = arr[1];
            width = Integer.parseInt(arr[2]);
            height = Integer.parseInt(arr[3]);
            indexNum = 4 == arr.length ? 0 : this.getIndexNum(arr[4]);
        } else {
            indexNum = this.getIndexNum(text);
            cellName = text.split("_")[1].split(PDF_WORD_SUBTABLE_INDEX_START_REG)[0];
        }
        this.insertPicture(data, cell, indexNum, cellName, width, height);
    }

    private void insertPicture(List<Map<String, Object>> data, XWPFTableCell cell, int indexNum, String cellName, int width, int height) {
        List paragraphs = cell.getParagraphs();
        Iterator it = paragraphs.iterator();
        int pos = paragraphs.size() - 1;
        while (it.hasNext()) {
            cell.removeParagraph(pos--);
        }
        XWPFParagraph paragraph = cell.addParagraph();
        paragraph.setAlignment(ParagraphAlignment.CENTER);
        XWPFRun run = paragraph.createRun();
        try {
            String pictureUrl = (String)data.get(indexNum).get(cellName);
            if (StringUtils.isBlank((CharSequence)pictureUrl)) {
                LOGGER.error("\u5bfc\u51faPDF\u3001WORD\u5904\u7406\u5b50\u8868\u56fe\u7247\u5931\u8d25\uff0c\u5b57\u6bb5\u540d\u79f0\uff1a{}\uff0c\u56e0\u4e3a\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u6570\u636e", (Object)cellName);
                return;
            }
            byte[] imageByteData = this.readRemoteFileToByteArray(pictureUrl);
            if (null != imageByteData) {
                run.addPicture((InputStream)new ByteArrayInputStream(imageByteData), 6, cellName, Units.toEMU((double)width), Units.toEMU((double)height));
            }
        }
        catch (Exception exception) {
            LOGGER.error("\u5bfc\u51faPDF\u3001WORD\u5904\u7406\u5b50\u8868\u56fe\u7247\u5931\u8d25\uff0c\u5b57\u6bb5\u540d\u79f0\uff1a{}\uff0c{}", (Object)cellName, (Object)exception.getMessage());
        }
    }

    private int getIndexNum(String text) {
        int indexNum = 0;
        String index = this.splitStr(text, PDF_WORD_SUBTABLE_INDEX_REG);
        if (StringUtils.isNotBlank((CharSequence)index)) {
            index = index.replace(PDF_WORD_SUBTABLE_INDEX_START_REG, "").replace(PDF_WORD_SUBTABLE_CELL_END_REG, "");
            indexNum = Integer.parseInt(index);
        }
        return indexNum;
    }

    private void resolveFirstTable(List<Map<String, Object>> data, XWPFTableCell cell, String text) {
        String cellName = this.splitStr(text, PDF_WORD_SUBTABLE_CELL_REG);
        String val = (String)data.get(0).get(cellName);
        if (!StringUtils.isEmpty((CharSequence)val) && val.contains("&HH&")) {
            this.addBreakInCell(cell, val);
        } else {
            cell.setText(val);
        }
    }

    private void addBreakInCell(XWPFTableCell cell, String value) {
        try {
            String[] valueSplit = value.split("&HH&");
            for (int i = 0; i < valueSplit.length; ++i) {
                cell.getXWPFDocument().createParagraph();
                XWPFParagraph paragraph = (XWPFParagraph)cell.getParagraphs().get(0);
                XWPFRun run = paragraph.createRun();
                run.setText(valueSplit[i]);
                if (i < valueSplit.length - 1) {
                    run.addBreak();
                }
                paragraph.addRun(run);
                paragraph.setSpacingBefore(15);
                paragraph.setSpacingBetween(10.0, LineSpacingRule.EXACT);
                paragraph.setSpacingAfter(15);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6587\u6863\u6362\u884c\u5f02\u5e38", (Throwable)e);
        }
    }

    private void resolveExpandTable(List<Map<String, Object>> data, XWPFTableCell cell, String text) {
        XWPFParagraph paragraph;
        String index = this.splitStr(text, PDF_WORD_SUBTABLE_INDEX_REG);
        if (StringUtils.isBlank((CharSequence)index)) {
            throw new DysjyException("\u6587\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        index = index.replace(PDF_WORD_SUBTABLE_INDEX_START_REG, "");
        String cellName = this.splitStr(text, PDF_WORD_SUBTABLE_CELL_START_REG);
        String val = (String)data.get(Integer.valueOf(index)).get(cellName);
        if (CollectionUtils.isNotEmpty((Collection)cell.getParagraphs()) && CollectionUtils.isNotEmpty((Collection)(paragraph = (XWPFParagraph)cell.getParagraphs().get(0)).getRuns())) {
            paragraph.removeRun(0);
            XWPFRun run = paragraph.createRun();
            run.setText(val);
        }
    }

    private int resolveInnerTable(int subTableIndex, XWPFTableCell cell, String text) {
        String[] arr = text.replace(PDF_WORD_SUBTABLE_CELL_START3_REG, "").replace(PDF_WORD_SUBTABLE_CELL_END_REG, "").split(PDF_WORD_CELL_TEXT_SPLIT);
        if (null == arr || arr.length < 2) {
            return subTableIndex;
        }
        String subTableId = arr[0] + "_" + subTableIndex;
        List subTableData = (List)this.officeData.get(subTableId);
        if (CollectionUtils.isEmpty((Collection)subTableData)) {
            this.setCellText(cell, "");
            return ++subTableIndex;
        }
        String items = arr[1];
        String[] itemsArr = items.split(":");
        if (null == itemsArr) {
            return subTableIndex;
        }
        int rowNum = subTableData.size();
        int colNum = itemsArr.length;
        List paragraphs = cell.getParagraphs();
        Iterator it = paragraphs.iterator();
        int pos = paragraphs.size() - 1;
        CTTcPr ctTcPr = cell.getCTTc().getTcPr();
        while (it.hasNext()) {
            cell.removeParagraph(pos--);
        }
        XWPFParagraph paragraph = cell.addParagraph();
        XWPFRun run = paragraph.createRun();
        XWPFTable subTable = ((NiceXWPFDocument)cell.getXWPFDocument()).insertNewTable(run, rowNum, colNum);
        subTable.setLeftBorder(XWPFTable.XWPFBorderType.SINGLE, 2, 0, "000000");
        subTable.setLeftBorder(XWPFTable.XWPFBorderType.SINGLE, 2, 0, "000000");
        subTable.setRightBorder(XWPFTable.XWPFBorderType.SINGLE, 2, 0, "000000");
        subTable.setTopBorder(XWPFTable.XWPFBorderType.SINGLE, 2, 0, "000000");
        subTable.setBottomBorder(XWPFTable.XWPFBorderType.SINGLE, 2, 0, "000000");
        subTable.setInsideHBorder(XWPFTable.XWPFBorderType.SINGLE, 2, 0, "000000");
        subTable.setInsideVBorder(XWPFTable.XWPFBorderType.SINGLE, 2, 0, "000000");
        CTTblPr ctTblPr = subTable.getCTTbl().getTblPr();
        ctTblPr.getTblW().setType(STTblWidth.PCT);
        ctTblPr.getTblW().setW(ctTcPr.getTcW().getW());
        for (int r = 0; r < rowNum; ++r) {
            for (int c = 0; c < colNum; ++c) {
                XWPFParagraph p1 = subTable.getRow(r).getCell(c).addParagraph();
                p1.setAlignment(ParagraphAlignment.CENTER);
                p1.setVerticalAlignment(TextAlignment.CENTER);
                XWPFRun r1 = p1.createRun();
                r1.setText(String.valueOf(((Map)subTableData.get(r)).get(itemsArr[c].toLowerCase())));
                r1.setFontSize(10);
            }
        }
        List newParagraphs = cell.getParagraphs();
        if (CollectionUtils.isNotEmpty((Collection)newParagraphs)) {
            cell.removeParagraph(newParagraphs.size() - 1);
        }
        return ++subTableIndex;
    }

    private void setCellText(XWPFTableCell cell, String text) {
        List paragraphs = cell.getParagraphs();
        if (CollectionUtils.isNotEmpty((Collection)paragraphs)) {
            Iterator it = paragraphs.iterator();
            int pos = paragraphs.size() - 1;
            while (it.hasNext()) {
                cell.removeParagraph(pos--);
            }
        }
        XWPFParagraph paragraph = cell.addParagraph();
        paragraph.setAlignment(ParagraphAlignment.CENTER);
        XWPFRun run = paragraph.createRun();
        run.setText(text);
    }

    private void resolveCheckBox(List<Map<String, Object>> data, XWPFTableCell cell, String text, int checkBoxIndex) {
        int indexNum = 0;
        if (StringUtils.contains((CharSequence)text, (CharSequence)PDF_WORD_SUBTABLE_INDEX_END_REG)) {
            String index = this.splitStr(text, PDF_WORD_SUBTABLE_INDEX_REG);
            if (StringUtils.isNotBlank((CharSequence)index)) {
                index = index.replace(PDF_WORD_SUBTABLE_INDEX_START_REG, "");
                indexNum = Integer.parseInt(index);
            }
        } else {
            indexNum = checkBoxIndex;
        }
        String cellName = this.splitStr(text, PDF_WORD_SUBTABLE_CHECKBOX_REG);
        String info = text.replaceAll(PDF_WORD_SUBTABLE_CHECKBOX_ALL_REG, "");
        List paragraphs = cell.getParagraphs();
        Iterator it = paragraphs.iterator();
        int pos = paragraphs.size() - 1;
        while (it.hasNext()) {
            cell.removeParagraph(pos--);
        }
        XWPFParagraph paragraph = cell.addParagraph();
        paragraph.setAlignment(ParagraphAlignment.LEFT);
        XWPFRun run = paragraph.createRun();
        try {
            String pictureName = (String)data.get(indexNum).get(cellName);
            if (StringUtils.isBlank((CharSequence)pictureName)) {
                LOGGER.error("\u5bfc\u51faPDF\u3001WORD\u5904\u7406\u5b50\u8868\u590d\u9009\u6846\u5931\u8d25\uff0c\u5b57\u6bb5\u540d\u79f0\uff1a{}\uff0c\u56e0\u4e3a\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u6570\u636e", (Object)cellName);
                return;
            }
            byte[] checkBoxData = StringUtils.equals((CharSequence)pictureName, (CharSequence)"CheckboxY.png") ? SpireDataServiceImpl.checkBoxY : SpireDataServiceImpl.checkBoxN;
            run.addPicture((InputStream)new ByteArrayInputStream(checkBoxData), 6, cellName, 12, 12);
            XWPFRun infoRun = paragraph.createRun();
            infoRun.setText(info);
        }
        catch (Exception exception) {
            LOGGER.error("\u5bfc\u51faPDF\u3001WORD\u5904\u7406\u5b50\u8868\u590d\u9009\u6846\u5931\u8d25\uff0c\u5b57\u6bb5\u540d\u79f0\uff1a{}\uff0c{}", (Object)cellName, (Object)exception.getMessage());
        }
    }

    public static void copyRow(XWPFTable table, XWPFTableRow sourceRow, int rowIndex, List<String> nameList, Map<String, Object> valueMap) {
        XWPFTableRow targetRow = table.insertNewTableRow(rowIndex);
        List cellList = sourceRow.getTableCells();
        if (null == cellList) {
            return;
        }
        XWPFTableCell targetCell = null;
        int index = 0;
        for (XWPFTableCell sourceCell : cellList) {
            targetCell = targetRow.addNewTableCell();
            targetCell.getCTTc().setTcPr(sourceCell.getCTTc().getTcPr());
            String valueString = null;
            Object value = valueMap.get(nameList.get(index));
            if (Objects.nonNull(value)) {
                valueString = String.valueOf(value);
            }
            if (sourceCell.getParagraphs() != null && sourceCell.getParagraphs().size() > 0) {
                ((XWPFParagraph)targetCell.getParagraphs().get(0)).getCTP().setPPr(((XWPFParagraph)sourceCell.getParagraphs().get(0)).getCTP().getPPr());
                if (((XWPFParagraph)sourceCell.getParagraphs().get(0)).getRuns() != null && ((XWPFParagraph)sourceCell.getParagraphs().get(0)).getRuns().size() > 0) {
                    XWPFRun cellR = ((XWPFParagraph)targetCell.getParagraphs().get(0)).createRun();
                    cellR.setText(valueString);
                    cellR.setBold(((XWPFRun)((XWPFParagraph)sourceCell.getParagraphs().get(0)).getRuns().get(0)).isBold());
                    cellR.getCTR().setRPr(((XWPFRun)((XWPFParagraph)sourceCell.getParagraphs().get(0)).getRuns().get(0)).getCTR().getRPr());
                } else {
                    targetCell.setText(valueString);
                }
            } else {
                targetCell.setText(valueString);
            }
            ++index;
        }
    }

    private void resolveGeneralTable(XWPFTable table, List<Map<String, Object>> data) {
        List<String> cellNameList = this.getTableCellName(table);
        if (CollectionUtils.isEmpty(cellNameList)) {
            return;
        }
        List<Map<String, Object>> labors = data;
        if (CollectionUtils.isNotEmpty(labors)) {
            for (int i = labors.size() - 1; i >= 0; --i) {
                Map<String, Object> valueMap = labors.get(i);
                SpireDocTablePolicy.copyRow(table, table.getRow(1), 2, cellNameList, valueMap);
            }
            table.removeRow(1);
        }
    }

    private String getTableName(XWPFTable table) {
        Pattern pattern = Pattern.compile(PDF_WORD_SUBTABLE_NAME_REG);
        Matcher matcher = pattern.matcher(table.getText());
        String tableName = "";
        if (matcher.find()) {
            tableName = matcher.group();
        }
        return tableName.replace(PDF_WORD_SUBTABLE_CELL_START3_REG, "").replace(PDF_WORD_SUBTABLE_CELL_END_REG, "");
    }

    private List<String> getTableCellName(XWPFTable table) {
        String text = table.getText();
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        Pattern pattern = Pattern.compile(PDF_WORD_SUBTABLE_CELL_REG);
        Matcher matcher = pattern.matcher(text);
        ArrayList<String> cellNameList = new ArrayList<String>(10);
        while (matcher.find()) {
            cellNameList.add(matcher.group().replace(PDF_WORD_SUBTABLE_CELL_START2_REG, "").replace(PDF_WORD_SUBTABLE_CELL_END_REG, ""));
        }
        return cellNameList;
    }

    private String splitStr(String str, String reg) {
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(str);
        if (matcher.find()) {
            return matcher.group().replace(PDF_WORD_SUBTABLE_CELL_START2_REG, "").replace(PDF_WORD_SUBTABLE_CHECKBOX_START_REG, "").replace(PDF_WORD_SUBTABLE_IMAGE_START_REG, "").replace(PDF_WORD_SUBTABLE_CELL_END_REG, "");
        }
        return null;
    }

    private boolean isMatch(String str, String reg) {
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readRemoteFileToByteArray(String filePath) {
        File file = new File(UUIDGenerator.generate16() + ".png");
        try {
            FileUtils.copyURLToFile((URL)new URIBuilder(filePath).build().toURL(), (File)file);
            byte[] byArray = FileUtils.readFileToByteArray((File)file);
            return byArray;
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u51faPDF\u3001WORD\u83b7\u53d6\u8fdc\u7a0b\u56fe\u7247\u6587\u4ef6\u5931\u8d25\uff0c\u6587\u4ef6\uff1a{}", (Object)filePath);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (file.exists()) {
                file.delete();
            }
        }
    }

    static {
        TABLE_ROW_STYLE.setAlign(STJc.CENTER);
    }
}

