/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landsale.web.freemarker;

import cn.gtmap.egovplat.core.data.Page;
import cn.gtmap.egovplat.core.data.PageRequest;
import cn.gtmap.egovplat.core.data.Pageable;
import cn.gtmap.landsale.model.TransCrgg;
import cn.gtmap.landsale.model.TransResource;
import cn.gtmap.landsale.model.TransResourceApply;
import cn.gtmap.landsale.security.SecUtil;
import cn.gtmap.landsale.service.TransCrggService;
import cn.gtmap.landsale.service.TransResourceApplyService;
import cn.gtmap.landsale.service.TransResourceService;
import com.google.common.collect.Sets;
import java.util.Calendar;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;

public class ResourceUtil {
    TransResourceService transResourceService;
    TransCrggService transCrggService;
    TransResourceApplyService transResourceApplyService;

    public void setTransResourceApplyService(TransResourceApplyService transResourceApplyService) {
        this.transResourceApplyService = transResourceApplyService;
    }

    public void setTransResourceService(TransResourceService transResourceService) {
        this.transResourceService = transResourceService;
    }

    public void setTransCrggService(TransCrggService transCrggService) {
        this.transCrggService = transCrggService;
    }

    public TransResource getResource(String resourceId) {
        return this.transResourceService.getTransResource(resourceId);
    }

    public TransResourceApply getResourceApply(String applyId) {
        return this.transResourceApplyService.getTransResourceApply(applyId);
    }

    public TransCrgg getCrgg(String ggId) {
        return StringUtils.isNotBlank((CharSequence)ggId) ? this.transCrggService.getTransCrgg(ggId) : null;
    }

    public TransResourceApply limitTimeOffer(String resourceId) {
        TransResourceApply transResourceApply;
        TransResource transResource = this.transResourceService.getTransResource(resourceId);
        if (Calendar.getInstance().getTime().before(transResource.getGpEndTime()) && transResource.getGpEndTime().getTime() - Calendar.getInstance().getTime().getTime() < 3600000L && (transResourceApply = this.transResourceApplyService.getTransResourceApplyByUserId(SecUtil.getLoginUserId(), resourceId)).getApplyStep() == 3) {
            return transResourceApply;
        }
        return null;
    }

    public int getApplyCountByStauts() {
        String userId = SecUtil.getLoginUserId();
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            HashSet regions = Sets.newHashSet();
            Page<TransResource> transResourcePage = this.transResourceService.findTransResourcesByUser(userId, 2, regions, (Pageable)new PageRequest(0, 50));
            return transResourcePage.getItems().size();
        }
        return 0;
    }
}

