/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landsale.web.freemarker;

import cn.gtmap.egovplat.core.data.Page;
import cn.gtmap.egovplat.core.data.PageRequest;
import cn.gtmap.egovplat.core.data.Pageable;
import cn.gtmap.landsale.model.TransCrgg;
import cn.gtmap.landsale.model.TransResource;
import cn.gtmap.landsale.model.TransResourceApply;
import cn.gtmap.landsale.model.TransUser;
import cn.gtmap.landsale.security.SecUtil;
import cn.gtmap.landsale.service.TransCrggService;
import cn.gtmap.landsale.service.TransKjzbKjyService;
import cn.gtmap.landsale.service.TransRequestService;
import cn.gtmap.landsale.service.TransResourceApplyService;
import cn.gtmap.landsale.service.TransResourceService;
import cn.gtmap.landsale.service.TransUserService;
import com.google.common.collect.Sets;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ResourceUtil {
    Map<String, String> map = new ConcurrentHashMap<String, String>();
    TransResourceService transResourceService;
    TransCrggService transCrggService;
    TransResourceApplyService transResourceApplyService;
    TransKjzbKjyService transKjzbKjyService;
    TransRequestService transRequestService;
    TransUserService transUserService;

    public void setTransResourceApplyService(TransResourceApplyService transResourceApplyService) {
        this.transResourceApplyService = transResourceApplyService;
    }

    public void setTransResourceService(TransResourceService transResourceService) {
        this.transResourceService = transResourceService;
    }

    public void setTransKjzbKjyService(TransKjzbKjyService transKjzbKjyService) {
        this.transKjzbKjyService = transKjzbKjyService;
    }

    public void setTransRequestService(TransRequestService transRequestService) {
        this.transRequestService = transRequestService;
    }

    public void setTransUserService(TransUserService transUserService) {
        this.transUserService = transUserService;
    }

    public void setTransCrggService(TransCrggService transCrggService) {
        this.transCrggService = transCrggService;
    }

    public TransResource getResource(String resourceId) {
        return this.transResourceService.getTransResource(resourceId);
    }

    public TransResourceApply getResourceApply(String applyId) {
        return this.transResourceApplyService.getTransResourceApply(applyId);
    }

    public TransCrgg getCrgg(String ggId) {
        return StringUtils.isNotBlank((CharSequence)ggId) ? this.transCrggService.getTransCrgg(ggId) : null;
    }

    public TransResourceApply limitTimeOffer(String resourceId) {
        TransResourceApply transResourceApply;
        TransResource transResource = this.transResourceService.getTransResource(resourceId);
        if (Calendar.getInstance().getTime().before(transResource.getGpEndTime()) && transResource.getGpEndTime().getTime() - Calendar.getInstance().getTime().getTime() < 3600000L && (transResourceApply = this.transResourceApplyService.getTransResourceApplyByUserId(SecUtil.getLoginUserId(), resourceId)).getApplyStep() == 3) {
            return transResourceApply;
        }
        return null;
    }

    public int getApplyCountByStauts() {
        String userId = SecUtil.getLoginUserId();
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            HashSet regions = Sets.newHashSet();
            Page<TransResource> transResourcePage = this.transResourceService.findTransResourcesByUser(userId, 2, regions, (Pageable)new PageRequest(0, 50));
            return transResourcePage.getItems().size();
        }
        return 0;
    }

    public int getJfshIngCountByStatus(int jfzhsqStatus) {
        String userId = SecUtil.getLoginUserId();
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            this.map.clear();
            this.map.put("jfzhsqStatus", String.valueOf(jfzhsqStatus));
            return this.transResourceService.countResourceByParam(this.map);
        }
        return 0;
    }

    public int getTransResourceApply(String resourceId, int applyStep) {
        if (StringUtils.isNotBlank((CharSequence)resourceId) && null != this.transResourceApplyService.getTransResourceApplyStep(resourceId, applyStep)) {
            return this.transResourceApplyService.getTransResourceApplyStep(resourceId, applyStep).size();
        }
        return 0;
    }

    public int getStatusByZbType(String zbType, int status) {
        String userId = SecUtil.getLoginUserId();
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            this.map.clear();
            this.map.put("status", String.valueOf(status));
            this.map.put("zbType", String.valueOf(zbType));
            return this.transRequestService.countRequestByParam(this.map);
        }
        return 0;
    }

    public int getPreReleaseCount() {
        String userId = SecUtil.getLoginUserId();
        TransUser transUser = this.transUserService.getTransUser(userId);
        List<TransResource> transResourceList = this.transResourceService.getTransResourcesOnPreReleaseByRegion(transUser.getRegionCode());
        if (CollectionUtils.isEmpty(transResourceList)) {
            return 0;
        }
        return transResourceList.size();
    }
}

