/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landsale.mq;

import cn.gtmap.landsale.model.TransResourceOffer;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.springframework.web.context.request.async.DeferredResult;

public class ResourceQueue {
    private String resourceId;
    final Queue<DeferredResult<String>> realTimeQueue = new ConcurrentLinkedQueue<DeferredResult<String>>();

    public ResourceQueue(String resourceId) {
        this.resourceId = resourceId;
    }

    public void addClient(final DeferredResult<String> clientReuslt) {
        clientReuslt.onCompletion(new Runnable(){

            @Override
            public void run() {
                ResourceQueue.this.realTimeQueue.remove(clientReuslt);
            }
        });
        clientReuslt.onTimeout(new Runnable(){

            @Override
            public void run() {
                HashMap resultMap = Maps.newHashMap();
                resultMap.put("time", Calendar.getInstance().getTime().getTime());
                resultMap.put("result", null);
                clientReuslt.setResult((Object)JSON.toJSONString((Object)resultMap));
            }
        });
        this.realTimeQueue.add(clientReuslt);
    }

    public void writeClient(TransResourceOffer transResourceOffer) {
        ArrayList resourceOfferList = Lists.newArrayList();
        resourceOfferList.add(transResourceOffer);
        HashMap resultMap = Maps.newHashMap();
        resultMap.put("time", Calendar.getInstance().getTime().getTime());
        resultMap.put("result", resourceOfferList);
        for (DeferredResult deferredResult : this.realTimeQueue) {
            deferredResult.setResult((Object)JSON.toJSONString((Object)resultMap));
        }
    }
}

