/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landsale.mq;

import cn.gtmap.landsale.model.TransResource;
import cn.gtmap.landsale.model.TransResourceOffer;
import cn.gtmap.landsale.mq.ResourceOfferQueueService;
import cn.gtmap.landsale.mq.ResourceQueue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.web.context.request.async.DeferredResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceOfferQueueServiceImpl
implements ResourceOfferQueueService {
    private Map<String, ResourceQueue> resourceQueueMap = new ConcurrentHashMap<String, ResourceQueue>();

    @Override
    public void addResource(TransResource resource, DeferredResult<String> clientReuslt) {
        ResourceQueue resourceQueue = null;
        if (this.resourceQueueMap.get(resource.getResourceId()) == null) {
            resourceQueue = new ResourceQueue(resource.getResourceId());
            this.resourceQueueMap.put(resource.getResourceId(), resourceQueue);
        } else {
            resourceQueue = this.resourceQueueMap.get(resource.getResourceId());
        }
        resourceQueue.addClient(clientReuslt);
    }

    @Override
    public void receiveNewOffer(TransResourceOffer resourceOffer) {
        ResourceQueue resourceQueue = this.resourceQueueMap.get(resourceOffer.getResourceId());
        if (resourceQueue != null) {
            resourceQueue.writeClient(resourceOffer);
        }
    }
}

