/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landsale.log;

import cn.gtmap.egovplat.core.data.Pageable;
import cn.gtmap.egovplat.core.util.RequestUtils;
import cn.gtmap.landsale.Constants;
import cn.gtmap.landsale.log.AuditServiceLog;
import cn.gtmap.landsale.model.TransAuditLog;
import cn.gtmap.landsale.security.SecUtil;
import cn.gtmap.landsale.service.AuditLogService;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.ui.Model;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Aspect
public class AuditLogServiceAspect {
    private AuditLogService auditLogService;
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public void setAuditLogService(AuditLogService auditLogService) {
        this.auditLogService = auditLogService;
    }

    @Pointcut(value="@annotation(cn.gtmap.landsale.log.AuditServiceLog)")
    public void serviceAspect() {
    }

    @Before(value="serviceAspect()")
    public void doBefore(JoinPoint joinPoint) {
        AuditServiceLog auditControllerLog = this.getControllerLog(joinPoint);
        this.auditLog(auditControllerLog.producer(), auditControllerLog.category(), this.getAuditContent(joinPoint, auditControllerLog));
    }

    public AuditServiceLog getControllerLog(JoinPoint joinPoint) {
        try {
            Method[] methods;
            String targetName = joinPoint.getTarget().getClass().getName();
            String methodName = joinPoint.getSignature().getName();
            Object[] arguments = joinPoint.getArgs();
            Class<?> targetClass = Class.forName(targetName);
            for (Method method : methods = targetClass.getMethods()) {
                Class<?>[] clazzs;
                if (!method.getName().equals(methodName) || (clazzs = method.getParameterTypes()).length != arguments.length) continue;
                return method.getAnnotation(AuditServiceLog.class);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void auditLog(Constants.LogProducer producer, Constants.LogCategory category, String content) {
        final TransAuditLog transAuditLog = new TransAuditLog();
        transAuditLog.setProducer(producer);
        transAuditLog.setCategory(category);
        transAuditLog.setContent(content);
        ServletRequestAttributes sra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (sra != null) {
            transAuditLog.setIp(RequestUtils.getClientIP((HttpServletRequest)sra.getRequest()));
        }
        transAuditLog.setUserId(SecUtil.getLoginUserId());
        transAuditLog.setUserViewName(SecUtil.getLoginUserViewName());
        this.executor.submit(new Runnable(){

            public void run() {
                AuditLogServiceAspect.this.auditLogService.saveAuditLog(transAuditLog);
            }
        });
    }

    private String getAuditContent(JoinPoint joinPoint, AuditServiceLog auditServiceLog) {
        HashMap contentMap = Maps.newHashMap();
        String description = null;
        description = StringUtils.isNotBlank((CharSequence)auditServiceLog.description()) ? auditServiceLog.description() : "\u64cd\u4f5c\u5185\u5bb9";
        contentMap.put(description, this.filterArguments(joinPoint.getArgs()));
        return JSON.toJSONString((Object)contentMap);
    }

    private Object filterArguments(Object[] args) {
        ArrayList arguments = Lists.newArrayList();
        for (Object arg : args) {
            if (arg instanceof Model || arg instanceof Pageable || arg instanceof RedirectAttributes || arg instanceof HttpServletResponse || arg instanceof HttpServletRequest) continue;
            arguments.add(arg);
        }
        return arguments;
    }
}

