/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landsale.web.freemarker;

import cn.gtmap.egovplat.core.data.Page;
import cn.gtmap.egovplat.core.data.PageRequest;
import cn.gtmap.egovplat.core.data.Pageable;
import cn.gtmap.landsale.model.TransCrgg;
import cn.gtmap.landsale.model.TransResource;
import cn.gtmap.landsale.model.TransResourceApply;
import cn.gtmap.landsale.model.TransResourceOffer;
import cn.gtmap.landsale.model.VTransResource;
import cn.gtmap.landsale.model.VTransResourceOffer;
import cn.gtmap.landsale.security.SecUtil;
import cn.gtmap.landsale.service.RegionService;
import cn.gtmap.landsale.service.TransCrggService;
import cn.gtmap.landsale.service.TransResourceApplyService;
import cn.gtmap.landsale.service.TransResourceOfferService;
import cn.gtmap.landsale.service.TransResourceService;
import cn.gtmap.landsale.service.VTransResourceOfferService;
import cn.gtmap.landsale.service.VTransResourceService;
import com.google.common.collect.Sets;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ResourceUtil {
    TransResourceService transResourceService;
    VTransResourceService vTransResourceService;
    TransCrggService transCrggService;
    TransResourceApplyService transResourceApplyService;
    TransResourceOfferService transResourceOfferService;
    VTransResourceOfferService vTransResourceOfferService;
    RegionService regionService;

    public void setTransResourceApplyService(TransResourceApplyService transResourceApplyService) {
        this.transResourceApplyService = transResourceApplyService;
    }

    public void setTransResourceService(TransResourceService transResourceService) {
        this.transResourceService = transResourceService;
    }

    public void setVTransResourceService(VTransResourceService vTransResourceService) {
        this.vTransResourceService = vTransResourceService;
    }

    public void setRegionService(RegionService regionService) {
        this.regionService = regionService;
    }

    public void setTransCrggService(TransCrggService transCrggService) {
        this.transCrggService = transCrggService;
    }

    public void setTransResourceOfferService(TransResourceOfferService transResourceOfferService) {
        this.transResourceOfferService = transResourceOfferService;
    }

    public void setVTransResourceOfferService(VTransResourceOfferService vTransResourceOfferService) {
        this.vTransResourceOfferService = vTransResourceOfferService;
    }

    public TransResource getResource(String resourceId) {
        return this.transResourceService.getTransResource(resourceId);
    }

    public VTransResource getVTransResource(String resourceId) {
        return this.vTransResourceService.getVTransResource(resourceId);
    }

    public TransResourceApply getResourceApply(String applyId) {
        return this.transResourceApplyService.getTransResourceApply(applyId);
    }

    public TransCrgg getCrgg(String ggId) {
        return StringUtils.isNotBlank((CharSequence)ggId) ? this.transCrggService.getTransCrgg(ggId) : null;
    }

    public TransResourceApply limitTimeOffer(String resourceId) {
        TransResourceApply transResourceApply;
        TransResource transResource = this.transResourceService.getTransResource(resourceId);
        if (Calendar.getInstance().getTime().before(transResource.getGpEndTime()) && transResource.getGpEndTime().getTime() - Calendar.getInstance().getTime().getTime() < 3600000L && (transResourceApply = this.transResourceApplyService.getTransResourceApplyByUserId(SecUtil.getLoginUserId(), resourceId)).getApplyStep() == 3) {
            return transResourceApply;
        }
        return null;
    }

    public int getApplyCountByStauts() {
        String userId = SecUtil.getLoginUserId();
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            HashSet regions = Sets.newHashSet();
            Page<TransResource> transResourcePage = this.transResourceService.findTransResourcesByUser(userId, 2, regions, (Pageable)new PageRequest(0, 50));
            return transResourcePage.getItems().size();
        }
        return 0;
    }

    public boolean isMaxLimitedOffer(String resourceId) {
        boolean result = false;
        TransResource transResource = this.transResourceService.getTransResource(resourceId);
        TransResourceOffer maxOffer = this.transResourceOfferService.getMaxOffer(resourceId);
        if (transResource.getYaohao() == 1 && transResource.getMaxOffer() != null && maxOffer != null && maxOffer.getOfferPrice() >= transResource.getMaxOffer() && transResource.getMaxOffer() > 0.0) {
            return true;
        }
        return result;
    }

    public boolean isVMaxLimitedOffer(String resourceId) {
        boolean result = false;
        VTransResource vTransResource = this.vTransResourceService.getVTransResource(resourceId);
        VTransResourceOffer maxOffer = this.vTransResourceOfferService.getVMaxOffer(resourceId);
        if (vTransResource.getYaohao() == 1 && vTransResource.getMaxOffer() != null && maxOffer != null && maxOffer.getOfferPrice() >= vTransResource.getMaxOffer() && vTransResource.getMaxOffer() > 0.0) {
            return true;
        }
        return result;
    }

    public boolean isGPUsefulOffer(String resourceId, String userId) {
        boolean result = false;
        TransResource transResource = this.transResourceService.getTransResource(resourceId);
        List<TransResourceOffer> offers = this.transResourceOfferService.getGPOfferListByResource(resourceId);
        boolean offered = false;
        Double offerPrice = 0.0;
        if (offers != null) {
            for (TransResourceOffer offer : offers) {
                if (offer.getOfferPrice() > offerPrice) {
                    offerPrice = offer.getOfferPrice();
                }
                if (offered || !offer.getUserId().equals(userId)) continue;
                offered = true;
            }
        }
        if (transResource.getYaohao() == 1) {
            if (offerPrice < transResource.getMaxOffer()) {
                if (offered) {
                    result = true;
                }
            } else {
                result = true;
            }
        } else {
            result = offered;
        }
        return result;
    }

    public String getXzqByRegionode(String regionCode) {
        String regionName = "";
        try {
            regionName = regionCode.equals("320411") ? this.regionService.getDefaultRegionName() : this.regionService.getRegionName(regionCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return StringUtils.isNotBlank((CharSequence)regionName) && regionName.equals("\u5e38\u5dde\u5e02") ? "" : regionName;
    }
}

