/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landsale.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class CommonDateParseUtil {
    public static final String ENG_DATE_FROMAT = "EEE, d MMM yyyy HH:mm:ss z";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";
    public static final String YYYYMMDD_HH_MM = "yyyy/MM/dd HH:mm";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String HH_MM = "HH:mm";
    public static final String YYYY = "yyyy";
    public static final String MM = "MM";
    public static final String HH = "HH";

    public static Date date2date(Date date, String formatStr) {
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        String str = sdf.format(date);
        try {
            date = sdf.parse(str);
        }
        catch (Exception e) {
            return null;
        }
        return date;
    }

    public static String date2string(Date date, String formatStr) {
        String strDate = "";
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        strDate = sdf.format(date);
        return strDate;
    }

    public static String timestamp2string(Timestamp timestamp, String formatStr) {
        String strDate = "";
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        strDate = sdf.format(timestamp);
        return strDate;
    }

    public static Date string2date(String dateString, String formatStr) {
        Date formateDate = null;
        SimpleDateFormat format = new SimpleDateFormat(formatStr);
        try {
            formateDate = format.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
        return formateDate;
    }

    public static Timestamp date2timestamp(Date date) {
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public static String getNowYear() {
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY);
        return sdf.format(new Date());
    }

    public static String getNowMonth() {
        SimpleDateFormat sdf = new SimpleDateFormat(MM);
        return sdf.format(new Date());
    }

    public static int getNowHour() {
        SimpleDateFormat sdf = new SimpleDateFormat(HH);
        return Integer.valueOf(sdf.format(new Date()));
    }

    public static int getWeekOfDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int w = cal.get(7) - 1 == 0 ? 7 : cal.get(7) - 1;
        return w;
    }

    public static String getLnow(long time) {
        Calendar cal = Calendar.getInstance();
        long timel = cal.getTimeInMillis() - time;
        if (timel / 1000L < 60L) {
            return "1\u5206\u949f\u4ee5\u5185";
        }
        if (timel / 1000L / 60L < 60L) {
            return timel / 1000L / 60L + "\u5206\u949f\u524d";
        }
        if (timel / 1000L / 60L / 60L < 24L) {
            return timel / 1000L / 60L / 60L + "\u5c0f\u65f6\u524d";
        }
        return timel / 1000L / 60L / 60L / 24L + "\u5929\u524d";
    }

    public static Date getDateFromSourceDate(Date currentDate, int num) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(currentDate);
        cal.add(5, num);
        return cal.getTime();
    }

    public static String firstDayOfMonth() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat datef = new SimpleDateFormat(YYYY_MM_DD);
        cal.set(5, 1);
        cal.roll(5, -1);
        cal.set(5, 1);
        Date beginTime = cal.getTime();
        String beginTime1 = datef.format(beginTime) + " 00:00:00";
        return beginTime1;
    }

    public static Date getFirstDayOfYearMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, 1);
        cal.roll(5, -1);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date getFirstDayOfYearQuarter(int year, int quarter) {
        int month = 1;
        if (quarter == 1) {
            month = 1;
        } else if (quarter == 2) {
            month = 4;
        } else if (quarter == 3) {
            month = 7;
        } else if (quarter == 4) {
            month = 10;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, 1);
        cal.roll(5, -1);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static String lastDayOfMonth() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat datef = new SimpleDateFormat(YYYY_MM_DD);
        cal.set(5, 1);
        cal.roll(5, -1);
        Date endTime = cal.getTime();
        String endTime1 = datef.format(endTime) + " 23:59:59";
        return endTime1;
    }

    public static int lastDayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        switch (cal.get(7)) {
            case 1: {
                cal.add(5, 0);
                break;
            }
            case 2: {
                cal.add(5, 6);
                break;
            }
            case 3: {
                cal.add(5, 5);
                break;
            }
            case 4: {
                cal.add(5, 4);
                break;
            }
            case 5: {
                cal.add(5, 3);
                break;
            }
            case 6: {
                cal.add(5, 2);
                break;
            }
            case 7: {
                cal.add(5, 1);
            }
        }
        return cal.get(5);
    }

    public static int firstDayOfWeek(Date date) {
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        switch (gc.get(7)) {
            case 1: {
                gc.add(5, -6);
                break;
            }
            case 2: {
                gc.add(5, 0);
                break;
            }
            case 3: {
                gc.add(5, -1);
                break;
            }
            case 4: {
                gc.add(5, -2);
                break;
            }
            case 5: {
                gc.add(5, -3);
                break;
            }
            case 6: {
                gc.add(5, -4);
                break;
            }
            case 7: {
                gc.add(5, -5);
            }
        }
        return gc.get(5);
    }

    public static Date getLastDayOfYearMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, 1);
        cal.roll(5, -1);
        return cal.getTime();
    }

    public static Date getLastDayOfYearQuarter(int year, int quarter) {
        int month = 1;
        if (quarter == 1) {
            month = 3;
        } else if (quarter == 2) {
            month = 6;
        } else if (quarter == 3) {
            month = 9;
        } else if (quarter == 4) {
            month = 12;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, 1);
        cal.roll(5, -1);
        return cal.getTime();
    }

    public static long differ(Date date1, Date date2) {
        Long differLong = date2.getTime() / 86400000L - date1.getTime() / 86400000L;
        return Math.abs(differLong);
    }

    public static long differMinute(Date date1, Date date2) {
        Long differLong = (date2.getTime() - date1.getTime()) / 60000L;
        return Math.abs(differLong);
    }

    public static Date getDateFromSourceDateWithMinute(Date currentDate, int num) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(currentDate);
        cal.add(12, num);
        return cal.getTime();
    }

    public static int getWeekInMonthNum(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(CommonDateParseUtil.getDateFromSourceDate(date, -1));
        int week = cal.get(4);
        return week;
    }

    public static int getMonthByDate(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        int month = cal.get(2) + 1;
        return month;
    }

    public static int getQuarterByDate(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        int month = cal.get(2) + 1;
        int quarter = month == 1 || month == 2 || month == 3 ? 1 : (month == 4 || month == 5 || month == 6 ? 2 : (month == 7 || month == 8 || month == 9 ? 3 : 4));
        return quarter;
    }

    public static int getYearByDate(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        int year = cal.get(1);
        return year;
    }

    public static int getMonthByDateForWeek(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int lastDay = CommonDateParseUtil.lastDayOfWeek(date);
        if (lastDay < day) {
            cal.add(2, 1);
            return cal.get(2) + 1;
        }
        return month;
    }

    public static int getQuarterByDateForWeek(Date date) {
        int quarter;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        int month = cal.get(2) + 1;
        int increment = 0;
        if (month == 3 || month == 6 || month == 9 || month == 12) {
            int day = cal.get(5);
            int lastday = CommonDateParseUtil.lastDayOfWeek(date);
            if (lastday < day) {
                ++increment;
            }
        }
        if ((quarter = month == 1 || month == 2 || month == 3 ? 1 + increment : (month == 4 || month == 5 || month == 6 ? 2 + increment : (month == 7 || month == 8 || month == 9 ? 3 + increment : 4 + increment))) > 4) {
            quarter = 1;
        }
        return quarter;
    }

    public static int getYearByDateForWeek(Date date) {
        int lastDay;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        if (month == 12 && (lastDay = CommonDateParseUtil.lastDayOfWeek(date)) < day) {
            ++year;
        }
        return year;
    }

    public static int getWeekByDateForWeek(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(CommonDateParseUtil.getDateFromSourceDate(date, -1));
        int week = cal.get(4);
        int day = cal.get(5);
        int lastDay = CommonDateParseUtil.lastDayOfWeek(date);
        if (lastDay < day) {
            week = 1;
        }
        return week;
    }

    public static void main(String[] args) throws ParseException {
        SimpleDateFormat datef = new SimpleDateFormat(YYYY_MM_DD);
        String date = "2013-07-01";
        System.out.println("\u8f93\u5165\u65e5\u671f\u4e3a\uff1a" + date);
        System.out.println("\u83b7\u53d6\u65e5\u671f\u4e3a\u8be5\u6708\u7684\u7b2c\u51e0\u5468:  " + CommonDateParseUtil.getWeekByDateForWeek(datef.parse(date)));
        System.out.println("\u83b7\u53d6\u65e5\u671f\u83b7\u53d6\u76f8\u5e94\u7684\u5e74\u4efd:  " + CommonDateParseUtil.getYearByDateForWeek(datef.parse(date)));
        System.out.println("\u83b7\u53d6\u65e5\u671f\u83b7\u53d6\u76f8\u5e94\u7684\u5b63\u5ea6:  " + CommonDateParseUtil.getQuarterByDateForWeek(datef.parse(date)));
        System.out.println("\u83b7\u53d6\u65e5\u671f\u83b7\u53d6\u6708\u4efd:  " + CommonDateParseUtil.getMonthByDateForWeek(datef.parse(date)));
    }
}

